/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.handler;

import cpw.mods.fml.common.registry.VillagerRegistry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import zeldaswordskills.api.block.IHookable;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.entity.ZSSVillagerInfo;
import zeldaswordskills.entity.npc.EntityGoron;
import zeldaswordskills.item.ItemHookShotUpgrade;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;

public class TradeHandler
implements VillagerRegistry.IVillageTradeHandler {
    public static final Map<List<Integer>, MerchantRecipe> hookshotAddonTrades = new HashMap<List<Integer>, MerchantRecipe>();

    public static final void addTradeToMap(ItemHookShotUpgrade.AddonType type, ItemStack stack, MerchantRecipe trade) {
        hookshotAddonTrades.put(Arrays.asList(type.ordinal(), Item.getIdFromItem((Item)stack.getItem()), stack.getItemDamage()), trade);
    }

    public static final MerchantRecipe getTrade(ItemHookShotUpgrade.AddonType type, ItemStack stack) {
        return hookshotAddonTrades.get(Arrays.asList(type.ordinal(), Item.getIdFromItem((Item)stack.getItem()), stack.getItemDamage()));
    }

    public static void registerTrades() {
        for (int i = 0; i < 5; ++i) {
            VillagerRegistry.instance().registerVillageTradeHandler(i, (VillagerRegistry.IVillageTradeHandler)new TradeHandler());
        }
        TradeHandler.addTradeToMap(ItemHookShotUpgrade.AddonType.EXTENSION, new ItemStack(ZSSItems.hookshot, 1, IHookable.HookshotType.WOOD_SHOT.ordinal()), new MerchantRecipe(new ItemStack(ZSSItems.hookshot, 1, IHookable.HookshotType.WOOD_SHOT.ordinal()), new ItemStack(ZSSItems.hookshotAddon, 1, ItemHookShotUpgrade.AddonType.EXTENSION.ordinal()), new ItemStack(ZSSItems.hookshot, 1, IHookable.HookshotType.WOOD_SHOT_EXT.ordinal())));
        TradeHandler.addTradeToMap(ItemHookShotUpgrade.AddonType.EXTENSION, new ItemStack(ZSSItems.hookshot, 1, IHookable.HookshotType.CLAW_SHOT.ordinal()), new MerchantRecipe(new ItemStack(ZSSItems.hookshot, 1, IHookable.HookshotType.CLAW_SHOT.ordinal()), new ItemStack(ZSSItems.hookshotAddon, 1, ItemHookShotUpgrade.AddonType.EXTENSION.ordinal()), new ItemStack(ZSSItems.hookshot, 1, IHookable.HookshotType.CLAW_SHOT_EXT.ordinal())));
        TradeHandler.addTradeToMap(ItemHookShotUpgrade.AddonType.EXTENSION, new ItemStack(ZSSItems.hookshot, 1, IHookable.HookshotType.MULTI_SHOT.ordinal()), new MerchantRecipe(new ItemStack(ZSSItems.hookshot, 1, IHookable.HookshotType.MULTI_SHOT.ordinal()), new ItemStack(ZSSItems.hookshotAddon, 1, ItemHookShotUpgrade.AddonType.EXTENSION.ordinal()), new ItemStack(ZSSItems.hookshot, 1, IHookable.HookshotType.MULTI_SHOT_EXT.ordinal())));
        TradeHandler.addTradeToMap(ItemHookShotUpgrade.AddonType.STONECLAW, new ItemStack(ZSSItems.hookshot, 1, IHookable.HookshotType.WOOD_SHOT.ordinal()), new MerchantRecipe(new ItemStack(ZSSItems.hookshot, 1, IHookable.HookshotType.WOOD_SHOT.ordinal()), new ItemStack(ZSSItems.hookshotAddon, 1, ItemHookShotUpgrade.AddonType.STONECLAW.ordinal()), new ItemStack(ZSSItems.hookshot, 1, IHookable.HookshotType.CLAW_SHOT.ordinal())));
        TradeHandler.addTradeToMap(ItemHookShotUpgrade.AddonType.STONECLAW, new ItemStack(ZSSItems.hookshot, 1, IHookable.HookshotType.WOOD_SHOT_EXT.ordinal()), new MerchantRecipe(new ItemStack(ZSSItems.hookshot, 1, IHookable.HookshotType.WOOD_SHOT_EXT.ordinal()), new ItemStack(ZSSItems.hookshotAddon, 1, ItemHookShotUpgrade.AddonType.STONECLAW.ordinal()), new ItemStack(ZSSItems.hookshot, 1, IHookable.HookshotType.CLAW_SHOT_EXT.ordinal())));
        TradeHandler.addTradeToMap(ItemHookShotUpgrade.AddonType.MULTI, new ItemStack(ZSSItems.hookshot, 1, IHookable.HookshotType.CLAW_SHOT.ordinal()), new MerchantRecipe(new ItemStack(ZSSItems.hookshot, 1, IHookable.HookshotType.CLAW_SHOT.ordinal()), new ItemStack(ZSSItems.hookshotAddon, 1, ItemHookShotUpgrade.AddonType.MULTI.ordinal()), new ItemStack(ZSSItems.hookshot, 1, IHookable.HookshotType.MULTI_SHOT.ordinal())));
        TradeHandler.addTradeToMap(ItemHookShotUpgrade.AddonType.MULTI, new ItemStack(ZSSItems.hookshot, 1, IHookable.HookshotType.CLAW_SHOT_EXT.ordinal()), new MerchantRecipe(new ItemStack(ZSSItems.hookshot, 1, IHookable.HookshotType.CLAW_SHOT_EXT.ordinal()), new ItemStack(ZSSItems.hookshotAddon, 1, ItemHookShotUpgrade.AddonType.MULTI.ordinal()), new ItemStack(ZSSItems.hookshot, 1, IHookable.HookshotType.MULTI_SHOT_EXT.ordinal())));
        ZSSVillagerInfo.initTrades();
    }

    public void manipulateTradesForVillager(EntityVillager villager, MerchantRecipeList trades, Random rand) {
        if (villager instanceof EntityGoron && Config.enableTradeBomb()) {
            float bombChance = villager.getProfession() == EnumVillager.BLACKSMITH.ordinal() ? 0.6f : 0.3f;
            for (BombType bomb : BombType.values()) {
                TradeHandler.addTrade(trades, rand, bombChance, new MerchantRecipe(new ItemStack(Items.emerald, 8 + bomb.ordinal() * 4 + rand.nextInt(6)), new ItemStack(ZSSItems.bomb, 1, bomb.ordinal())));
            }
            return;
        }
        switch (EnumVillager.values()[villager.getProfession()]) {
            case FARMER: {
                TradeHandler.addTrade(trades, rand, 0.3f, new MerchantRecipe(new ItemStack(Items.emerald, 10), new ItemStack(ZSSItems.tunicHeroBoots)));
                TradeHandler.addTrade(trades, rand, 0.3f, new MerchantRecipe(new ItemStack(Items.emerald, 10), new ItemStack(ZSSItems.tunicHeroHelm)));
                break;
            }
            case LIBRARIAN: {
                break;
            }
            case PRIEST: {
                break;
            }
            case BLACKSMITH: {
                TradeHandler.addTrade(trades, rand, 0.2f, new MerchantRecipe(new ItemStack(Items.emerald, 16), new ItemStack(ZSSItems.swordKokiri)));
                TradeHandler.addTrade(trades, rand, 0.2f, new MerchantRecipe(new ItemStack(Items.emerald, 16), new ItemStack(ZSSItems.shieldDeku)));
                break;
            }
            case BUTCHER: {
                TradeHandler.addTrade(trades, rand, 0.3f, new MerchantRecipe(new ItemStack(Items.emerald, 20), new ItemStack(ZSSItems.tunicHeroChest)));
                TradeHandler.addTrade(trades, rand, 0.3f, new MerchantRecipe(new ItemStack(Items.emerald, 10), new ItemStack(ZSSItems.tunicHeroLegs)));
                break;
            }
        }
    }

    public static void addTrade(MerchantRecipeList trades, Random rand, float probability, MerchantRecipe trade) {
        if (rand.nextFloat() < probability) {
            trades.add((Object)trade);
        }
    }

    public static enum EnumVillager {
        FARMER("farmer"),
        LIBRARIAN("librarian"),
        PRIEST("priest"),
        BLACKSMITH("blacksmith"),
        BUTCHER("butcher");

        public final String unlocalizedName;

        private EnumVillager(String name) {
            this.unlocalizedName = name;
        }
    }
}

