/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import zeldaswordskills.block.tileentity.TileEntityPedestal;
import zeldaswordskills.inventory.SlotPedestal;
import zeldaswordskills.item.ItemPendant;

public class ContainerPedestal
extends Container {
    private TileEntityPedestal pedestal;
    private static final int INV_START = 3;
    private static final int INV_END = 29;
    private static final int HOTBAR_START = 30;
    private static final int HOTBAR_END = 38;

    public ContainerPedestal(InventoryPlayer inv, TileEntityPedestal pedestal) {
        int i;
        this.pedestal = pedestal;
        this.addSlotToContainer(new SlotPedestal((IInventory)pedestal, 0, 80, 19));
        this.addSlotToContainer(new SlotPedestal((IInventory)pedestal, 1, 49, 50));
        this.addSlotToContainer(new SlotPedestal((IInventory)pedestal, 2, 111, 50));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new Slot((IInventory)inv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlotToContainer(new Slot((IInventory)inv, i, 8 + i * 18, 142));
        }
    }

    public boolean canInteractWith(EntityPlayer player) {
        return this.pedestal.isUseableByPlayer(player);
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int slotIndex) {
        ItemStack stack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotIndex);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemstack1 = slot.getStack();
            stack = itemstack1.copy();
            if (slotIndex < 3) {
                if (!this.mergeItemStack(itemstack1, 3, 39, true)) {
                    return null;
                }
                slot.onSlotChange(itemstack1, stack);
            } else if (itemstack1.getItem() instanceof ItemPendant ? !this.mergeItemStack(itemstack1, itemstack1.getItemDamage(), itemstack1.getItemDamage() + 1, false) : (slotIndex >= 3 && slotIndex < 30 ? !this.mergeItemStack(itemstack1, 30, 39, false) : slotIndex >= 30 && slotIndex < 39 && !this.mergeItemStack(itemstack1, 3, 30, false))) {
                return null;
            }
            if (itemstack1.stackSize == 0) {
                slot.putStack((ItemStack)null);
            } else {
                slot.onSlotChanged();
            }
            if (itemstack1.stackSize == stack.stackSize) {
                return null;
            }
            slot.onPickupFromSlot(player, itemstack1);
        }
        return stack;
    }

    public ItemStack slotClick(int slot, int par2, int par3, EntityPlayer player) {
        if (slot < 3 && this.pedestal.getWorldObj().getBlockMetadata(this.pedestal.xCoord, this.pedestal.yCoord, this.pedestal.zCoord) == 8) {
            return null;
        }
        return super.slotClick(slot, par2, par3, player);
    }

    protected boolean mergeItemStack(ItemStack stack, int start, int end, boolean backwards) {
        int l;
        ItemStack itemstack1;
        Slot slot;
        int k;
        boolean flag1 = false;
        int n = k = backwards ? end - 1 : start;
        if (stack.isStackable()) {
            while (stack.stackSize > 0 && (!backwards && k < end || backwards && k >= start)) {
                slot = (Slot)this.inventorySlots.get(k);
                itemstack1 = slot.getStack();
                if (!slot.isItemValid(stack)) {
                    k += backwards ? -1 : 1;
                    continue;
                }
                if (itemstack1 != null && itemstack1.getItem() == stack.getItem() && (!stack.getHasSubtypes() || stack.getItemDamage() == itemstack1.getItemDamage()) && ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)itemstack1)) {
                    l = itemstack1.stackSize + stack.stackSize;
                    if (l <= stack.getMaxStackSize() && l <= slot.getSlotStackLimit()) {
                        stack.stackSize = 0;
                        itemstack1.stackSize = l;
                        this.pedestal.markDirty();
                        flag1 = true;
                    } else if (itemstack1.stackSize < stack.getMaxStackSize() && l < slot.getSlotStackLimit()) {
                        stack.stackSize -= stack.getMaxStackSize() - itemstack1.stackSize;
                        itemstack1.stackSize = stack.getMaxStackSize();
                        this.pedestal.markDirty();
                        flag1 = true;
                    }
                }
                k += backwards ? -1 : 1;
            }
        }
        if (stack.stackSize > 0) {
            int n2 = k = backwards ? end - 1 : start;
            while (!backwards && k < end || backwards && k >= start) {
                slot = (Slot)this.inventorySlots.get(k);
                itemstack1 = slot.getStack();
                if (!slot.isItemValid(stack)) {
                    k += backwards ? -1 : 1;
                    continue;
                }
                if (itemstack1 == null) {
                    l = stack.stackSize;
                    if (l <= slot.getSlotStackLimit()) {
                        slot.putStack(stack.copy());
                        stack.stackSize = 0;
                        this.pedestal.markDirty();
                        flag1 = true;
                        break;
                    }
                    this.putStackInSlot(k, new ItemStack(stack.getItem(), slot.getSlotStackLimit(), stack.getItemDamage()));
                    stack.stackSize -= slot.getSlotStackLimit();
                    this.pedestal.markDirty();
                    flag1 = true;
                }
                k += backwards ? -1 : 1;
            }
        }
        return flag1;
    }
}

