/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSoulSand;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.client.InLiquidPacket;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;

public class ItemArmorBoots
extends ItemArmor
implements IUnenchantable {
    private final String resourceLocation;

    public ItemArmorBoots(ItemArmor.ArmorMaterial material, int renderIndex, String resourceLocation) {
        super(material, renderIndex, 3);
        this.resourceLocation = resourceLocation;
        this.setMaxDamage(0);
        this.setCreativeTab(ZSSCreativeTabs.tabCombat);
    }

    public int getItemEnchantability() {
        return 0;
    }

    public boolean getIsRepairable(ItemStack stack1, ItemStack stack2) {
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity instanceof EntityVillager && !player.worldObj.isRemote) {
            EntityVillager villager = (EntityVillager)entity;
            MerchantRecipeList trades = villager.getRecipes(player);
            if (villager.getProfession() == 3 && trades != null) {
                MerchantRecipe trade = new MerchantRecipe(stack.copy(), new ItemStack(Items.emerald, 16));
                if (player.worldObj.rand.nextFloat() < 0.2f && MerchantRecipeHelper.addToListWithCheck(trades, trade)) {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sell.1", new Object[0]);
                } else {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.1", new Object[0]);
                }
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.0", new Object[0]);
            }
        }
        return true;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        ZSSPlayerInfo info = ZSSPlayerInfo.get(player);
        if (!info.getFlag((byte)1)) {
            info.setWearingBoots(stack);
        }
    }

    public final void applyModifiers(ItemStack stack, EntityPlayer player) {
        this.removeModifiers(stack, player);
        this.applyCustomModifiers(stack, player);
    }

    protected void applyCustomModifiers(ItemStack stack, EntityPlayer player) {
    }

    public void removeModifiers(ItemStack stack, EntityPlayer player) {
    }

    public static boolean reverseMaterialAcceleration(World world, AxisAlignedBB aabb, Material material, Entity entity) {
        int j1;
        int i = MathHelper.floor_double((double)aabb.minX);
        int j = MathHelper.floor_double((double)(aabb.maxX + 1.0));
        int k = MathHelper.floor_double((double)aabb.minY);
        int l = MathHelper.floor_double((double)(aabb.maxY + 1.0));
        int i1 = MathHelper.floor_double((double)aabb.minZ);
        if (!world.checkChunksExist(i, k, i1, j, l, j1 = MathHelper.floor_double((double)(aabb.maxZ + 1.0)))) {
            return false;
        }
        boolean flag = false;
        Vec3 vec3 = Vec3.createVectorHelper((double)0.0, (double)0.0, (double)0.0);
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    double d0;
                    Block block = world.getBlock(k1, l1, i2);
                    if (block == null || block.getMaterial() != material || !((double)l >= (d0 = (double)((float)(l1 + 1) - BlockLiquid.getLiquidHeightPercent((int)world.getBlockMetadata(k1, l1, i2)))))) continue;
                    flag = true;
                    block.velocityToAddToEntity(world, k1, l1, i2, entity, vec3);
                }
            }
        }
        if (vec3.lengthVector() > 0.0 && entity.isPushedByWater()) {
            vec3 = vec3.normalize();
            double d1 = 0.014;
            entity.motionX -= vec3.xCoord * d1;
            entity.motionY -= vec3.yCoord * d1;
            entity.motionZ -= vec3.zCoord * d1;
            entity.motionX *= 0.85;
            entity.motionY *= 0.85;
            entity.motionZ *= 0.85;
        }
        return flag;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return this.resourceLocation;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.itemIcon = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9));
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)("tooltip.zss." + this.getUnlocalizedName().substring(9) + ".desc.0")));
    }

    public static class ItemRubberBoots
    extends ItemArmorBoots {
        public ItemRubberBoots(ItemArmor.ArmorMaterial material, int renderIndex, String resourceLocation) {
            super(material, renderIndex, resourceLocation);
        }

        @Override
        protected void applyCustomModifiers(ItemStack stack, EntityPlayer player) {
            ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.RESIST_SHOCK, Integer.MAX_VALUE, 50);
        }

        @Override
        public void removeModifiers(ItemStack stack, EntityPlayer player) {
            ZSSEntityInfo.get((EntityLivingBase)player).removeBuff(Buff.RESIST_SHOCK);
        }
    }

    public static class ItemPegasusBoots
    extends ItemArmorBoots {
        private static final UUID pegasusBootsMoveBonusUUID = UUID.fromString("36A0FC05-50EB-460B-8961-615633A6D813");
        private static final AttributeModifier pegasusBootsMoveBonus = new AttributeModifier(pegasusBootsMoveBonusUUID, "Pegasus Boots Speed Bonus", 0.3, 2).setSaved(false);

        public ItemPegasusBoots(ItemArmor.ArmorMaterial material, int renderIndex, String resourceLocation) {
            super(material, renderIndex, resourceLocation);
        }

        @Override
        protected void applyCustomModifiers(ItemStack stack, EntityPlayer player) {
            player.getEntityAttribute(SharedMonsterAttributes.movementSpeed).applyModifier(pegasusBootsMoveBonus);
            ZSSPlayerInfo.get(player).setFlag((byte)8, true);
            ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.EVADE_UP, Integer.MAX_VALUE, 25);
        }

        @Override
        public void removeModifiers(ItemStack stack, EntityPlayer player) {
            player.getEntityAttribute(SharedMonsterAttributes.movementSpeed).removeModifier(pegasusBootsMoveBonus);
            ZSSPlayerInfo.get(player).setFlag((byte)8, false);
            ZSSEntityInfo.get((EntityLivingBase)player).removeBuff(Buff.EVADE_UP);
        }
    }

    public static class ItemHoverBoots
    extends ItemArmorBoots {
        public ItemHoverBoots(ItemArmor.ArmorMaterial material, int renderIndex, String resourceLocation) {
            super(material, renderIndex, resourceLocation);
        }

        @Override
        public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
            boolean flag;
            super.onArmorTick(world, player, stack);
            ZSSPlayerInfo info = ZSSPlayerInfo.get(player);
            int i = MathHelper.floor_double((double)player.posX);
            int j = MathHelper.floor_double((double)player.boundingBox.minY);
            int k = MathHelper.floor_double((double)player.posZ);
            Block block = world.getBlock(i, j - 1, k);
            boolean bl = flag = !block.getMaterial().blocksMovement() || block.slipperiness > 0.6f || block instanceof BlockSoulSand;
            if (flag && player.isSprinting() && player.motionY < 0.0 && ++info.hoverTime < 40) {
                player.posY += -player.motionY;
                player.motionY = 0.0;
                player.fallDistance = 0.0f;
                if (info.hoverTime % 3 == 0) {
                    world.spawnParticle("explode", player.posX, player.posY - 2.0, player.posZ, -player.motionX, player.motionY, -player.motionZ);
                }
            } else if (info.hoverTime > 0) {
                info.hoverTime = 0;
                player.setSprinting(false);
                if (world.isRemote && Minecraft.getMinecraft().gameSettings.keyBindSprint.getIsKeyPressed()) {
                    KeyBinding.setKeyBindState((int)Minecraft.getMinecraft().gameSettings.keyBindSprint.getKeyCode(), (boolean)false);
                }
            }
        }
    }

    public static class ItemHeavyBoots
    extends ItemArmorBoots {
        private static final UUID heavyBootsKnockbackModifierUUID = UUID.fromString("71AF0F88-82E5-49DE-B9CC-844048E33D69");
        private static final AttributeModifier heavyBootsKnockbackModifier = new AttributeModifier(heavyBootsKnockbackModifierUUID, "Heavy Boots Knockback Resistance", 1.0, 0).setSaved(false);
        private static final UUID heavyBootsMovePenaltyUUID = UUID.fromString("B6C8CCB6-AE7B-4F14-908A-2F41BDB4D720");
        private static final AttributeModifier heavyBootsMovePenalty = new AttributeModifier(heavyBootsMovePenaltyUUID, "Heavy Boots Movement penalty", -0.6, 1).setSaved(false);

        public ItemHeavyBoots(ItemArmor.ArmorMaterial material, int renderIndex, String resourceLocation) {
            super(material, renderIndex, resourceLocation);
        }

        @Override
        public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
            super.onArmorTick(world, player, stack);
            ItemArmorBoots.reverseMaterialAcceleration(world, player.boundingBox.expand(0.0, (double)-0.4f, 0.0).contract(0.001, 0.001, 0.001), Material.water, (Entity)player);
            if (!world.isRemote) {
                Material m1;
                int k;
                int j;
                int i = MathHelper.floor_double((double)player.posX);
                Material m = world.getBlock(i, j = MathHelper.floor_double((double)player.boundingBox.minY), k = MathHelper.floor_double((double)player.posZ)).getMaterial();
                if (m.isLiquid()) {
                    PacketDispatcher.sendTo(new InLiquidPacket(m == Material.lava), (EntityPlayerMP)player);
                }
                if (((m1 = world.getBlock(i, j - 1, k).getMaterial()) == Material.glass || m1 == Material.ice) && world.getTotalWorldTime() % 2L == 0L && (!player.isSneaking() && world.rand.nextFloat() < 0.15f || world.rand.nextFloat() < 0.01f)) {
                    world.func_147480_a(i, j - 1, k, false);
                }
            }
        }

        @Override
        protected void applyCustomModifiers(ItemStack stack, EntityPlayer player) {
            player.getEntityAttribute(SharedMonsterAttributes.knockbackResistance).applyModifier(heavyBootsKnockbackModifier);
            player.getEntityAttribute(SharedMonsterAttributes.movementSpeed).applyModifier(heavyBootsMovePenalty);
            ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.EVADE_DOWN, Integer.MAX_VALUE, 50);
        }

        @Override
        public void removeModifiers(ItemStack stack, EntityPlayer player) {
            player.getEntityAttribute(SharedMonsterAttributes.knockbackResistance).removeModifier(heavyBootsKnockbackModifier);
            player.getEntityAttribute(SharedMonsterAttributes.movementSpeed).removeModifier(heavyBootsMovePenalty);
            ZSSEntityInfo.get((EntityLivingBase)player).removeBuff(Buff.EVADE_DOWN);
        }
    }
}

