/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import com.google.common.collect.Multimap;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.battlegear2.api.PlayerEventChild;
import mods.battlegear2.api.weapons.IBattlegearWeapon;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.api.item.IWeapon;
import zeldaswordskills.api.item.WeaponRegistry;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.npc.EntityGoron;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.item.ItemZeldaSword;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;

@Optional.Interface(iface="mods.battlegear2.api.weapons.IBattlegearWeapon", modid="battlegear2", striprefs=true)
public class ItemBrokenSword
extends Item
implements IUnenchantable,
IWeapon,
IBattlegearWeapon {
    public ItemBrokenSword() {
        this.setFull3D();
        this.setMaxDamage(0);
        this.setMaxStackSize(1);
        this.setHasSubtypes(true);
        this.setCreativeTab(ZSSCreativeTabs.tabCombat);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity instanceof EntityVillager && !player.worldObj.isRemote) {
            boolean isGoron = entity instanceof EntityGoron;
            EntityVillager villager = (EntityVillager)entity;
            MerchantRecipeList trades = villager.getRecipes(player);
            Item brokenItem = Item.getItemById((int)stack.getItemDamage());
            if (!(brokenItem instanceof ItemSword) || brokenItem instanceof ItemZeldaSword && !((ItemZeldaSword)brokenItem).givesBrokenItem) {
                ZSSMain.logger.warn("Broken sword contained an invalid item: " + brokenItem + "; defaulting to Ordon Sword");
                brokenItem = ZSSItems.swordOrdon;
            }
            if (villager.getProfession() == 3 || isGoron) {
                if (brokenItem != ZSSItems.swordGiant) {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.sword.broken", new Object[0]);
                    MerchantRecipeHelper.addToListWithCheck(trades, new MerchantRecipe(stack.copy(), new ItemStack(Items.emerald, 5), new ItemStack(brokenItem)));
                } else if (isGoron && villager.getCustomNameTag().equals("Medigoron")) {
                    if (ZSSPlayerSkills.get(player).getSkillLevel(SkillBase.bonusHeart) > 9) {
                        player.triggerAchievement((StatBase)ZSSAchievements.swordBroken);
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.sword.broken.giant.1", new Object[0]);
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.sword.broken.giant.2", new Object[0]);
                        MerchantRecipeHelper.addToListWithCheck(trades, new MerchantRecipe(stack.copy(), new ItemStack(Items.emerald, 5), new ItemStack(brokenItem)));
                    } else {
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.sword.big", new Object[0]);
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.sword.later", new Object[0]);
                    }
                } else {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.sword.sorry", new Object[0]);
                }
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.sword.sorry", new Object[0]);
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int damage) {
        Item sword = Item.getItemById((int)damage);
        if (sword instanceof ItemZeldaSword && ((ItemZeldaSword)sword).givesBrokenItem) {
            return sword.getIconFromDamage(-1);
        }
        return this.itemIcon;
    }

    public String getItemStackDisplayName(ItemStack stack) {
        Item sword = Item.getItemById((int)stack.getItemDamage());
        String name = sword instanceof ItemZeldaSword && ((ItemZeldaSword)sword).givesBrokenItem ? sword.getUnlocalizedName() : ZSSItems.swordOrdon.getUnlocalizedName();
        return StatCollector.translateToLocalFormatted((String)(this.getUnlocalizedName() + ".name"), (Object[])new Object[]{StatCollector.translateToLocal((String)(name + ".name"))});
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, Item.getIdFromItem((Item)ZSSItems.swordKokiri)));
        list.add(new ItemStack(item, 1, Item.getIdFromItem((Item)ZSSItems.swordOrdon)));
        list.add(new ItemStack(item, 1, Item.getIdFromItem((Item)ZSSItems.swordGiant)));
        list.add(new ItemStack(item, 1, Item.getIdFromItem((Item)ZSSItems.swordDarknut)));
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.sword_broken.desc.0"));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.itemIcon = register.registerIcon("zeldaswordskills:broken_sword_ordon");
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(stack);
        multimap.put((Object)SharedMonsterAttributes.attackDamage.getAttributeUnlocalizedName(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 2.0, 0));
        return multimap;
    }

    @Override
    public boolean isSword(ItemStack stack) {
        return !WeaponRegistry.INSTANCE.isSwordForbidden(this);
    }

    @Override
    public boolean isWeapon(ItemStack stack) {
        return !WeaponRegistry.INSTANCE.isWeaponForbidden(this);
    }

    @Optional.Method(modid="battlegear2")
    public boolean sheatheOnBack(ItemStack stack) {
        return false;
    }

    @Optional.Method(modid="battlegear2")
    public boolean isOffhandHandDual(ItemStack stack) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandAttackEntity(PlayerEventChild.OffhandAttackEvent event, ItemStack main, ItemStack offhand) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandClickAir(PlayerInteractEvent event, ItemStack main, ItemStack offhand) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandClickBlock(PlayerInteractEvent event, ItemStack main, ItemStack offhand) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public void performPassiveEffects(Side side, ItemStack main, ItemStack offhand) {
    }

    @Optional.Method(modid="battlegear2")
    public boolean allowOffhand(ItemStack main, ItemStack offhand) {
        return true;
    }
}

