/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.entity.projectile.EntityCeramicJar;

public class ItemCeramicJar
extends ItemBlock
implements IUnenchantable {
    public ItemCeramicJar(Block block) {
        super(block);
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        EntityCeramicJar jar = new EntityCeramicJar(world, (EntityLivingBase)player);
        if (stack.hasTagCompound() && stack.getTagCompound().hasKey("jarStack")) {
            jar.setStack(ItemStack.loadItemStackFromNBT((NBTTagCompound)stack.getTagCompound().getCompoundTag("jarStack")));
        }
        if (!world.isRemote) {
            world.spawnEntityInWorld((Entity)jar);
        }
        if (!player.capabilities.isCreativeMode) {
            --stack.stackSize;
        }
        return stack;
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (player.isSneaking() && super.onItemUse(stack, player, world, x, y, z, side, hitX, hitY, hitZ)) {
            TileEntity te;
            if (stack.hasTagCompound() && stack.getTagCompound().hasKey("jarStack") && (te = world.getTileEntity(x, y, z)) instanceof IInventory) {
                ((IInventory)te).setInventorySlotContents(0, ItemStack.loadItemStackFromNBT((NBTTagCompound)stack.getTagCompound().getCompoundTag("jarStack")));
            }
            return true;
        }
        return false;
    }
}

