/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.entity.projectile.EntityCyclone;
import zeldaswordskills.util.WorldUtils;

public class ItemDekuLeaf
extends Item
implements IUnenchantable {
    public ItemDekuLeaf() {
        this.setFull3D();
        this.setMaxDamage(0);
        this.setMaxStackSize(1);
        this.setCreativeTab(ZSSCreativeTabs.tabTools);
    }

    private long getNextUseTime(ItemStack stack) {
        return stack.hasTagCompound() ? stack.getTagCompound().getLong("next_use") : 0L;
    }

    private void setNextUseTime(ItemStack stack, World world, int ticks) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
        }
        stack.getTagCompound().setLong("next_use", world.getTotalWorldTime() + (long)ticks);
    }

    public void onUpdate(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        if (isHeld && entity instanceof EntityPlayer && entity.fallDistance > 1.0f && entity.motionY < 0.0) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!player.capabilities.isFlying && ZSSPlayerInfo.get(player).getCurrentMagic() > 0.0f) {
                player.motionY = player.motionY < -0.05 ? -0.05 : player.motionY;
                player.fallDistance = 1.0f;
                if (world.getWorldTime() % 4L == 0L) {
                    ZSSPlayerInfo.get(player).consumeMagic(0.1f);
                }
            }
        }
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        player.swingItem();
        if (player.onGround) {
            if (world.getTotalWorldTime() > this.getNextUseTime(stack) && ZSSPlayerInfo.get(player).useMagic(10.0f)) {
                if (!world.isRemote) {
                    WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:whoosh", 0.4f, 0.5f);
                    world.spawnEntityInWorld((Entity)new EntityCyclone(world, (EntityLivingBase)player));
                    if (!player.capabilities.isCreativeMode) {
                        this.setNextUseTime(stack, world, 20);
                    }
                }
            } else if (!world.isRemote) {
                WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:grunt", 0.3f, 0.8f);
            }
        } else if (ZSSPlayerInfo.get(player).useMagic(0.25f)) {
            player.motionY += 0.175;
        }
        return stack;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.itemIcon = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9));
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemstack, EntityPlayer player, List list, boolean isHeld) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.deku_leaf.desc.0"));
    }
}

