/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.creativetab.ZSSCreativeTabs;

public class ItemDoorLocked
extends Item
implements IUnenchantable {
    private final Block doorBlock;

    public ItemDoorLocked(Block block) {
        this.doorBlock = block;
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
        this.setCreativeTab(ZSSCreativeTabs.tabKeys);
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (side != 1) {
            return false;
        }
        if (player.canPlayerEdit(x, ++y, z, side, stack) && player.canPlayerEdit(x, y + 1, z, side, stack)) {
            if (!this.doorBlock.canPlaceBlockAt(world, x, y, z)) {
                return false;
            }
            this.placeDoorBlock(world, x, y, z, stack.getItemDamage());
            --stack.stackSize;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.itemIcon = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9));
    }

    private void placeDoorBlock(World world, int x, int y, int z, int meta) {
        world.setBlock(x, y, z, this.doorBlock, meta &= 7, 2);
        world.setBlock(x, y + 1, z, this.doorBlock, meta | 8, 2);
        world.notifyBlocksOfNeighborChange(x, y, z, this.doorBlock);
        world.notifyBlocksOfNeighborChange(x, y + 1, z, this.doorBlock);
    }
}

