/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import zeldaswordskills.block.BlockSecretStone;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.block.tileentity.TileEntityDungeonBlock;
import zeldaswordskills.item.ItemMetadataBlock;

public class ItemDungeonBlock
extends ItemMetadataBlock {
    public ItemDungeonBlock(Block block) {
        super(block);
    }

    public String getItemStackDisplayName(ItemStack stack) {
        return StatCollector.translateToLocal((String)(this.getUnlocalizedName() + (stack.getItemDamage() > 7 ? ".name.unbreakable" : ".name")));
    }

    public Block getBlockFromStack(ItemStack stack) {
        if (stack.hasTagCompound() && stack.getTagCompound().hasKey("renderBlock")) {
            int blockID = stack.getTagCompound().getInteger("renderBlock");
            return Block.getBlockById((int)blockID);
        }
        return this.field_150939_a;
    }

    public int getMetaFromStack(ItemStack stack) {
        return stack.hasTagCompound() ? stack.getTagCompound().getInteger("metadata") : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        Block block = this.getBlockFromStack(stack);
        return block != null && block != this.field_150939_a ? block.getIcon(1, this.getMetaFromStack(stack)) : Blocks.stone.getIcon(1, 0);
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (player.isSneaking()) {
            if (!world.isRemote) {
                Block block = world.getBlock(x, y, z);
                int meta = world.getBlockMetadata(x, y, z);
                if (block == ZSSBlocks.secretStone) {
                    block = BlockSecretStone.getBlockFromMeta(meta);
                    meta = 0;
                } else {
                    TileEntity te = world.getTileEntity(x, y, z);
                    if (te instanceof TileEntityDungeonBlock) {
                        block = ((TileEntityDungeonBlock)te).getRenderBlock();
                        meta = ((TileEntityDungeonBlock)te).getRenderMetadata();
                    }
                }
                if (block != null && (block.isOpaqueCube() || block == Blocks.ice)) {
                    if (!stack.hasTagCompound()) {
                        stack.setTagCompound(new NBTTagCompound());
                    }
                    stack.getTagCompound().setInteger("renderBlock", Block.getIdFromBlock((Block)block));
                    stack.getTagCompound().setInteger("metadata", meta);
                }
            }
            return false;
        }
        return super.onItemUse(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
        if (stack.getItemDamage() > 7) {
            list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.block.unbreakable.desc"));
        } else {
            list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)("tooltip.zss.block." + (this.field_150939_a == ZSSBlocks.dungeonCore ? "core" : "dungeon") + ".desc.0")));
        }
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.block.dungeon.desc.1"));
    }
}

