/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import zeldaswordskills.api.block.IHookable;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.projectile.EntityHookShot;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;

public class ItemHookShot
extends Item
implements IUnenchantable {
    protected static final String[] shotNames = new String[]{"Hookshot", "Clawshot", "Multishot"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public ItemHookShot() {
        this.setMaxStackSize(1);
        this.setHasSubtypes(true);
        this.setCreativeTab(ZSSCreativeTabs.tabTools);
        this.setFull3D();
    }

    public IHookable.HookshotType getType(int damage) {
        return damage > -1 ? IHookable.HookshotType.values()[damage % IHookable.HookshotType.values().length] : IHookable.HookshotType.WOOD_SHOT;
    }

    public EnumAction getItemUseAction(ItemStack par1ItemStack) {
        return EnumAction.block;
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 16000;
    }

    public boolean isItemTool(ItemStack stack) {
        return true;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
        EntityHookShot shot = new EntityHookShot(player.worldObj, (EntityLivingBase)player);
        shot.setThrower(player);
        shot.setType(this.getType(stack.getItemDamage()));
        if (!player.worldObj.isRemote) {
            player.worldObj.spawnEntityInWorld((Entity)shot);
            player.worldObj.playSoundAtEntity((Entity)player, "zeldaswordskills:hookshot", 1.0f, 1.0f);
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        if (count % 9 == 8 && !player.worldObj.isRemote) {
            player.worldObj.playSoundAtEntity((Entity)player, "zeldaswordskills:hookshot", 1.0f, 1.0f);
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.worldObj.isRemote && entity.getClass() == EntityVillager.class) {
            EntityVillager villager = (EntityVillager)entity;
            MerchantRecipeList trades = villager.getRecipes(player);
            if (villager.getProfession() == 3) {
                MerchantRecipe trade = new MerchantRecipe(stack.copy(), new ItemStack(Items.emerald, 16));
                if (MerchantRecipeHelper.addToListWithCheck(trades, trade) || player.worldObj.rand.nextFloat() < 0.5f) {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sell.0", new Object[0]);
                } else {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.1", new Object[0]);
                }
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.0", new Object[0]);
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int type) {
        return this.iconArray[this.getType(type).ordinal() / 2];
    }

    public String getUnlocalizedName(ItemStack stack) {
        return this.getUnlocalizedName() + "." + stack.getItemDamage();
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < IHookable.HookshotType.values().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.iconArray = new IIcon[IHookable.HookshotType.values().length / 2];
        for (int i = 0; i < IHookable.HookshotType.values().length; ++i) {
            this.iconArray[i / 2] = register.registerIcon("zeldaswordskills:" + shotNames[this.getType(i).ordinal() / 2].toLowerCase());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.hookshot.desc.0"));
        switch (this.getType(stack.getItemDamage())) {
            case WOOD_SHOT: 
            case WOOD_SHOT_EXT: {
                list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.hookshot.desc.10"));
                list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.hookshot.desc.11"));
                break;
            }
            case CLAW_SHOT: 
            case CLAW_SHOT_EXT: {
                list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.hookshot.desc.20"));
                list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.hookshot.desc.21"));
                break;
            }
            case MULTI_SHOT: {
                list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.hookshot.desc.30"));
                list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.hookshot.desc.31"));
                break;
            }
            case MULTI_SHOT_EXT: {
                list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.hookshot.desc.32"));
                list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.hookshot.desc.31"));
            }
        }
    }
}

