/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.handler.TradeHandler;
import zeldaswordskills.item.ItemHookShot;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;

public class ItemHookShotUpgrade
extends Item
implements IUnenchantable {
    protected static final String[] addonNames = new String[]{"Extender", "Claw", "Multi"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public ItemHookShotUpgrade() {
        this.setMaxStackSize(1);
        this.setHasSubtypes(true);
        this.setCreativeTab(ZSSCreativeTabs.tabTools);
    }

    public AddonType getType(int damage) {
        return damage > -1 ? AddonType.values()[damage % AddonType.values().length] : AddonType.EXTENSION;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        if (!world.isRemote) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.use.fail.0", new Object[0]);
        }
        return stack;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity.getClass() == EntityVillager.class && stack.getItem() instanceof ItemHookShotUpgrade) {
            this.addSpecialTrade(stack, player, (EntityVillager)entity);
        }
        return true;
    }

    public boolean itemInteractionForEntity(ItemStack stack, EntityPlayer player, EntityLivingBase entity) {
        return entity instanceof EntityVillager;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int type) {
        return this.iconArray[this.getType(type).ordinal()];
    }

    public String getUnlocalizedName(ItemStack stack) {
        return this.getUnlocalizedName() + "." + stack.getItemDamage();
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < AddonType.values().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.iconArray = new IIcon[AddonType.values().length];
        for (int i = 0; i < AddonType.values().length; ++i) {
            this.iconArray[i] = register.registerIcon("zeldaswordskills:" + addonNames[this.getType(i).ordinal()].toLowerCase());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.hookshot.upgrade.desc.0"));
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.hookshot.upgrade.desc.1"));
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.hookshot.upgrade.desc.2"));
    }

    public void addSpecialTrade(ItemStack stack, EntityPlayer player, EntityVillager villager) {
        if (!player.worldObj.isRemote) {
            MerchantRecipeList trades = villager.getRecipes(player);
            if (villager.getProfession() == 3 && trades != null) {
                MerchantRecipe trade = this.getHookShotTradeFromInventory(stack, player, trades);
                if (trade != null && trades.size() >= Config.getFriendTradesRequired()) {
                    MerchantRecipeHelper.addUniqueTrade(trades, trade);
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.new.0", new Object[0]);
                } else {
                    trade = new MerchantRecipe(stack.copy(), new ItemStack(Items.emerald, 16));
                    if (MerchantRecipeHelper.addToListWithCheck(trades, trade) || player.worldObj.rand.nextFloat() < 0.5f) {
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sell.0", new Object[0]);
                    } else {
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.1", new Object[0]);
                    }
                }
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.0", new Object[0]);
            }
        }
    }

    private MerchantRecipe getHookShotTradeFromInventory(ItemStack stack, EntityPlayer player, MerchantRecipeList list) {
        AddonType type = ((ItemHookShotUpgrade)stack.getItem()).getType(stack.getItemDamage());
        for (ItemStack invStack : player.inventory.mainInventory) {
            if (invStack == null || !(invStack.getItem() instanceof ItemHookShot) || MerchantRecipeHelper.doesListContain(list, TradeHandler.getTrade(type, invStack))) continue;
            return TradeHandler.getTrade(type, invStack);
        }
        return null;
    }

    public static enum AddonType {
        EXTENSION,
        STONECLAW,
        MULTI;

    }
}

