/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.api.entity.ISongTeacher;
import zeldaswordskills.api.item.IRightClickEntity;
import zeldaswordskills.block.BlockSongInscription;
import zeldaswordskills.block.BlockWarpStone;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.player.ZSSPlayerSongs;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.songs.ZeldaSongs;
import zeldaswordskills.util.PlayerUtils;

public class ItemInstrument
extends Item
implements IRightClickEntity {
    private static final Map<Class<? extends EntityLiving>, Map<String, AbstractZeldaSong>> teachersForClass = new HashMap<Class<? extends EntityLiving>, Map<String, AbstractZeldaSong>>();
    @SideOnly(value=Side.CLIENT)
    private List<IIcon> icons;

    public ItemInstrument() {
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
        this.setMaxStackSize(1);
        this.setUnlocalizedName("zss.instrument");
        this.setCreativeTab(ZSSCreativeTabs.tabMisc);
    }

    public Instrument getInstrument(ItemStack stack) {
        return Instrument.values()[stack.getItemDamage() % Instrument.values().length];
    }

    public int getSongStrength(ItemStack stack) {
        return this.getInstrument(stack).getPower();
    }

    public void onCreated(ItemStack stack, World world, EntityPlayer player) {
        if (this.getInstrument(stack) == Instrument.OCARINA_FAIRY) {
            player.triggerAchievement((StatBase)ZSSAchievements.ocarinaCraft);
        }
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        Block block = world.getBlock(x, y, z);
        return block instanceof BlockWarpStone || block instanceof BlockSongInscription;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        if (world.isRemote) {
            ZSSPlayerSongs songs = ZSSPlayerSongs.get(player);
            if (songs.preventSongGui) {
                songs.preventSongGui = false;
            } else if (songs.songToLearn != null) {
                player.openGui((Object)ZSSMain.instance, 5, player.worldObj, 0, 0, 0);
            } else {
                player.openGui((Object)ZSSMain.instance, this.getInstrument(stack).getGuiId(), world, 0, 0, 0);
            }
        }
        return stack;
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.isRemote) {
            if (this.isScarecrowAt(world, x, y, z) && ZSSPlayerSongs.get(player).canOpenScarecrowGui(true)) {
                player.openGui((Object)ZSSMain.instance, 4, world, x, y, z);
            } else {
                player.openGui((Object)ZSSMain.instance, this.getInstrument(stack).getGuiId(), world, x, y, z);
            }
        }
        return true;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return true;
    }

    @Override
    public boolean onRightClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity instanceof EntityLiving) {
            return this.handleRightClickEntity(stack, player, (EntityLiving)entity);
        }
        return false;
    }

    private boolean handleRightClickEntity(ItemStack stack, EntityPlayer player, EntityLiving entity) {
        ISongTeacher.TeachingResult result = null;
        if (entity instanceof ISongTeacher) {
            result = ((ISongTeacher)entity).getTeachingResult(stack, player);
        } else if (!player.isSneaking() && entity.hasCustomNameTag() && teachersForClass.containsKey(entity.getClass())) {
            Map<String, AbstractZeldaSong> teacherSongs = teachersForClass.get(entity.getClass());
            result = new ISongTeacher.TeachingResult(teacherSongs.get(entity.getCustomNameTag()), true, true);
        }
        if (result != null) {
            if (player.worldObj.isRemote && result.songToLearn != null) {
                ZSSPlayerSongs.get((EntityPlayer)player).songToLearn = result.songToLearn;
                if (result.displayChat) {
                    if (ZSSPlayerSongs.get(player).isSongKnown(result.songToLearn)) {
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.ocarina.review", new ChatComponentTranslation(result.songToLearn.getTranslationString(), new Object[0]));
                    } else {
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.ocarina.learn", new ChatComponentTranslation(result.songToLearn.getTranslationString(), new Object[0]));
                    }
                }
            }
            return result.cancel;
        }
        return false;
    }

    private boolean isScarecrowAt(World world, int x, int y, int z) {
        int i = 0;
        while (i < 2 && world.getBlock(x, y, z) == Blocks.hay_block) {
            ++i;
            ++y;
        }
        Block block = world.getBlock(x, y, z);
        if (block instanceof BlockPumpkin) {
            --y;
            for (int dy = i; dy < 2; ++dy) {
                if (world.getBlock(x, y - dy, z) == Blocks.hay_block) continue;
                return false;
            }
            if (world.getBlock(x + 1, y, z) == Blocks.hay_block && world.getBlock(x - 1, y, z) == Blocks.hay_block) {
                return true;
            }
            if (world.getBlock(x, y, z + 1) == Blocks.hay_block && world.getBlock(x, y, z - 1) == Blocks.hay_block) {
                return true;
            }
        }
        return false;
    }

    public String getUnlocalizedName(ItemStack stack) {
        return super.getUnlocalizedName() + "." + Instrument.values()[stack.getItemDamage() % Instrument.values().length].unlocalizedName;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int damage) {
        return this.icons.get(damage % this.icons.size());
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tab, List list) {
        for (Instrument instrument : Instrument.values()) {
            list.add(new ItemStack(item, 1, instrument.ordinal()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.icons = new ArrayList<IIcon>(Instrument.values().length);
        for (Instrument instrument : Instrument.values()) {
            this.icons.add(register.registerIcon("zeldaswordskills:" + instrument.getUnlocalizedName()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)("tooltip.zss.instrument." + this.getInstrument(stack).getUnlocalizedName() + ".desc")));
    }

    static {
        HashMap<String, AbstractZeldaSong> teacherSongs = new HashMap<String, AbstractZeldaSong>();
        teacherSongs.put("Guru-Guru", ZeldaSongs.songStorms);
        teacherSongs.put("Impa", ZeldaSongs.songZeldasLullaby);
        teacherSongs.put("Malon", ZeldaSongs.songEpona);
        teacherSongs.put("Saria", ZeldaSongs.songSaria);
        teachersForClass.put(EntityVillager.class, teacherSongs);
    }

    public static enum Instrument {
        OCARINA_FAIRY("ocarina_fairy", 3, 1),
        OCARINA_TIME("ocarina_time", 3, 5);

        private final String unlocalizedName;
        private final int guiId;
        private final int power;

        private Instrument(String name, int guiId, int power) {
            this.unlocalizedName = name;
            this.guiId = guiId;
            this.power = Math.min(power, 5);
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        public int getGuiId() {
            return this.guiId;
        }

        public int getPower() {
            return this.power;
        }
    }
}

