/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.BossType;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;

public class ItemKeyBig
extends Item
implements IUnenchantable {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public ItemKeyBig() {
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
        this.setCreativeTab(ZSSCreativeTabs.tabKeys);
    }

    public static ItemStack getKeyForBiome(World world, int x, int z) {
        BossType type = BossType.getBossType(world, x, z);
        if (type != null) {
            return new ItemStack(ZSSItems.keyBig, 1, type.ordinal());
        }
        return null;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.worldObj.isRemote && entity.getClass() == EntityVillager.class) {
            EntityVillager villager = (EntityVillager)entity;
            MerchantRecipeList trades = villager.getRecipes(player);
            if (trades != null) {
                MerchantRecipe trade = new MerchantRecipe(stack.copy(), new ItemStack(Items.emerald, 16));
                if (player.worldObj.rand.nextFloat() < 0.2f && MerchantRecipeHelper.addToListWithCheck(trades, trade)) {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sell.0", new Object[0]);
                } else {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.1", new Object[0]);
                }
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.0", new Object[0]);
            }
        }
        return true;
    }

    public String getItemStackDisplayName(ItemStack stack) {
        return StatCollector.translateToLocalFormatted((String)(this.getUnlocalizedName() + ".name"), (Object[])new Object[]{BossType.values()[stack.getItemDamage() % BossType.values().length].getDisplayName()});
    }

    public String getUnlocalizedName(ItemStack stack) {
        return this.getUnlocalizedName().substring(9) + stack.getItemDamage();
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tab, List list) {
        for (BossType boss : BossType.values()) {
            list.add(new ItemStack(item, 1, boss.ordinal()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int damage) {
        return this.iconArray[damage % BossType.values().length];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.iconArray = new IIcon[BossType.values().length];
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = register.registerIcon("zeldaswordskills:key_" + BossType.values()[i].getUnlocalizedName());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.keybig.desc.0"));
    }
}

