/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.item.ItemDrinkable;
import zeldaswordskills.util.PlayerUtils;

public class ItemLonLonMilk
extends ItemDrinkable {
    @SideOnly(value=Side.CLIENT)
    private IIcon used_icon;
    protected final float restore_hp;

    public ItemLonLonMilk(String name, int uses, float restore_hp) {
        super(name);
        this.restore_hp = restore_hp;
        this.setMaxDamage(uses);
        this.setMaxStackSize(1);
        this.setCreativeTab(ZSSCreativeTabs.tabTools);
    }

    @Override
    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        if (stack.hasTagCompound() && player.worldObj.getWorldTime() > stack.getTagCompound().getLong("expiration")) {
            if (!world.isRemote) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.lon_lon_milk.expired", new Object[0]);
            }
            return stack;
        }
        return player.getHealth() < player.getMaxHealth() ? super.onItemRightClick(stack, world, player) : stack;
    }

    @Override
    public ItemStack onEaten(ItemStack stack, World world, EntityPlayer player) {
        player.triggerAchievement(StatList.objectUseStats[Item.getIdFromItem((Item)this)]);
        if (!player.capabilities.isCreativeMode) {
            stack.setItemDamage(stack.getItemDamage() + 1);
            if (stack.getItemDamage() >= stack.getMaxDamage()) {
                --stack.stackSize;
            }
        }
        player.heal(this.restore_hp);
        return stack.stackSize <= 0 ? new ItemStack(Items.glass_bottle) : stack;
    }

    public void onUpdate(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
        }
        if (!stack.getTagCompound().hasKey("expiration")) {
            stack.getTagCompound().setLong("expiration", world.getWorldTime() + 24000L);
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return true;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
        long expiration;
        long l = expiration = stack.hasTagCompound() ? stack.getTagCompound().getLong("expiration") : 0L;
        if (expiration > 0L && player.worldObj.getWorldTime() > expiration) {
            list.add(EnumChatFormatting.YELLOW + StatCollector.translateToLocal((String)"tooltip.zss.lon_lon_milk.expired"));
        } else {
            list.add(EnumChatFormatting.GREEN + StatCollector.translateToLocalFormatted((String)"tooltip.zss.restore_hp", (Object[])new Object[]{Float.valueOf(this.restore_hp)}));
            if (stack.getMaxDamage() > 1) {
                list.add(EnumChatFormatting.GRAY + StatCollector.translateToLocalFormatted((String)"tooltip.zss.uses", (Object[])new Object[]{stack.getMaxDamage() - stack.getItemDamage(), stack.getMaxDamage()}));
            }
            if ((expiration -= player.worldObj.getWorldTime()) > 0L) {
                String time = StringUtils.ticksToElapsedTime((int)((int)expiration));
                list.add(EnumChatFormatting.GRAY + StatCollector.translateToLocalFormatted((String)"tooltip.zss.lon_lon_milk.expires_in", (Object[])new Object[]{time}));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int damage) {
        return damage > 0 ? this.used_icon : this.itemIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        super.registerIcons(register);
        this.used_icon = register.registerIcon(this.getIconString() + "_half");
    }
}

