/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;
import zeldaswordskills.world.TeleporterNoPortal;

public class ItemMagicMirror
extends Item
implements IUnenchantable {
    private static final int USE_TIME = 140;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public ItemMagicMirror() {
        this.setFull3D();
        this.setMaxDamage(16);
        this.setMaxStackSize(1);
        this.setCreativeTab(ZSSCreativeTabs.tabTools);
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 140;
    }

    public EnumAction getItemUseAction(ItemStack stack) {
        return EnumAction.block;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        if (count == 1 && !player.worldObj.isRemote) {
            switch (player.dimension) {
                case -1: {
                    ((EntityPlayerMP)player).mcServer.getConfigurationManager().transferPlayerToDimension((EntityPlayerMP)player, 0, (Teleporter)new TeleporterNoPortal((WorldServer)player.worldObj));
                    TeleporterNoPortal.adjustPosY((Entity)player);
                    break;
                }
                case 0: {
                    double[] coordinates = this.getLastPosition(stack);
                    if (coordinates == null || TargetUtils.canEntitySeeSky(player.worldObj, (Entity)player)) break;
                    player.setPositionAndUpdate(coordinates[0], coordinates[1], coordinates[2]);
                    break;
                }
            }
            stack.damageItem(1, (EntityLivingBase)player);
            stack.damageItem(1, (EntityLivingBase)player);
            if (stack.stackSize == 0 || stack.getItemDamage() == stack.getMaxDamage()) {
                player.destroyCurrentEquippedItem();
            }
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.worldObj.isRemote && entity.getClass() == EntityVillager.class) {
            EntityVillager villager = (EntityVillager)entity;
            MerchantRecipeList trades = villager.getRecipes(player);
            if (villager.getProfession() == 1 && trades != null) {
                MerchantRecipe trade = new MerchantRecipe(stack.copy(), new ItemStack(Items.emerald, 8));
                if (player.worldObj.rand.nextFloat() < 0.2f && MerchantRecipeHelper.addToListWithCheck(trades, trade)) {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sell.1", new Object[0]);
                } else {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.1", new Object[0]);
                }
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.0", new Object[0]);
            }
        }
        return true;
    }

    public void onUpdate(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        if (!world.isRemote && world.provider.isSurfaceWorld() && world.getTotalWorldTime() % 10L == 0L) {
            boolean flag;
            boolean bl = flag = entity instanceof EntityPlayer && !((EntityPlayer)entity).isUsingItem();
            if (flag && TargetUtils.canEntitySeeSky(world, entity)) {
                this.setLastPosition(stack, entity);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (!player.isUsingItem()) {
            return this.iconArray[0];
        }
        int i = useRemaining < 30 ? 3 : (useRemaining < 70 ? 2 : (useRemaining < 110 ? 1 : 0));
        return this.iconArray[i];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.itemIcon = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9));
        this.iconArray = new IIcon[4];
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9) + (i > 0 ? Integer.valueOf(i) : ""));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemstack, EntityPlayer player, List list, boolean isHeld) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.magicmirror.desc.0"));
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.zss.magicmirror.desc.1"));
    }

    protected double[] getLastPosition(ItemStack stack) {
        double[] coordinates = null;
        if (stack.hasTagCompound() && stack.getTagCompound().hasKey("mmLastPosX")) {
            coordinates = new double[]{stack.getTagCompound().getDouble("mmLastPosX"), stack.getTagCompound().getDouble("mmLastPosY"), stack.getTagCompound().getDouble("mmLastPosZ")};
        }
        return coordinates;
    }

    protected void setLastPosition(ItemStack stack, Entity entity) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
        }
        stack.getTagCompound().setDouble("mmLastPosX", entity.posX);
        stack.getTagCompound().setDouble("mmLastPosY", entity.posY);
        stack.getTagCompound().setDouble("mmLastPosZ", entity.posZ);
    }
}

