/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.api.entity.MagicType;
import zeldaswordskills.api.item.IFairyUpgrade;
import zeldaswordskills.api.item.ISacredFlame;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.entity.projectile.EntityCyclone;
import zeldaswordskills.entity.projectile.EntityMagicSpell;
import zeldaswordskills.entity.projectile.EntityMobThrowable;
import zeldaswordskills.item.ISpawnParticles;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.client.PacketISpawnParticles;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;
import zeldaswordskills.util.WorldUtils;

public class ItemMagicRod
extends Item
implements IFairyUpgrade,
ISacredFlame,
ISpawnParticles,
IUnenchantable {
    private final MagicType magicType;
    private final float damage;
    private final float magic_cost;

    public ItemMagicRod(MagicType magicType, float damage, float magic_cost) {
        this.magicType = magicType;
        this.damage = damage;
        this.magic_cost = magic_cost;
        this.setFull3D();
        this.setMaxDamage(0);
        this.setMaxStackSize(1);
        this.setCreativeTab(ZSSCreativeTabs.tabTools);
    }

    private long getNextUseTime(ItemStack stack) {
        return stack.hasTagCompound() ? stack.getTagCompound().getLong("next_use") : 0L;
    }

    private void setNextUseTime(ItemStack stack, World world, int ticks) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
        }
        stack.getTagCompound().setLong("next_use", world.getTotalWorldTime() + (long)ticks);
    }

    private boolean hasAbsorbedFlame(ItemStack stack) {
        return stack.hasTagCompound() && stack.getTagCompound().getBoolean("absorbedFlame");
    }

    private boolean isUpgraded(ItemStack stack) {
        return stack.hasTagCompound() && stack.getTagCompound().getBoolean("isUpgraded");
    }

    public String getItemStackDisplayName(ItemStack stack) {
        String s = this.isUpgraded(stack) ? StatCollector.translateToLocal((String)"item.zss.rodmagic.nice") + " " : "";
        return s + StatCollector.translateToLocal((String)(this.getUnlocalizedName() + ".name"));
    }

    public int getItemEnchantability() {
        return 0;
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 72000;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        float mp = player.isSneaking() ? this.magic_cost : this.magic_cost / 20.0f;
        boolean isUpgraded = this.isUpgraded(stack);
        if (isUpgraded) {
            mp *= 1.5f;
        }
        if (player.capabilities.isCreativeMode || world.getTotalWorldTime() > this.getNextUseTime(stack) && ZSSPlayerInfo.get(player).useMagic(mp)) {
            if (player.isSneaking()) {
                EntityMobThrowable magic = this.magicType == MagicType.WIND ? new EntityCyclone(world, (EntityLivingBase)player).setArea(this.isUpgraded(stack) ? 3.0f : 2.0f) : new EntityMagicSpell(world, (EntityLivingBase)player).setType(this.magicType).setArea(isUpgraded ? 3.0f : 2.0f);
                magic.setDamage(isUpgraded ? this.damage * 1.5f : this.damage);
                if (!world.isRemote) {
                    WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:whoosh", 0.4f, 0.5f);
                    world.spawnEntityInWorld((Entity)magic);
                }
                this.setNextUseTime(stack, world, 10);
                player.swingItem();
            } else {
                player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
                if (this == ZSSItems.rodTornado) {
                    ZSSPlayerInfo.get((EntityPlayer)player).reduceFallAmount = ZSSPlayerInfo.get((EntityPlayer)player).reduceFallAmount + (this.isUpgraded(stack) ? 8.0f : 4.0f);
                }
            }
        } else {
            player.playSound("zeldaswordskills:magic_failure", 1.0f, 1.0f);
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        if (this == ZSSItems.rodTornado) {
            player.fallDistance = 0.0f;
        }
        if (!player.worldObj.isRemote) {
            int ticksInUse = this.getMaxItemUseDuration(stack) - count;
            float mp = this.magic_cost / 50.0f * (this.isUpgraded(stack) ? 1.5f : 1.0f);
            if (ticksInUse % 4 == 0 && !ZSSPlayerInfo.get(player).consumeMagic(mp)) {
                player.clearItemInUse();
            } else if (this == ZSSItems.rodTornado) {
                if (ticksInUse % 10 == 0) {
                    player.worldObj.spawnEntityInWorld((Entity)new EntityCyclone(player.worldObj, player.posX, player.posY, player.posZ).disableGriefing());
                }
            } else {
                this.handleUpdateTick(stack, player.worldObj, player, ticksInUse);
            }
        }
    }

    private void handleUpdateTick(ItemStack stack, World world, EntityPlayer player, int ticksInUse) {
        float r = 0.5f + Math.min(5.5f, (float)ticksInUse / 10.0f);
        if (this.isUpgraded(stack)) {
            r *= 1.5f;
        }
        PacketDispatcher.sendToAllAround(new PacketISpawnParticles(player, r), (Entity)player, 64.0);
        if (ticksInUse % 4 == 3) {
            this.affectBlocks(world, player, r);
            List<EntityLivingBase> targets = TargetUtils.acquireAllLookTargets((EntityLivingBase)player, Math.round(r), 1.0);
            for (EntityLivingBase target : targets) {
                target.attackEntityFrom(this.getDamageSource(player), r);
                if (this.magicType != MagicType.FIRE || target.isImmuneToFire()) continue;
                target.setFire(5);
            }
        }
        if (ticksInUse % this.magicType.getSoundFrequency() == 0) {
            world.playSoundAtEntity((Entity)player, this.magicType.getMovingSound(), this.magicType.getSoundVolume(world.rand), this.magicType.getSoundPitch(world.rand));
        }
    }

    private void affectBlocks(World world, EntityPlayer player, float radius) {
        HashSet<ChunkPosition> affectedBlocks = new HashSet<ChunkPosition>();
        Vec3 vec3 = player.getLookVec();
        double x = player.posX + vec3.xCoord;
        double y = player.posY + (double)player.getEyeHeight() + vec3.yCoord;
        double z = player.posZ + vec3.zCoord;
        int r = MathHelper.ceiling_float_int((float)radius);
        for (int n = 0; n < r; ++n) {
            int k;
            int j;
            int i = MathHelper.floor_double((double)x);
            if (this.canAddBlockPosition(world, player, i, j = MathHelper.floor_double((double)y), k = MathHelper.floor_double((double)z))) {
                affectedBlocks.add(new ChunkPosition(i, j, k));
            }
            x += vec3.xCoord;
            y += vec3.yCoord;
            z += vec3.zCoord;
        }
        ItemMagicRod.affectAllBlocks(world, affectedBlocks, this.magicType);
    }

    private boolean canAddBlockPosition(World world, EntityPlayer player, int i, int j, int k) {
        Vec3 vec32;
        Vec3 vec31 = Vec3.createVectorHelper((double)player.posX, (double)(player.posY + (double)player.getEyeHeight()), (double)player.posZ);
        MovingObjectPosition mop = world.rayTraceBlocks(vec31, vec32 = Vec3.createVectorHelper((double)i, (double)j, (double)k));
        return mop == null || mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK && mop.blockX == i && mop.blockY == j && mop.blockZ == k || !world.getBlock(mop.blockX, mop.blockY, mop.blockZ).getBlocksMovement((IBlockAccess)world, mop.blockX, mop.blockY, mop.blockZ);
    }

    public static void affectAllBlocks(World world, Set<ChunkPosition> blocks, MagicType type) {
        for (ChunkPosition p : blocks) {
            Block block = world.getBlock(p.chunkPosX, p.chunkPosY, p.chunkPosZ);
            switch (type) {
                case FIRE: {
                    if (WorldUtils.canMeltBlock(world, block, p.chunkPosX, p.chunkPosY, p.chunkPosZ) && world.rand.nextInt(4) == 0) {
                        world.setBlockToAir(p.chunkPosX, p.chunkPosY, p.chunkPosZ);
                        world.playSoundEffect((double)p.chunkPosX + 0.5, (double)p.chunkPosY + 0.5, (double)p.chunkPosZ + 0.5, "random.fizz", 1.0f, world.rand.nextFloat() * 0.4f + 0.8f);
                        break;
                    }
                    if (block.getMaterial() == Material.air && world.getBlock(p.chunkPosX, p.chunkPosY - 1, p.chunkPosZ).func_149730_j() && world.rand.nextInt(8) == 0) {
                        world.setBlock(p.chunkPosX, p.chunkPosY, p.chunkPosZ, (Block)Blocks.fire);
                        world.playSoundEffect((double)p.chunkPosX + 0.5, (double)p.chunkPosY + 0.5, (double)p.chunkPosZ + 0.5, "fire.ignite", 1.0f, world.rand.nextFloat() * 0.4f + 0.8f);
                        break;
                    }
                    if (block != ZSSBlocks.bombFlower) break;
                    block.onBlockExploded(world, p.chunkPosX, p.chunkPosY, p.chunkPosZ, null);
                    break;
                }
                case ICE: {
                    if (block.getMaterial() == Material.water && world.rand.nextInt(4) == 0) {
                        world.setBlock(p.chunkPosX, p.chunkPosY, p.chunkPosZ, Blocks.ice);
                        world.playSoundEffect((double)p.chunkPosX + 0.5, (double)p.chunkPosY + 0.5, (double)p.chunkPosZ + 0.5, "dig.glass", 1.0f, world.rand.nextFloat() * 0.4f + 0.8f);
                        break;
                    }
                    if (block.getMaterial() == Material.lava && world.rand.nextInt(8) == 0) {
                        Block solid = block == Blocks.lava ? Blocks.obsidian : Blocks.cobblestone;
                        world.setBlock(p.chunkPosX, p.chunkPosY, p.chunkPosZ, solid);
                        world.playSoundEffect((double)p.chunkPosX + 0.5, (double)p.chunkPosY + 0.5, (double)p.chunkPosZ + 0.5, "random.fizz", 1.0f, world.rand.nextFloat() * 0.4f + 0.8f);
                        break;
                    }
                    if (block.getMaterial() != Material.fire) break;
                    world.setBlockToAir(p.chunkPosX, p.chunkPosY, p.chunkPosZ);
                    world.playSoundEffect((double)p.chunkPosX + 0.5, (double)p.chunkPosY + 0.5, (double)p.chunkPosZ + 0.5, "random.fizz", 1.0f, world.rand.nextFloat() * 0.4f + 0.8f);
                    break;
                }
            }
        }
    }

    private DamageSource getDamageSource(EntityPlayer player) {
        switch (this.magicType) {
            case ICE: {
                return new DamageUtils.DamageSourceIce("blast.ice", (Entity)player, 60, 1, true);
            }
        }
        return new DamageUtils.DamageSourceFire("blast.fire", (Entity)player, true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(World world, EntityPlayer player, ItemStack stack, double x, double y, double z, float radius) {
        Vec3 look = player.getLookVec();
        for (float f = 0.0f; f < radius; f += 0.5f) {
            x += look.xCoord;
            y += look.yCoord;
            z += look.zCoord;
            for (int i = 0; i < 4; ++i) {
                world.spawnParticle(this.magicType.getTrailingParticle(), x + 0.5 - (double)world.rand.nextFloat(), y + 0.5 - (double)world.rand.nextFloat(), z + 0.5 - (double)world.rand.nextFloat(), look.xCoord * (double)(0.5f * world.rand.nextFloat()), look.yCoord * 0.15, look.zCoord * (double)(0.5f * world.rand.nextFloat()));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack) {
        return this.isUpgraded(stack) ? EnumRarity.rare : EnumRarity.common;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.itemIcon = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9));
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)("tooltip." + this.getUnlocalizedName().substring(5) + ".desc.0")));
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)("tooltip." + this.getUnlocalizedName().substring(5) + ".desc.1")));
        list.add("");
        list.add(EnumChatFormatting.RED + StatCollector.translateToLocalFormatted((String)"tooltip.zss.damage", (Object[])new Object[]{"", String.format("%.1f", Float.valueOf(this.isUpgraded(stack) ? this.damage * 1.5f : this.damage))}));
        if (this != ZSSItems.rodTornado) {
            list.add(EnumChatFormatting.YELLOW + StatCollector.translateToLocalFormatted((String)"tooltip.zss.area", (Object[])new Object[]{String.format("%.1f", Float.valueOf(this.isUpgraded(stack) ? 3.0f : 2.0f))}));
        }
    }

    @Override
    public boolean onActivatedSacredFlame(ItemStack stack, World world, EntityPlayer player, int type, boolean isActive) {
        return false;
    }

    @Override
    public boolean onClickedSacredFlame(ItemStack stack, World world, EntityPlayer player, int type, boolean isActive) {
        if (!world.isRemote) {
            if (this.hasAbsorbedFlame(stack)) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.sacred_flame.old.any", new ChatComponentTranslation(stack.getUnlocalizedName() + ".name", new Object[0]));
            } else if (isActive) {
                boolean canAbsorb = false;
                switch (this.magicType) {
                    case FIRE: {
                        canAbsorb = type == 1;
                        break;
                    }
                    case ICE: {
                        canAbsorb = type == 4;
                        break;
                    }
                    case WIND: {
                        canAbsorb = type == 2;
                        break;
                    }
                }
                if (canAbsorb) {
                    if (!stack.hasTagCompound()) {
                        stack.setTagCompound(new NBTTagCompound());
                    }
                    stack.getTagCompound().setBoolean("absorbedFlame", true);
                    world.playSoundAtEntity((Entity)player, "zeldaswordskills:flame_absorb", 1.0f, 1.0f);
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.sacred_flame.new", new ChatComponentTranslation(stack.getUnlocalizedName() + ".name", new Object[0]), new ChatComponentTranslation("misc.zss.sacred_flame.name." + type, new Object[0]));
                    return true;
                }
                PlayerUtils.sendTranslatedChat(player, "chat.zss.sacred_flame.random", new Object[0]);
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.sacred_flame.inactive", new Object[0]);
            }
            WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:swordmiss", 0.4f, 0.5f);
        }
        return false;
    }

    @Override
    public void handleFairyUpgrade(EntityItem item, EntityPlayer player, TileEntityDungeonCore core) {
        int cost = Math.round((float)Config.getRodUpgradeCost() * (this.magicType == MagicType.WIND ? 0.75f : 1.0f));
        if (core.consumeRupees(cost)) {
            if (!item.getEntityItem().hasTagCompound()) {
                item.getEntityItem().setTagCompound(new NBTTagCompound());
            }
            item.getEntityItem().getTagCompound().setBoolean("isUpgraded", true);
            core.getWorldObj().playSoundEffect((double)core.xCoord + 0.5, (double)(core.yCoord + 1), (double)core.zCoord + 0.5, "zeldaswordskills:secret_medley", 1.0f, 1.0f);
        } else {
            core.getWorldObj().playSoundEffect((double)core.xCoord + 0.5, (double)(core.yCoord + 1), (double)core.zCoord + 0.5, "zeldaswordskills:fairy_laugh", 1.0f, 1.0f);
            PlayerUtils.sendTranslatedChat(player, "chat.zss.fairy.laugh.unworthy", new Object[0]);
        }
    }

    @Override
    public boolean hasFairyUpgrade(ItemStack stack) {
        return !this.isUpgraded(stack) && this.hasAbsorbedFlame(stack);
    }
}

