/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldInfo;
import zeldaswordskills.api.block.IQuakeBlock;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.block.BlockAncientTablet;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.EntityEtherLightning;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.item.ISpawnParticles;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.client.PacketISpawnParticles;
import zeldaswordskills.ref.Config;

public class ItemMedallion
extends Item
implements ISpawnParticles {
    @SideOnly(value=Side.CLIENT)
    private List<IIcon> icons;

    public ItemMedallion() {
        this.setFull3D();
        this.setMaxDamage(0);
        this.setMaxStackSize(1);
        this.setHasSubtypes(true);
        this.setCreativeTab(ZSSCreativeTabs.tabTools);
    }

    public String getUnlocalizedName(ItemStack stack) {
        return this.getUnlocalizedName() + "_" + BlockAncientTablet.EnumType.byMetadata(stack.getItemDamage()).getName();
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return BlockAncientTablet.EnumType.byMetadata(stack.getItemDamage()).getItemUseDuration();
    }

    public EnumAction getItemUseAction(ItemStack stack) {
        return EnumAction.block;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        int requiredTicks = this.getMaxItemUseDuration(stack);
        if (requiredTicks > 0) {
            player.setItemInUse(stack, requiredTicks);
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        if (count % 4 == 0) {
            for (int i = 0; i < 4; ++i) {
                player.worldObj.spawnParticle("witchMagic", player.posX + player.worldObj.rand.nextGaussian() * 0.13, player.posY + (double)(player.height / 2.0f) + player.worldObj.rand.nextGaussian() * 0.13, player.posZ + player.worldObj.rand.nextGaussian() * 0.13, 0.0, 0.0, 0.0);
            }
        }
        if (count % 10 == 0) {
            // empty if block
        }
        if (count == 1) {
            if (!ZSSPlayerInfo.get(player).useMagic(40.0f)) {
                player.playSound("zeldaswordskills:magic_failure", 1.0f, 1.0f);
            } else if (!player.worldObj.isRemote) {
                this.onItemUseFinish(stack, player.worldObj, player);
            }
        }
    }

    private void onItemUseFinish(ItemStack stack, World world, EntityPlayer player) {
        BlockAncientTablet.EnumType type = BlockAncientTablet.EnumType.byMetadata(stack.getItemDamage());
        switch (type) {
            case ETHER: {
                world.playSoundEffect(player.posX, player.posY, player.posZ, "ambient.weather.thunder", 10000.0f, 0.8f + world.rand.nextFloat() * 0.2f);
                world.playSoundEffect(player.posX, player.posY, player.posZ, "random.explode", 2.0f, 0.5f + world.rand.nextFloat() * 0.2f);
                this.affectEntities(world, player, type, 8.0f);
                if (!(world instanceof WorldServer) || !world.isRaining() && !world.isThundering()) break;
                WorldInfo worldinfo = ((WorldServer)world).getWorldInfo();
                worldinfo.setRaining(false);
                worldinfo.setRainTime(0);
                worldinfo.setThundering(false);
                worldinfo.setThunderTime(0);
                break;
            }
            case QUAKE: {
                world.playSoundEffect(player.posX, player.posY, player.posZ, "zeldaswordskills:rock_fall", 1.0f, 1.0f);
                PacketDispatcher.sendToAllAround(new PacketISpawnParticles(player, 8.0f), (Entity)player, 64.0);
                this.affectBlocks(world, player, type, 8.0f);
                this.affectEntities(world, player, type, 8.0f);
                break;
            }
        }
    }

    private void affectEntities(World world, EntityPlayer player, BlockAncientTablet.EnumType type, float radius) {
        List list = world.getEntitiesWithinAABB(EntityLivingBase.class, player.boundingBox.expand((double)radius, (double)radius, (double)radius));
        block4: for (EntityLivingBase entity : list) {
            if (!this.canAffectEntity(player, entity)) continue;
            switch (type) {
                case ETHER: {
                    if (world.isRemote) break;
                    world.addWeatherEffect((Entity)new EntityEtherLightning(world, (EntityLivingBase)player, entity, entity.posX, entity.posY, entity.posZ));
                    break;
                }
                case QUAKE: {
                    if (!entity.onGround) break;
                    if (world.isRemote) {
                        for (int i = 0; i < 4; ++i) {
                            world.spawnParticle("explode", entity.posX, entity.posY + (double)(entity.height / 2.0f), entity.posZ, 0.0, 0.0, 0.0);
                        }
                        continue block4;
                    }
                    int duration = world.rand.nextInt(20) + world.rand.nextInt(20) + 20;
                    DamageSource quakeSource = new DamageUtils.DamageSourceQuakeIndirect("quake", null, (Entity)player, duration, 0).setMagicDamage().setDamageBypassesArmor();
                    entity.attackEntityFrom(quakeSource, 10.0f);
                    world.playSoundEffect(entity.posX, entity.posY, entity.posZ, "zeldaswordskills:rock_fall", 1.0f, 1.0f);
                    break;
                }
            }
        }
    }

    private boolean canAffectEntity(EntityPlayer player, EntityLivingBase target) {
        if (target instanceof IMob || target instanceof EntityPlayer && Config.doMedallionsDamagePlayers()) {
            return target != player && !target.isOnSameTeam((EntityLivingBase)player);
        }
        return false;
    }

    private void affectBlocks(World world, EntityPlayer player, BlockAncientTablet.EnumType type, float radius) {
        if (type != BlockAncientTablet.EnumType.QUAKE) {
            return;
        }
        int r = MathHelper.ceiling_float_int((float)radius);
        int ry = Math.max(1, r / 2);
        int dx = MathHelper.floor_double((double)player.posX);
        int dy = MathHelper.floor_double((double)player.posY);
        int dz = MathHelper.floor_double((double)player.posZ);
        for (int i = 0; i <= r; ++i) {
            for (int j = -ry; j <= ry; ++j) {
                for (int k = 0; k <= r; ++k) {
                    this.affectBlockAt(world, player, dx + i, dy + j, dz + k);
                    this.affectBlockAt(world, player, dx + i, dy + j, dz - k);
                    this.affectBlockAt(world, player, dx - i, dy + j, dz + k);
                    this.affectBlockAt(world, player, dx - i, dy + j, dz - k);
                }
            }
        }
    }

    private void affectBlockAt(World world, EntityPlayer player, int x, int y, int z) {
        if (world.isRemote) {
            this.spawnParticlesAt(world, x, y, z);
        } else {
            Block block = world.getBlock(x, y, z);
            if (block instanceof IQuakeBlock) {
                ((IQuakeBlock)block).handleQuakeEffect(world, x, y, z, player);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(World world, EntityPlayer player, ItemStack stack, double x, double y, double z, float r) {
        if (stack.getItemDamage() != BlockAncientTablet.EnumType.QUAKE.ordinal()) {
            return;
        }
        this.affectBlocks(world, player, BlockAncientTablet.EnumType.QUAKE, r);
        this.affectEntities(world, player, BlockAncientTablet.EnumType.QUAKE, r);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticlesAt(World world, int x, int y, int z) {
        if (!world.isAirBlock(x, y, z)) {
            return;
        }
        Block block = world.getBlock(x, y - 1, z);
        if (block.getMaterial() != Material.air) {
            String particle = "blockcrack_" + Block.getIdFromBlock((Block)block) + "_" + world.getBlockMetadata(x, y - 1, z);
            for (int n = 0; n < 4; ++n) {
                double dx = (float)x + world.rand.nextFloat() - 0.5f;
                double dy = (float)y + world.rand.nextFloat() * 0.2f;
                double dz = (float)z + world.rand.nextFloat() - 0.5f;
                world.spawnParticle(particle, dx, dy, dz, world.rand.nextGaussian(), 0.0, world.rand.nextGaussian());
            }
            if (world.rand.nextInt(8) == 0) {
                world.playSoundEffect((double)x, (double)y, (double)z, "zeldaswordskills:rock_fall", 1.0f, 1.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tab, List list) {
        for (BlockAncientTablet.EnumType type : BlockAncientTablet.EnumType.values()) {
            list.add(new ItemStack(item, 1, type.ordinal()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int damage) {
        return this.icons.get(damage % this.icons.size());
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.icons = new ArrayList<IIcon>(BlockAncientTablet.EnumType.values().length);
        for (BlockAncientTablet.EnumType type : BlockAncientTablet.EnumType.values()) {
            this.icons.add(register.registerIcon("zeldaswordskills:medallion_" + type.getName()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
        BlockAncientTablet.EnumType type = BlockAncientTablet.EnumType.byMetadata(stack.getItemDamage());
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)("tooltip.zss.medallion" + type.getName() + ".desc.0")));
    }
}

