/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import zeldaswordskills.api.item.IHandlePickup;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.PlayerUtils;

public abstract class ItemPickupOnly
extends Item
implements IHandlePickup,
IUnenchantable {
    public ItemPickupOnly(String name) {
        this.setMaxStackSize(1);
        this.setUnlocalizedName("zss." + name);
        this.setTextureName("zeldaswordskills:" + name);
        this.setCreativeTab(ZSSCreativeTabs.tabTools);
    }

    public static class ItemMagicJar
    extends ItemPickupOnly {
        private final int restoreMp;

        public ItemMagicJar(String name, int restoreMp) {
            super(name);
            this.restoreMp = restoreMp;
        }

        @Override
        public boolean onPickupItem(ItemStack stack, EntityPlayer player) {
            ZSSPlayerInfo info = ZSSPlayerInfo.get(player);
            if (info.getCurrentMagic() < info.getMaxMagic() || Config.alwaysPickupHearts()) {
                --stack.stackSize;
                info.restoreMagic(this.restoreMp);
                PlayerUtils.playSound(player, "zeldaswordskills:success_magic", 0.6f, 1.0f);
                return true;
            }
            return false;
        }
    }
}

