/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.api.item.ISacredFlame;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.item.ISpawnParticles;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.client.PacketISpawnParticles;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WarpPoint;
import zeldaswordskills.util.WorldUtils;

public class ItemSpiritCrystal
extends Item
implements ISacredFlame,
ISpawnParticles {
    private final int spiritType;
    private final int costToUse;
    private final int timeToUse;

    public ItemSpiritCrystal(int type, int cost, int time) {
        this.spiritType = type;
        this.costToUse = cost;
        this.timeToUse = time;
        this.setMaxDamage(128);
        this.setMaxStackSize(1);
        this.setCreativeTab(ZSSCreativeTabs.tabTools);
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return this.timeToUse;
    }

    public EnumAction getItemUseAction(ItemStack stack) {
        return EnumAction.block;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return true;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        if (!ZSSPlayerInfo.get(player).canUseMagic()) {
            player.playSound("zeldaswordskills:magic_failure", 1.0f, 1.0f);
            return stack;
        }
        int cost = 0;
        if (this.spiritType == 2 && player.isSneaking()) {
            if (ZSSPlayerInfo.get(player).useMagic(2.0f)) {
                this.mark(stack, world, player);
                cost = 1;
            } else {
                player.playSound("zeldaswordskills:magic_failure", 1.0f, 1.0f);
            }
        } else if (this.spiritType == 4) {
            cost = this.handleNayru(stack, world, player);
        } else {
            player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
            String sound = this.spiritType == 1 ? "zeldaswordskills:success_magic" : "zeldaswordskills:flame_absorb";
            player.playSound(sound, 1.0f, 1.0f);
        }
        if (this.damageStack(stack, player, cost)) {
            stack = new ItemStack(ZSSItems.crystalSpirit);
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        if (count == 1) {
            int cost = 0;
            switch (this.spiritType) {
                case 1: {
                    cost = this.handleDin(stack, player.worldObj, player);
                    break;
                }
                case 2: {
                    cost = this.handleFarore(stack, player.worldObj, player);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    ZSSMain.logger.warn("Invalid spirit type " + this.spiritType + " while using spirit crystal");
                }
            }
            if (this.damageStack(stack, player, cost)) {
                player.setCurrentItemOrArmor(0, new ItemStack(ZSSItems.crystalSpirit));
            }
        }
    }

    @Override
    public boolean onActivatedSacredFlame(ItemStack stack, World world, EntityPlayer player, int type, boolean isActive) {
        return false;
    }

    @Override
    public boolean onClickedSacredFlame(ItemStack stack, World world, EntityPlayer player, int type, boolean isActive) {
        if (world.isRemote) {
            return false;
        }
        if (stack.getItemDamage() == 0) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.spirit_crystal.sacred_flame.full", new Object[0]);
        } else if (isActive) {
            if (this.spiritType == type) {
                int originalDamage = stack.getItemDamage();
                stack.setItemDamage(0);
                world.playSoundAtEntity((Entity)player, "zeldaswordskills:success_magic", 1.0f, 1.0f);
                return world.rand.nextInt(stack.getMaxDamage()) < originalDamage;
            }
            PlayerUtils.sendTranslatedChat(player, "chat.zss.spirit_crystal.sacred_flame.mismatch", new Object[0]);
        } else {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.sacred_flame.inactive", new Object[0]);
        }
        return false;
    }

    private boolean damageStack(ItemStack stack, EntityPlayer player, int amount) {
        if (amount > 0) {
            stack.damageItem(amount, (EntityLivingBase)player);
            return stack.stackSize == 0;
        }
        return false;
    }

    private boolean canUse(ItemStack stack) {
        return stack.getMaxDamage() - stack.getItemDamage() >= this.costToUse;
    }

    private int handleDin(ItemStack stack, World world, EntityPlayer player) {
        if (!ZSSPlayerInfo.get(player).useMagic(40.0f)) {
            player.playSound("zeldaswordskills:magic_failure", 1.0f, 1.0f);
            return 0;
        }
        float radius = 5.0f;
        if (!world.isRemote) {
            PacketDispatcher.sendToAllAround(new PacketISpawnParticles(player, radius), (Entity)player, 64.0);
            this.affectDinBlocks(world, player, radius);
        }
        this.affectDinEntities(world, player, radius);
        world.playSoundAtEntity((Entity)player, "random.explode", 4.0f, (1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.2f) * 0.7f);
        return this.costToUse;
    }

    private void affectDinBlocks(World world, EntityPlayer player, float radius) {
        ArrayList<ChunkPosition> affectedBlockPositions = new ArrayList<ChunkPosition>(WorldUtils.getAffectedBlocksList(world, world.rand, radius, player.posX, player.posY, player.posZ, null));
        for (ChunkPosition chunkposition : affectedBlockPositions) {
            int i = chunkposition.chunkPosX;
            int j = chunkposition.chunkPosY;
            int k = chunkposition.chunkPosZ;
            Block block = world.getBlock(i, j, k);
            if (block.getMaterial() == Material.air && Config.isDinIgniteEnabled()) {
                Block block1 = world.getBlock(i, j - 1, k);
                if (!block1.func_149730_j() || world.rand.nextInt(8) != 0) continue;
                world.setBlock(i, j, k, (Block)Blocks.fire);
                continue;
            }
            if (!WorldUtils.canMeltBlock(world, block, i, j, k)) continue;
            world.playSoundEffect((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.fizz", 1.0f, world.rand.nextFloat() * 0.4f + 0.8f);
            world.setBlockToAir(i, j, k);
        }
    }

    private void affectDinEntities(World world, EntityPlayer player, float radius) {
        int i = MathHelper.floor_double((double)(player.posX - (double)radius - 1.0));
        int j = MathHelper.floor_double((double)(player.posX + (double)radius + 1.0));
        int k = MathHelper.floor_double((double)(player.posY - (double)radius - 1.0));
        int l1 = MathHelper.floor_double((double)(player.posY + (double)radius + 1.0));
        int i2 = MathHelper.floor_double((double)(player.posZ - (double)radius - 1.0));
        int j2 = MathHelper.floor_double((double)(player.posZ + (double)radius + 1.0));
        List list = world.getEntitiesWithinAABBExcludingEntity((Entity)player, AxisAlignedBB.getBoundingBox((double)i, (double)k, (double)i2, (double)j, (double)l1, (double)j2));
        Vec3 vec3 = Vec3.createVectorHelper((double)player.posX, (double)player.posY, (double)player.posZ);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            double d2;
            Entity entity;
            double d0 = entity.posX - player.posX;
            entity = (Entity)list.get(k2);
            double d1 = entity.posY + (double)entity.getEyeHeight() - player.posY;
            double d8 = MathHelper.sqrt_double((double)(d0 * d0 + d1 * d1 + (d2 = entity.posZ - player.posZ) * d2));
            if (d8 == 0.0) continue;
            d0 /= d8;
            d1 /= d8;
            d2 /= d8;
            double d10 = world.getBlockDensity(vec3, entity.boundingBox);
            float amount = 32.0f * (float)d10;
            if (entity.isImmuneToFire()) {
                amount *= 0.25f;
            }
            if (entity.attackEntityFrom(new DamageUtils.DamageSourceFireIndirect("magic.din", (Entity)player, (Entity)player, true).setMagicDamage(), amount) && !entity.isImmuneToFire() && (double)world.rand.nextFloat() < d10) {
                entity.setFire(10);
            }
            double d11 = EnchantmentProtection.func_92092_a((Entity)entity, (double)d10);
            entity.motionX += d0 * d11;
            entity.motionY += d1 * d11;
            entity.motionZ += d2 * d11;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(World world, EntityPlayer player, ItemStack stack, double posX, double posY, double posZ, float radius) {
        int i1 = MathHelper.floor_double((double)(posX + (double)radius));
        int j1 = MathHelper.floor_double((double)(posY + (double)radius));
        int k1 = MathHelper.floor_double((double)(posZ + (double)radius));
        for (int i = MathHelper.floor_double((double)(posX - (double)radius)); i < i1; ++i) {
            for (int j = MathHelper.floor_double((double)(posY - (double)radius + 1.0)); j < j1; ++j) {
                for (int k = MathHelper.floor_double((double)(posZ - (double)radius)); k < k1; ++k) {
                    double d0 = (float)i + world.rand.nextFloat();
                    double d1 = (float)j + world.rand.nextFloat();
                    double d2 = (float)k + world.rand.nextFloat();
                    double d3 = d0 - posX;
                    double d4 = d1 - posY;
                    double d5 = d2 - posZ;
                    double d6 = MathHelper.sqrt_double((double)(d3 * d3 + d4 * d4 + d5 * d5));
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d7 = 0.5 / (d6 / (double)radius + 0.1);
                    world.spawnParticle("flame", (d0 + posX * 1.0) / 2.0, (d1 + posY * 1.0) / 2.0, (d2 + posZ * 1.0) / 2.0, d3 *= (d7 *= (double)(world.rand.nextFloat() * world.rand.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7);
                    world.spawnParticle("smoke", d0, d1, d2, d3, d4, d5);
                }
            }
        }
    }

    private int handleFarore(ItemStack stack, World world, EntityPlayer player) {
        String fail = null;
        if (this.canUse(stack)) {
            WarpPoint warp = this.recall(stack);
            if (warp == null) {
                fail = "chat.zss.spirit_crystal.farore.fail.mark";
            } else if (warp.dimensionId != player.worldObj.provider.dimensionId) {
                fail = "chat.zss.spirit_crystal.farore.fail.dimension";
            } else if (ZSSPlayerInfo.get(player).useMagic(10.0f)) {
                player.setPositionAndUpdate((double)warp.x + 0.5, (double)warp.y + 0.5, (double)warp.z + 0.5);
                player.playSound("zeldaswordskills:success_magic", 1.0f, 1.0f);
                return this.costToUse;
            }
        }
        player.playSound("zeldaswordskills:magic_failure", 1.0f, 1.0f);
        if (fail != null && !world.isRemote) {
            PlayerUtils.sendTranslatedChat(player, fail, new Object[0]);
        }
        return 0;
    }

    private int handleNayru(ItemStack stack, World world, EntityPlayer player) {
        if (!Config.allowUnlimitedNayru() && ZSSEntityInfo.get((EntityLivingBase)player).isBuffActive(Buff.UNLIMITED_MAGIC)) {
            player.playSound("zeldaswordskills:magic_failure", 1.0f, 1.0f);
            if (!world.isRemote) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.spirit_crystal.nayru.unlimited.fail", new Object[0]);
            }
        } else if (this.canUse(stack) && ZSSPlayerInfo.get(player).useMagic(25.0f)) {
            ZSSPlayerInfo.get(player).activateNayru();
            world.playSoundAtEntity((Entity)player, "zeldaswordskills:success_magic", 1.0f, 1.0f);
            return this.costToUse;
        }
        return 0;
    }

    private void mark(ItemStack stack, World world, EntityPlayer player) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
        }
        WarpPoint warp = new WarpPoint(world.provider.dimensionId, MathHelper.floor_double((double)player.posX), MathHelper.floor_double((double)player.posY), MathHelper.floor_double((double)player.posZ));
        stack.getTagCompound().setTag("zssRecallPoint", (NBTBase)warp.writeToNBT());
        world.playSoundAtEntity((Entity)player, "zeldaswordskills:success_magic", 1.0f, 1.0f);
    }

    private WarpPoint recall(ItemStack stack) {
        if (stack.hasTagCompound() && stack.getTagCompound().hasKey("zssRecallPoint", 10)) {
            return WarpPoint.readFromNBT(stack.getTagCompound().getCompoundTag("zssRecallPoint"));
        }
        if (stack.hasTagCompound() && stack.getTagCompound().hasKey("zssFWdimension")) {
            int dimension = stack.getTagCompound().getInteger("zssFWdimension");
            double x = stack.getTagCompound().getDouble("zssFWposX");
            double y = stack.getTagCompound().getDouble("zssFWposY");
            double z = stack.getTagCompound().getDouble("zssFWposZ");
            return new WarpPoint(dimension, MathHelper.floor_double((double)x), MathHelper.floor_double((double)y), MathHelper.floor_double((double)z));
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.itemIcon = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9));
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)("tooltip." + this.getUnlocalizedName().substring(5) + ".desc.0")));
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)("tooltip." + this.getUnlocalizedName().substring(5) + ".desc.1")));
    }
}

