/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.battlegear2.api.PlayerEventChild;
import mods.battlegear2.api.weapons.IBattlegearWeapon;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.api.entity.IParryModifier;
import zeldaswordskills.api.item.IFairyUpgrade;
import zeldaswordskills.api.item.ISacredFlame;
import zeldaswordskills.api.item.ISwingSpeed;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.api.item.IWeapon;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

@Optional.Interface(iface="mods.battlegear2.api.weapons.IBattlegearWeapon", modid="battlegear2", striprefs=true)
public class ItemZeldaSword
extends ItemSword
implements IBattlegearWeapon,
IFairyUpgrade,
IParryModifier,
ISacredFlame,
ISwingSpeed,
IWeapon,
IUnenchantable {
    protected final float weaponDamage;
    protected final Item.ToolMaterial toolMaterial;
    protected boolean isMaster = false;
    protected final boolean twoHanded;
    protected final int swingSpeed;
    protected final float exhaustion;
    @SideOnly(value=Side.CLIENT)
    protected IIcon brokenIcon;
    protected boolean givesBrokenItem = true;

    public ItemZeldaSword(Item.ToolMaterial material, float bonusDamage) {
        this(material, bonusDamage, false, 0, 0.0f);
    }

    public ItemZeldaSword(Item.ToolMaterial material, float bonusDamage, boolean twoHanded) {
        this(material, bonusDamage, twoHanded, twoHanded ? 15 : 0, twoHanded ? 0.3f : 0.0f);
    }

    public ItemZeldaSword(Item.ToolMaterial material, float bonusDamage, boolean twoHanded, int swingSpeed, float exhaustion) {
        super(material);
        this.setNoRepair();
        this.toolMaterial = material;
        this.weaponDamage = 4.0f + bonusDamage + material.getDamageVsEntity();
        this.twoHanded = twoHanded;
        this.swingSpeed = Math.max(0, swingSpeed);
        this.exhaustion = Math.max(0.0f, exhaustion);
        this.setCreativeTab(ZSSCreativeTabs.tabCombat);
    }

    public ItemZeldaSword setMasterSword() {
        this.setNoItemOnBreak();
        this.isMaster = true;
        return this;
    }

    public boolean isMasterSword() {
        return this.isMaster;
    }

    public ItemZeldaSword setNoItemOnBreak() {
        this.givesBrokenItem = false;
        return this;
    }

    @Override
    public float getOffensiveModifier(EntityLivingBase entity, ItemStack stack) {
        return this.twoHanded ? 0.25f : 0.0f;
    }

    @Override
    public float getDefensiveModifier(EntityLivingBase entity, ItemStack stack) {
        return 0.0f;
    }

    @Override
    public float getExhaustion() {
        return this.exhaustion;
    }

    @Override
    public int getSwingSpeed() {
        return this.swingSpeed;
    }

    public int getItemEnchantability() {
        return this.isMaster ? 0 : super.getItemEnchantability();
    }

    public boolean hitEntity(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.damageItem(1, attacker);
        this.onStackDamaged(stack, attacker);
        return true;
    }

    public boolean onBlockDestroyed(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase entity) {
        if ((double)block.getBlockHardness(world, x, y, z) != 0.0) {
            stack.damageItem(stack.getItem() == ZSSItems.swordGiant ? stack.getMaxDamage() + 1 : 2, entity);
            this.onStackDamaged(stack, entity);
        }
        return true;
    }

    protected void onStackDamaged(ItemStack stack, EntityLivingBase entity) {
        if (stack.stackSize == 0 && this.givesBrokenItem && entity instanceof EntityPlayer) {
            PlayerUtils.addItemToInventory((EntityPlayer)entity, new ItemStack(ZSSItems.swordBroken, 1, Item.getIdFromItem((Item)this)));
        }
    }

    public Multimap getItemAttributeModifiers() {
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.attackDamage.getAttributeUnlocalizedName(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.weaponDamage, 0));
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int damage) {
        return damage == -1 ? this.brokenIcon : this.itemIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.itemIcon = register.registerIcon("zeldaswordskills:" + this.getUnlocalizedName().substring(9));
        if (this.givesBrokenItem) {
            this.brokenIcon = register.registerIcon("zeldaswordskills:broken_" + this.getUnlocalizedName().substring(9));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)("tooltip." + this.getUnlocalizedName().substring(5) + ".desc.0")));
        if (stack.getItem() == ZSSItems.swordTempered) {
            if (stack.hasTagCompound() && stack.getTagCompound().hasKey("zssHitCount")) {
                list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocalFormatted((String)"tooltip.zss.sword_tempered.desc.1", (Object[])new Object[]{stack.getTagCompound().getInteger("zssHitCount")}));
            }
        } else if (stack.getItem() == ZSSItems.swordGolden && stack.hasTagCompound() && stack.getTagCompound().hasKey("SacredFlames")) {
            int level = stack.getTagCompound().getInteger("SacredFlames");
            for (int i = 1; i < 5; ++i) {
                if (i == 3 || (level & i) == 0) continue;
                list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocalFormatted((String)"tooltip.zss.sword_golden.desc.1", (Object[])new Object[]{StatCollector.translateToLocal((String)("misc.zss.sacred_flame.name." + i))}));
            }
        }
    }

    @Override
    public void handleFairyUpgrade(EntityItem item, EntityPlayer player, TileEntityDungeonCore core) {
        ItemStack stack = item.getEntityItem();
        if (stack.hasTagCompound() && stack.getTagCompound().hasKey("zssHitCount") && stack.getTagCompound().getInteger("zssHitCount") > Config.getRequiredKills()) {
            item.setDead();
            WorldUtils.spawnItemWithRandom(core.getWorldObj(), new ItemStack(ZSSItems.swordGolden), core.xCoord, core.yCoord + 2, core.zCoord);
            core.getWorldObj().playSoundEffect((double)core.xCoord + 0.5, (double)(core.yCoord + 1), (double)core.zCoord + 0.5, "zeldaswordskills:fairy_blessing", 1.0f, 1.0f);
            PlayerUtils.sendTranslatedChat(player, "chat.zss.sword.blessing", new Object[0]);
            player.triggerAchievement((StatBase)ZSSAchievements.swordGolden);
        } else {
            core.getWorldObj().playSoundEffect((double)core.xCoord + 0.5, (double)(core.yCoord + 1), (double)core.zCoord + 0.5, "zeldaswordskills:fairy_laugh", 1.0f, 1.0f);
            PlayerUtils.sendTranslatedChat(player, "chat.zss.fairy.laugh.unworthy", new Object[0]);
        }
    }

    @Override
    public boolean hasFairyUpgrade(ItemStack stack) {
        return this == ZSSItems.swordTempered;
    }

    public static void onKilledMob(EntityPlayer player, IMob mob) {
        if (!player.worldObj.isRemote && player.getHeldItem() != null && player.getHeldItem().getItem() == ZSSItems.swordTempered) {
            ItemStack stack = player.getHeldItem();
            NBTTagCompound tag = stack.getTagCompound();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.setInteger("zssHitCount", tag.getInteger("zssHitCount") + 1);
            stack.setTagCompound(tag);
            if (tag.getInteger("zssHitCount") > Config.getRequiredKills()) {
                player.triggerAchievement((StatBase)ZSSAchievements.swordEvil);
            }
        }
    }

    @Override
    public boolean onActivatedSacredFlame(ItemStack stack, World world, EntityPlayer player, int type, boolean isActive) {
        return false;
    }

    @Override
    public boolean onClickedSacredFlame(ItemStack stack, World world, EntityPlayer player, int type, boolean isActive) {
        if (world.isRemote) {
            return false;
        }
        if (this == ZSSItems.swordGolden && isActive) {
            NBTTagCompound tag = stack.getTagCompound();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            if ((tag.getInteger("SacredFlames") & type) == 0) {
                tag.setInteger("SacredFlames", tag.getInteger("SacredFlames") | type);
                stack.setTagCompound(tag);
                world.playSoundAtEntity((Entity)player, "zeldaswordskills:flame_absorb", 1.0f, 1.0f);
                PlayerUtils.sendTranslatedChat(player, "chat.zss.sacred_flame.new", new ChatComponentTranslation(stack.getUnlocalizedName() + ".name", new Object[0]), new ChatComponentTranslation("misc.zss.sacred_flame.name." + type, new Object[0]));
                player.triggerAchievement((StatBase)ZSSAchievements.swordFlame);
                this.addSacredFlameEnchantments(stack, type);
                return true;
            }
            PlayerUtils.sendTranslatedChat(player, "chat.zss.sacred_flame.old.same", new ChatComponentTranslation(stack.getUnlocalizedName() + ".name", new Object[0]));
        } else if (isActive) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.sacred_flame.incorrect.sword", new Object[0]);
        } else {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.sacred_flame.inactive", new Object[0]);
        }
        WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:swordmiss", 0.4f, 0.5f);
        return false;
    }

    private void addSacredFlameEnchantments(ItemStack stack, int type) {
        switch (type) {
            case 1: {
                stack.addEnchantment(Enchantment.fireAspect, 2);
                break;
            }
            case 2: {
                stack.addEnchantment(Enchantment.knockback, 2);
                break;
            }
            case 4: {
                stack.addEnchantment(Enchantment.looting, 3);
            }
        }
        boolean flag = false;
        NBTTagList enchList = stack.getTagCompound().getTagList("ench", 10);
        for (int i = 0; i < enchList.tagCount(); ++i) {
            NBTTagCompound compound = enchList.getCompoundTagAt(i);
            if (compound.getShort("id") != Enchantment.sharpness.effectId) continue;
            short lvl = compound.getShort("lvl");
            if (lvl < Enchantment.sharpness.getMaxLevel()) {
                enchList.removeTag(i);
                stack.addEnchantment(Enchantment.sharpness, lvl + 1);
            }
            flag = true;
            break;
        }
        if (!flag) {
            stack.addEnchantment(Enchantment.sharpness, 1);
        }
    }

    @Override
    public boolean isSword(ItemStack stack) {
        return true;
    }

    @Override
    public boolean isWeapon(ItemStack stack) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean sheatheOnBack(ItemStack stack) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean isOffhandHandDual(ItemStack stack) {
        return (Config.allowOffhandMaster() || !this.isMaster) && !this.twoHanded;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandAttackEntity(PlayerEventChild.OffhandAttackEvent event, ItemStack main, ItemStack offhand) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandClickAir(PlayerInteractEvent event, ItemStack main, ItemStack offhand) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandClickBlock(PlayerInteractEvent event, ItemStack main, ItemStack offhand) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public void performPassiveEffects(Side side, ItemStack main, ItemStack offhand) {
    }

    @Optional.Method(modid="battlegear2")
    public boolean allowOffhand(ItemStack main, ItemStack offhand) {
        return !this.twoHanded;
    }
}

