/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item.crafting;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.oredict.RecipeSorter;
import zeldaswordskills.item.ItemBombBag;
import zeldaswordskills.item.ZSSItems;

public class RecipeCombineBombBag
implements IRecipe {
    public RecipeCombineBombBag() {
        RecipeSorter.register((String)"zeldaswordskills:combinebombbag", RecipeCombineBombBag.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
    }

    public boolean matches(InventoryCrafting grid, World world) {
        ItemStack bag = null;
        boolean flag = false;
        int found = 0;
        for (int i = 0; i < grid.getSizeInventory(); ++i) {
            ItemStack stack = grid.getStackInSlot(i);
            if (stack == null) continue;
            if (++found > 2) {
                return false;
            }
            if (!(stack.getItem() instanceof ItemBombBag)) continue;
            if (bag == null) {
                bag = stack;
                continue;
            }
            flag = ((ItemBombBag)bag.getItem()).areMatchingTypes(bag, stack, false);
        }
        return found == 2 && flag;
    }

    public ItemStack getCraftingResult(InventoryCrafting grid) {
        ItemStack bag = null;
        for (int i = 0; i < grid.getSizeInventory(); ++i) {
            ItemStack stack = grid.getStackInSlot(i);
            if (stack == null || !(stack.getItem() instanceof ItemBombBag)) continue;
            if (bag == null) {
                bag = stack.copy();
                continue;
            }
            if (!((ItemBombBag)bag.getItem()).canCombine(bag, stack)) continue;
            ItemBombBag bombBag = (ItemBombBag)bag.getItem();
            int capacity = bombBag.getCapacity(bag, true);
            bombBag.setCapacity(bag, capacity += ((ItemBombBag)stack.getItem()).getCapacity(stack, true));
            if (bombBag.getBagBombType(bag) < 0) {
                bombBag.setBagBombType(bag, ((ItemBombBag)stack.getItem()).getBagBombType(stack));
            }
            bombBag.addBombs(bag, ((ItemBombBag)stack.getItem()).getBombsHeld(stack));
            return bag;
        }
        return null;
    }

    public int getRecipeSize() {
        return 2;
    }

    public ItemStack getRecipeOutput() {
        return new ItemStack(ZSSItems.bombBag);
    }
}

