/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.network.bidirectional;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.MathHelper;
import zeldaswordskills.network.AbstractMessage;
import zeldaswordskills.network.PacketDispatcher;

public class PlayRecordPacket
extends AbstractMessage<PlayRecordPacket> {
    private String record;
    private int x;
    private int y;
    private int z;

    public PlayRecordPacket() {
    }

    public PlayRecordPacket(String record, Entity entity) {
        this(record, MathHelper.floor_double((double)entity.posX), MathHelper.floor_double((double)entity.posY), MathHelper.floor_double((double)entity.posZ));
    }

    public PlayRecordPacket(String record, int x, int y, int z) {
        this.record = record;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.record = buffer.readByte() > 0 ? ByteBufUtils.readUTF8String((ByteBuf)buffer) : null;
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeByte(this.record == null ? 0 : 1);
        if (this.record != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.record);
        }
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        if (side.isClient()) {
            player.worldObj.playRecord(this.record, this.x, this.y, this.z);
        } else {
            PacketDispatcher.sendToAllAround(this, (Entity)player, 64.0);
        }
    }
}

