/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.network.server;

import cpw.mods.fml.relauncher.Side;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import zeldaswordskills.item.ItemBombBag;
import zeldaswordskills.item.ItemMask;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.network.AbstractMessage;

public class GetBombPacket
extends AbstractMessage.AbstractServerMessage<GetBombPacket> {
    @Override
    protected void read(PacketBuffer buffer) throws IOException {
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        ItemStack heldItem = player.getHeldItem();
        ItemStack mask = player.getCurrentArmor(3);
        if (mask != null && mask.getItem() == ZSSItems.maskBlast) {
            ((ItemMask)mask.getItem()).explode(player, mask, player.worldObj, player.posX, player.posY, player.posZ);
        } else if (player.isSneaking() && heldItem != null && heldItem.getItem() instanceof ItemBombBag) {
            ((ItemBombBag)heldItem.getItem()).emptyBag(heldItem, player);
        } else {
            for (ItemStack invStack : player.inventory.mainInventory) {
                int type;
                if (invStack == null || !(invStack.getItem() instanceof ItemBombBag)) continue;
                ItemBombBag bombBag = (ItemBombBag)invStack.getItem();
                if (!player.capabilities.isCreativeMode && !bombBag.removeBomb(invStack)) continue;
                if (heldItem != null && (heldItem.isStackable() || !player.inventory.addItemStackToInventory(heldItem))) {
                    player.dropPlayerItemWithRandomChoice(heldItem, false);
                }
                player.setCurrentItemOrArmor(0, new ItemStack(ZSSItems.bomb, 1, (type = bombBag.getBagBombType(invStack)) > 0 ? type : 0));
                break;
            }
        }
    }
}

