/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills;

import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.SkillPassive;

public class BonusHeart
extends SkillPassive {
    public static final int MAX_BONUS_HEARTS = 50;
    private static final UUID bonusHeartUUID = UUID.fromString("14ED99DA-D333-4621-90C8-81C968A082E3");
    private static final AttributeModifier bonusHeartModifier = new AttributeModifier(bonusHeartUUID, "ZSS Bonus Heart", 2.0, 0).setSaved(true);

    public BonusHeart(String name) {
        super(name);
    }

    private BonusHeart(BonusHeart skill) {
        super(skill);
    }

    @Override
    public BonusHeart newInstance() {
        return new BonusHeart(this);
    }

    @Override
    public byte getMaxLevel() {
        return (byte)(Config.getMaxBonusHearts() + (Config.isHardcoreZeldaFan() ? 7 : 0));
    }

    @Override
    public String getIconTexture() {
        return "zeldaswordskills:heart_container";
    }

    @Override
    public boolean isLoot() {
        return false;
    }

    @Override
    protected void levelUp(EntityPlayer player) {
        IAttributeInstance attributeinstance = player.getEntityAttribute(SharedMonsterAttributes.maxHealth);
        if (attributeinstance.getModifier(bonusHeartUUID) != null) {
            attributeinstance.removeModifier(bonusHeartModifier);
        }
        AttributeModifier newModifier = new AttributeModifier(bonusHeartUUID, "Bonus Heart", (double)this.level * 2.0, 0).setSaved(true);
        attributeinstance.applyModifier(newModifier);
        player.heal(player.getMaxHealth());
    }

    @Override
    public void validateSkill(EntityPlayer player) {
        float health = player.getHealth();
        this.levelUp(player);
        player.setHealth(health);
    }
}

