/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.client.UpdateComboPacket;
import zeldaswordskills.skills.SkillBase;

public class Combo {
    private final byte skillId;
    private final int maxComboSize;
    private final int timeLimit;
    private int comboTimer = 0;
    private boolean isFinished = false;
    private final List<Float> damageList = new ArrayList<Float>();
    private float comboDamage = 0.0f;
    private boolean addToLast = false;
    private float lastDamage = 0.0f;
    private Entity lastEntityHit = null;
    private int entityId;
    private int consecutiveHits = 0;

    public Combo(EntityPlayer player, SkillBase skill, int maxComboSize, int timeLimit) {
        this.skillId = skill.getId();
        this.maxComboSize = maxComboSize;
        this.timeLimit = timeLimit;
        if (player instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new UpdateComboPacket(this), (EntityPlayerMP)player);
        }
    }

    private Combo(byte skillId, int maxComboSize, int timeLimit) {
        this.skillId = skillId;
        this.maxComboSize = maxComboSize;
        this.timeLimit = timeLimit;
    }

    public byte getSkill() {
        return this.skillId;
    }

    public int getNumHits() {
        return this.damageList.size();
    }

    public int getMaxNumHits() {
        return this.maxComboSize;
    }

    public float getDamage() {
        return this.comboDamage;
    }

    public List<Float> getDamageList() {
        return Collections.unmodifiableList(this.damageList);
    }

    public Entity getLastEntityHit() {
        return this.lastEntityHit;
    }

    public int getConsecutiveHits() {
        return this.consecutiveHits;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public String getLabel() {
        return StatCollector.translateToLocal((String)("combo.label." + this.getNumHits()));
    }

    public void onUpdate(EntityPlayer player) {
        if (this.comboTimer > 0) {
            --this.comboTimer;
            if (this.comboTimer == 0) {
                this.endCombo(player);
            }
        }
    }

    public void add(EntityPlayer player, Entity target, float damage) {
        if (this.getNumHits() < this.maxComboSize && (this.comboTimer > 0 || this.getNumHits() == 0)) {
            if (target != null && target == this.lastEntityHit) {
                ++this.consecutiveHits;
            } else {
                this.lastEntityHit = target;
                int n = this.consecutiveHits = target != null ? 1 : 0;
            }
            if (this.addToLast) {
                this.damageList.add(Float.valueOf(damage + this.lastDamage));
                this.addToLast = false;
                this.lastDamage = 0.0f;
            } else {
                this.damageList.add(Float.valueOf(damage));
            }
            switch (this.damageList.size()) {
                case 3: {
                    player.triggerAchievement((StatBase)ZSSAchievements.comboBasic);
                    break;
                }
                case 8: {
                    player.triggerAchievement((StatBase)ZSSAchievements.comboPerfect);
                    break;
                }
                case 12: {
                    player.triggerAchievement((StatBase)ZSSAchievements.comboLegend);
                }
            }
            this.comboDamage += damage;
            if (player instanceof EntityPlayerMP) {
                PacketDispatcher.sendTo(new UpdateComboPacket(this), (EntityPlayerMP)player);
            }
            if (this.getNumHits() == this.maxComboSize) {
                this.endCombo(player);
            } else {
                this.comboTimer = this.timeLimit;
            }
        } else {
            this.endCombo(player);
        }
    }

    public void addDamageOnly(EntityPlayer player, float damage, boolean flag) {
        if (!this.isFinished()) {
            this.comboDamage += damage;
            this.addToLast = flag;
            if (this.addToLast) {
                this.lastDamage = damage;
            }
            if (this.getNumHits() == 0) {
                this.comboTimer = this.timeLimit;
            }
            if (player instanceof EntityPlayerMP) {
                PacketDispatcher.sendTo(new UpdateComboPacket(this), (EntityPlayerMP)player);
            }
        }
    }

    public void endCombo(EntityPlayer player) {
        if (!this.isFinished) {
            this.isFinished = true;
            this.lastEntityHit = null;
            this.consecutiveHits = 0;
            if (player instanceof EntityPlayerMP) {
                PacketDispatcher.sendTo(new UpdateComboPacket(this), (EntityPlayerMP)player);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void getEntityFromWorld(World world) {
        this.lastEntityHit = world.getEntityByID(this.entityId);
    }

    public final NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.setByte("SkillID", this.skillId);
        compound.setInteger("MaxSize", this.maxComboSize);
        compound.setInteger("TimeLimit", this.timeLimit);
        compound.setInteger("CurrentSize", this.getNumHits());
        for (int i = 0; i < this.getNumHits(); ++i) {
            compound.setFloat("Dmg" + i, this.damageList.get(i).floatValue());
        }
        compound.setFloat("TotalDamage", this.comboDamage);
        compound.setInteger("EntityId", this.lastEntityHit != null ? this.lastEntityHit.getEntityId() : 0);
        compound.setInteger("ConsecutiveHits", this.consecutiveHits);
        compound.setBoolean("Finished", this.isFinished);
        return compound;
    }

    public static final Combo readFromNBT(NBTTagCompound compound) {
        Combo combo = new Combo(compound.getByte("SkillID"), compound.getInteger("MaxSize"), compound.getInteger("TimeLimit"));
        int size = compound.getInteger("CurrentSize");
        for (int i = 0; i < size; ++i) {
            combo.damageList.add(Float.valueOf(compound.getFloat("Dmg" + i)));
        }
        combo.comboDamage = compound.getFloat("TotalDamage");
        combo.entityId = compound.getInteger("EntityId");
        combo.consecutiveHits = compound.getInteger("ConsecutiveHits");
        combo.isFinished = compound.getBoolean("Finished");
        return combo;
    }
}

