/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import zeldaswordskills.api.entity.IEntityBackslice;
import zeldaswordskills.client.ZSSClientEvents;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.entity.mobs.EntityChu;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.ActivateSkillPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.ILockOnTarget;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;
import zeldaswordskills.util.WorldUtils;

public class BackSlice
extends SkillActive {
    private static Set<Class<? extends EntityLivingBase>> immuneEntities;
    @SideOnly(value=Side.CLIENT)
    private KeyBinding keyPressed;
    @SideOnly(value=Side.CLIENT)
    private int ticksTilFail;
    private int dodgeTimer = 0;
    private SkillActive targetingSkill;

    public BackSlice(String name) {
        super(name);
        BackSlice.init();
    }

    private BackSlice(BackSlice skill) {
        super(skill);
    }

    @Override
    public BackSlice newInstance() {
        return new BackSlice(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(StatCollector.translateToLocalFormatted((String)this.getInfoString("info", 1), (Object[])new Object[]{360 - 2 * this.getAttackAngle()}));
        desc.add(StatCollector.translateToLocalFormatted((String)this.getInfoString("info", 2), (Object[])new Object[]{String.format("%.2f", Float.valueOf(BackSlice.getDisarmorChance(null, player.getHeldItem(), this.level)))}));
        desc.add(this.getDamageDisplay(this.level * 10, true) + "%");
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean canDrop() {
        return false;
    }

    @Override
    public boolean isLoot() {
        return false;
    }

    private int getActiveTime() {
        return 15 + this.level;
    }

    private int getAttackAngle() {
        return 160 - this.level * 10;
    }

    private int getDodgeTime() {
        return 10 - this.level;
    }

    public static float getDisarmorChance(ItemStack armorStack, ItemStack weapon, int level) {
        float chance = (float)level * 0.05f;
        if (armorStack != null && armorStack.getItem() instanceof ItemArmor) {
            ItemArmor armor = (ItemArmor)armorStack.getItem();
            int i = armor.getArmorMaterial().getDamageReductionAmount(armor.armorType);
            chance += (float)(5 - i) * 0.05f;
            i = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.unbreaking.effectId, (ItemStack)armorStack);
            if (i > 0) {
                chance -= (float)i * 0.05f;
            }
        }
        if (weapon != null) {
            int i = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.sharpness.effectId, (ItemStack)weapon);
            if (i > 0) {
                chance += (float)i * 0.05f;
            }
        } else {
            chance -= 1.0f;
        }
        return chance;
    }

    @Override
    public boolean isActive() {
        return this.dodgeTimer > 0;
    }

    @Override
    protected float getExhaustion() {
        return 1.0f - 0.1f * (float)this.level;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && PlayerUtils.isWeapon(player.getHeldItem()) && ZSSPlayerSkills.get(player).isSkillActive(swordBasic);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return player.onGround && this.canUse(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        if (this.isActive()) {
            return key == ZSSKeyHandler.keys[2] || Config.allowVanillaControls && key == mc.gameSettings.keyBindAttack;
        }
        return key == mc.gameSettings.keyBindForward || key == ZSSKeyHandler.keys[3] || key == ZSSKeyHandler.keys[4] || Config.allowVanillaControls && (key == mc.gameSettings.keyBindLeft || key == mc.gameSettings.keyBindRight);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (this.canExecute(player)) {
            if (this.keyPressed != null && this.keyPressed.getIsKeyPressed() && key == mc.gameSettings.keyBindForward) {
                if (this.ticksTilFail > 0) {
                    PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
                    this.ticksTilFail = 0;
                    return true;
                }
                this.ticksTilFail = 6;
            } else if (key != mc.gameSettings.keyBindForward) {
                this.keyPressed = key;
            }
        } else if (this.isActive() && (key == mc.gameSettings.keyBindAttack || key == ZSSKeyHandler.keys[2])) {
            ZSSClientEvents.performComboAttack(mc, ZSSPlayerSkills.get(player).getTargetingSkill());
        }
        return false;
    }

    @Override
    public boolean onActivated(World world, EntityPlayer player) {
        this.dodgeTimer = this.getActiveTime();
        this.targetingSkill = ZSSPlayerSkills.get(player).getActiveSkill(swordBasic);
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.dodgeTimer = 0;
        this.targetingSkill = null;
        if (world.isRemote) {
            this.keyPressed = null;
        }
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isActive()) {
            --this.dodgeTimer;
        } else if (player.worldObj.isRemote && this.ticksTilFail > 0 && --this.ticksTilFail == 0) {
            this.keyPressed = null;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isAnimating() {
        return this.dodgeTimer > this.level;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onRenderTick(EntityPlayer player, float partialTickTime) {
        if (player.onGround) {
            double speed;
            if (this.targetingSkill != null && this.targetingSkill.isActive()) {
                this.targetingSkill.onRenderTick(player, partialTickTime);
            }
            if ((speed = 1.0 + 10.0 * (player.getAttributeMap().getAttributeInstance(SharedMonsterAttributes.movementSpeed).getAttributeValue() - (double)0.1f)) > 1.0) {
                speed = 1.0;
            }
            double d = 0.15 * speed * speed;
            if (player.isInWater() || player.handleLavaMovement()) {
                d *= 0.15;
            }
            Vec3 vec3 = player.getLookVec();
            if (this.keyPressed == ZSSKeyHandler.keys[4] || this.keyPressed == Minecraft.getMinecraft().gameSettings.keyBindRight) {
                player.addVelocity(-vec3.zCoord * d, 0.0, vec3.xCoord * d);
            } else {
                player.addVelocity(vec3.zCoord * d, 0.0, -vec3.xCoord * d);
            }
            player.addVelocity(vec3.xCoord * d * 1.15, 0.0, vec3.zCoord * d * 1.15);
        }
        return false;
    }

    @Override
    public boolean onBeingAttacked(EntityPlayer player, DamageSource source) {
        ILockOnTarget targeting = ZSSPlayerSkills.get(player).getTargetingSkill();
        return this.dodgeTimer > this.getDodgeTime() && targeting != null && targeting.getCurrentTarget() == source.getEntity();
    }

    @Override
    public float postImpact(EntityPlayer player, EntityLivingBase entity, float amount) {
        ILockOnTarget targeting;
        if (this.isActive() && this.dodgeTimer <= this.getActiveTime() - 5 && (targeting = ZSSPlayerSkills.get(player).getTargetingSkill()) != null && targeting.getCurrentTarget() == entity && !TargetUtils.isTargetInFrontOf((Entity)entity, (Entity)player, this.getAttackAngle())) {
            ItemStack armor;
            boolean flag = false;
            boolean isIBackEntity = entity instanceof IEntityBackslice;
            if (isIBackEntity) {
                flag = ((IEntityBackslice)entity).allowDamageMultiplier(player);
            } else if (!BackSlice.isEntityImmune(entity)) {
                flag = true;
            }
            if (flag) {
                amount *= 1.0f + (float)this.level * 0.1f;
                WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:mortaldraw", 0.4f, 0.5f);
            }
            if (isIBackEntity) {
                amount = ((IEntityBackslice)entity).onBackSliced(player, this.level, amount);
            }
            boolean bl = flag = flag && (Config.canDisarmorPlayers() || !(entity instanceof EntityPlayer));
            if (flag && (!isIBackEntity || ((IEntityBackslice)entity).allowDisarmorment(player, amount)) && (armor = entity.getEquipmentInSlot(3)) != null && player.worldObj.rand.nextFloat() < BackSlice.getDisarmorChance(armor, player.getHeldItem(), this.level)) {
                WorldUtils.spawnItemWithRandom(entity.worldObj, armor, entity.posX, entity.posY, entity.posZ);
                entity.setCurrentItemOrArmor(3, null);
            }
        }
        this.deactivate(player);
        return amount;
    }

    private static boolean isEntityImmune(EntityLivingBase entity) {
        for (Class<? extends EntityLivingBase> clazz : immuneEntities) {
            if (!clazz.isAssignableFrom(entity.getClass())) continue;
            return true;
        }
        return false;
    }

    private static void init() {
        if (immuneEntities == null) {
            immuneEntities = new HashSet<Class<? extends EntityLivingBase>>();
            immuneEntities.add(EntityBlaze.class);
            immuneEntities.add(EntityChu.class);
            immuneEntities.add(EntitySnowman.class);
            immuneEntities.add(EntitySlime.class);
        }
    }
}

