/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.api.item.IDashItem;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.ActivateSkillPacket;
import zeldaswordskills.network.server.DashImpactPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.ILockOnTarget;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;
import zeldaswordskills.util.WorldUtils;

public class Dash
extends SkillActive {
    public static final double BASE_MOVE = (double)0.1f;
    private boolean isActive = false;
    private double distance;
    @SideOnly(value=Side.CLIENT)
    private Vec3 trajectory;
    private Vec3 initialPosition;
    private Entity target;
    private int impactTime;

    public Dash(String name) {
        super(name);
    }

    private Dash(Dash skill) {
        super(skill);
    }

    @Override
    public Dash newInstance() {
        return new Dash(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getDamageDisplay(this.getDamage(), false));
        desc.add(StatCollector.translateToLocalFormatted((String)this.getInfoString("info", 1), (Object[])new Object[]{2 + this.level}));
        desc.add(this.getRangeDisplay(this.getRange()));
        desc.add(StatCollector.translateToLocalFormatted((String)this.getInfoString("info", 2), (Object[])new Object[]{String.format("%.1f", this.getMinDistance())}));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.isActive || this.impactTime > 0;
    }

    @Override
    protected float getExhaustion() {
        return 1.0f - 0.05f * (float)this.level;
    }

    private int getDamage() {
        return 2 + this.level;
    }

    private double getRange() {
        return 3.0 + (double)this.level;
    }

    private double getMinDistance() {
        return 2.0 - 0.2 * (double)this.level;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        ItemStack stack = player.getHeldItem() != null ? player.getHeldItem() : null;
        return super.canUse(player) && !this.isActive() && (PlayerUtils.isWeapon(stack) || stack.getItem() instanceof IDashItem);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return player.onGround && PlayerUtils.isBlocking(player) && this.canUse(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return key == ZSSKeyHandler.keys[2] || Config.allowVanillaControls && key == mc.gameSettings.keyBindAttack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (this.canExecute(player)) {
            PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
            return true;
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.isActive = true;
        this.initialPosition = Vec3.createVectorHelper((double)player.posX, (double)(player.posY + (double)player.getEyeHeight() - (double)0.1f), (double)player.posZ);
        ILockOnTarget skill = ZSSPlayerSkills.get(player).getTargetingSkill();
        this.target = skill != null && skill.isLockedOn() ? skill.getCurrentTarget() : TargetUtils.acquireLookTarget((EntityLivingBase)player, (int)this.getRange(), this.getRange(), true);
        if (this.target != null && world.isRemote) {
            double d0 = this.target.posX - player.posX;
            double d1 = this.target.posY + (double)(this.target.height / 3.0f) - player.posY;
            double d2 = this.target.posZ - player.posZ;
            this.trajectory = Vec3.createVectorHelper((double)d0, (double)d1, (double)d2).normalize();
        }
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.impactTime = 0;
        this.setNotDashing();
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.impactTime > 0) {
            --this.impactTime;
            if (this.impactTime == 0) {
                this.target = null;
            }
        }
        if (this.isActive) {
            MovingObjectPosition mop;
            if (player.worldObj.isRemote && (mop = TargetUtils.checkForImpact(player.worldObj, (Entity)player, (Entity)player, 0.5, false)) != null) {
                PacketDispatcher.sendToServer(new DashImpactPacket(player, mop));
                player.attackTime = player.capabilities.isCreativeMode ? 0 : 10 - this.level;
                this.impactTime = 5;
                if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY) {
                    this.target = mop.entityHit;
                }
                double d = Math.sqrt(player.motionX * player.motionX + player.motionZ * player.motionZ);
                player.setVelocity(-player.motionX * d, 0.15 * d, -player.motionZ * d);
                this.trajectory = null;
                this.setNotDashing();
            }
            this.distance += 1.0;
            if (this.distance > this.getRange() + 1.0 || !(this.target instanceof EntityLivingBase)) {
                this.setNotDashing();
            }
        }
    }

    public void onImpact(World world, EntityPlayer player, MovingObjectPosition mop) {
        if (mop != null && mop.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY) {
            this.target = mop.entityHit;
            double dist = this.target.getDistance(this.initialPosition.xCoord, this.initialPosition.yCoord, this.initialPosition.zCoord);
            dist -= (double)(this.target.width / 2.0f + player.width / 2.0f);
            double speed = player.getAttributeMap().getAttributeInstance(SharedMonsterAttributes.movementSpeed).getAttributeValue();
            double sf = 1.0 + (speed - (double)0.1f);
            if (speed > 0.075 && dist > this.getMinDistance() && player.getDistanceSqToEntity(this.target) < 6.0) {
                float dmg = (float)this.getDamage() + (float)(dist / 2.0 - 2.0);
                this.impactTime = 5;
                this.target.attackEntityFrom(DamageUtils.causeNonSwordDamage((Entity)player), (float)((double)dmg * sf * sf));
                double resist = 1.0;
                if (this.target instanceof EntityLivingBase) {
                    resist -= ((EntityLivingBase)this.target).getEntityAttribute(SharedMonsterAttributes.knockbackResistance).getAttributeValue();
                }
                double k = sf * resist * (this.distance / 3.0) * (double)0.6f;
                this.target.addVelocity(player.motionX * k * (0.2 + 0.1 * (double)this.level), 0.1 + k * ((double)this.level * 0.025), player.motionZ * k * (0.2 + 0.1 * (double)this.level));
                if (this.target instanceof EntityPlayerMP && !player.worldObj.isRemote) {
                    ((EntityPlayerMP)this.target).playerNetServerHandler.sendPacket((Packet)new S12PacketEntityVelocity(this.target));
                }
            }
        }
        WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:slam", 0.4f, 0.5f);
        this.setNotDashing();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isAnimating() {
        return this.isActive;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onRenderTick(EntityPlayer player, float partialTickTime) {
        if (this.target instanceof EntityLivingBase && this.trajectory != null) {
            double speed = player.getAttributeMap().getAttributeInstance(SharedMonsterAttributes.movementSpeed).getAttributeValue() - (double)0.1f;
            double dfactor = 1.0 + speed + speed * (1.0 - (this.getRange() - this.distance) / this.getRange());
            player.motionX = this.trajectory.xCoord * dfactor * dfactor;
            player.motionZ = this.trajectory.zCoord * dfactor * dfactor;
        }
        return false;
    }

    @Override
    public boolean onBeingAttacked(EntityPlayer player, DamageSource source) {
        if (this.impactTime > 0 && source.getEntity() == this.target) {
            return true;
        }
        return source.damageType.equals("mob") && source.getEntity() != null && player.getDistanceSqToEntity(source.getEntity()) < 6.0;
    }

    private void setNotDashing() {
        this.isActive = false;
        this.distance = 0.0;
        this.initialPosition = null;
        if (!this.isActive()) {
            this.target = null;
        }
    }
}

