/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.entity.projectile.EntitySwordBeam;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.ActivateSkillPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.ICombo;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

public class SwordBeam
extends SkillActive {
    private int missTimer;

    public SwordBeam(String name) {
        super(name);
    }

    private SwordBeam(SwordBeam skill) {
        super(skill);
    }

    @Override
    public SwordBeam newInstance() {
        return new SwordBeam(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getDamageDisplay(this.getDamageFactor(player), false) + "%");
        desc.add(this.getRangeDisplay(12 + this.level));
        desc.add(StatCollector.translateToLocalFormatted((String)this.getInfoString("info", 1), (Object[])new Object[]{String.format("%.1f", Float.valueOf(Config.getHealthAllowance(this.level) / 2.0f))}));
        desc.add(StatCollector.translateToLocalFormatted((String)this.getInfoString("info", 2), (Object[])new Object[]{String.format("%.2f", Float.valueOf(this.getMagicCost()))}));
    }

    @Override
    public boolean isActive() {
        return this.missTimer > 0;
    }

    @Override
    public boolean hasAnimation() {
        return false;
    }

    @Override
    protected float getExhaustion() {
        return 0.0f;
    }

    private float getMagicCost() {
        return 10.0f;
    }

    private boolean checkHealth(EntityPlayer player) {
        return PlayerUtils.getHealthMissing(player) <= Config.getHealthAllowance(this.level);
    }

    private int getDamageFactor(EntityPlayer player) {
        ItemStack mask = player.getEquipmentInSlot(4);
        int base = mask != null && mask.getItem() == ZSSItems.maskFierce ? 55 : 30;
        return base + this.level * 10;
    }

    private float getDamage(EntityPlayer player) {
        return (float)((double)this.getDamageFactor(player) * 0.01 * player.getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue());
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        ZSSPlayerInfo info = ZSSPlayerInfo.get(player);
        if (super.canUse(player) && !this.isActive() && info.canUseMagic() && PlayerUtils.isSword(player.getHeldItem())) {
            return player.capabilities.isCreativeMode || player.attackTime == 0 && info.getCurrentMagic() >= this.getMagicCost() && this.checkHealth(player);
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return player.onGround && player.isSneaking() && this.canUse(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return key == ZSSKeyHandler.keys[2] || Config.allowVanillaControls && key == mc.gameSettings.keyBindAttack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (this.canExecute(player)) {
            PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
            return true;
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        player.swingItem();
        if (!world.isRemote) {
            if (!ZSSPlayerInfo.get(player).useMagic(this.getMagicCost())) {
                return false;
            }
            this.missTimer = 12 + this.level;
            WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:whoosh", 0.4f, 0.5f);
            Vec3 vec3 = player.getLookVec();
            EntitySwordBeam beam = new EntitySwordBeam(world, (EntityLivingBase)player).setLevel(this.level);
            beam.setDamage(this.getDamage(player));
            beam.setMasterSword(PlayerUtils.isHoldingMasterSword((EntityLivingBase)player));
            beam.setPosition(beam.posX + vec3.xCoord * 2.0, beam.posY + vec3.yCoord * 2.0, beam.posZ + vec3.zCoord * 2.0);
            world.spawnEntityInWorld((Entity)beam);
        }
        return true;
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.missTimer = 0;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.missTimer > 0) {
            ICombo combo;
            --this.missTimer;
            if (this.missTimer == 0 && !player.worldObj.isRemote && (combo = ZSSPlayerSkills.get(player).getComboSkill()) != null && combo.isComboInProgress()) {
                combo.getCombo().endCombo(player);
            }
        }
    }

    public void onImpact(EntityPlayer player, boolean hitBlock) {
        this.missTimer = hitBlock && this.missTimer > 0 ? 1 : 0;
    }
}

