/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.songs;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldInfo;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.PlaySoundPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.SongNote;

public class ZeldaSongStorms
extends AbstractZeldaSong {
    private static long nextChange;

    public ZeldaSongStorms(String unlocalizedName, int minDuration, SongNote ... notes) {
        super(unlocalizedName, minDuration, notes);
    }

    @Override
    protected boolean hasEffect(EntityPlayer player, ItemStack instrument, int power) {
        return power > 4;
    }

    @Override
    protected void performEffect(EntityPlayer player, ItemStack instrument, int power) {
        if (!(player.worldObj instanceof WorldServer)) {
            return;
        }
        if (!player.capabilities.isCreativeMode && player.worldObj.getTotalWorldTime() < nextChange) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.song.cooldown", new ChatComponentTranslation(this.getTranslationString(), new Object[0]), Config.getMinIntervalStorm());
            return;
        }
        nextChange = player.worldObj.getTotalWorldTime() + (long)Config.getMinIntervalStorm();
        PacketDispatcher.sendTo(new PlaySoundPacket("zeldaswordskills:success", 1.0f, 1.0f), (EntityPlayerMP)player);
        WorldInfo worldinfo = ((WorldServer)player.worldObj).getWorldInfo();
        if (worldinfo.isRaining()) {
            worldinfo.setRainTime(0);
            worldinfo.setRaining(false);
        } else {
            worldinfo.setRainTime(2000);
            worldinfo.setRaining(true);
        }
        if (worldinfo.isThundering()) {
            worldinfo.setThunderTime(0);
            worldinfo.setThundering(false);
        } else {
            worldinfo.setThunderTime(2000);
            worldinfo.setThundering(true);
        }
    }
}

