/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.songs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.songs.ZeldaSongEpona;
import zeldaswordskills.songs.ZeldaSongHealing;
import zeldaswordskills.songs.ZeldaSongNoEffect;
import zeldaswordskills.songs.ZeldaSongScarecrow;
import zeldaswordskills.songs.ZeldaSongSoaring;
import zeldaswordskills.songs.ZeldaSongStorms;
import zeldaswordskills.songs.ZeldaSongSun;
import zeldaswordskills.songs.ZeldaSongWarp;
import zeldaswordskills.util.SongNote;

public final class ZeldaSongs {
    private static final List<String> songNames = new ArrayList<String>();
    private static final Map<String, AbstractZeldaSong> songMap = new HashMap<String, AbstractZeldaSong>();
    public static final AbstractZeldaSong songEpona = new ZeldaSongEpona("epona", 90, SongNote.D2, SongNote.B2, SongNote.A2, SongNote.D2, SongNote.B2, SongNote.A2);
    public static final AbstractZeldaSong songHealing = new ZeldaSongHealing("healing", 78, SongNote.B2, SongNote.A2, SongNote.F1, SongNote.B2, SongNote.A2, SongNote.F1);
    public static final AbstractZeldaSong songSaria = new ZeldaSongNoEffect("saria", 71, SongNote.F1, SongNote.A2, SongNote.B2, SongNote.F1, SongNote.A2, SongNote.B2);
    public static final AbstractZeldaSong songSoaring = new ZeldaSongSoaring("soaring", 120, SongNote.F1, SongNote.B2, SongNote.D2, SongNote.F1, SongNote.B2, SongNote.D2);
    public static final AbstractZeldaSong songStorms = new ZeldaSongStorms("storms", 85, SongNote.D1, SongNote.F1, SongNote.D2, SongNote.D1, SongNote.F1, SongNote.D2);
    public static final AbstractZeldaSong songSun = new ZeldaSongSun("sun", 100, SongNote.A2, SongNote.F1, SongNote.D2, SongNote.A2, SongNote.F1, SongNote.D2);
    public static final AbstractZeldaSong songTime = new ZeldaSongNoEffect("time", 90, SongNote.A2, SongNote.D1, SongNote.F1, SongNote.A2, SongNote.D1, SongNote.F1);
    public static final AbstractZeldaSong songWarpFire = new ZeldaSongWarp("bolero", 60, SongNote.F1, SongNote.D1, SongNote.F1, SongNote.D1, SongNote.A2, SongNote.F1, SongNote.A2, SongNote.F1);
    public static final AbstractZeldaSong songWarpForest = new ZeldaSongWarp("minuet", 90, SongNote.D1, SongNote.D2, SongNote.B2, SongNote.A2, SongNote.B2, SongNote.A2);
    public static final AbstractZeldaSong songWarpLight = new ZeldaSongWarp("prelude", 92, SongNote.D2, SongNote.A2, SongNote.D2, SongNote.A2, SongNote.B2, SongNote.D2);
    public static final AbstractZeldaSong songWarpOrder = new ZeldaSongWarp("oath", 110, SongNote.A2, SongNote.F1, SongNote.D1, SongNote.F1, SongNote.A2, SongNote.D2);
    public static final AbstractZeldaSong songWarpShadow = new ZeldaSongWarp("nocturne", 116, SongNote.B2, SongNote.A2, SongNote.A2, SongNote.D1, SongNote.B2, SongNote.A2, SongNote.F1);
    public static final AbstractZeldaSong songWarpSpirit = new ZeldaSongWarp("requiem", 125, SongNote.D1, SongNote.F1, SongNote.D1, SongNote.A2, SongNote.F1, SongNote.D1);
    public static final AbstractZeldaSong songWarpWater = new ZeldaSongWarp("serenade", 83, SongNote.D1, SongNote.F1, SongNote.A2, SongNote.A2, SongNote.B2);
    public static final AbstractZeldaSong songZeldasLullaby = new ZeldaSongNoEffect("lullaby", 129, SongNote.B2, SongNote.D2, SongNote.A2, SongNote.B2, SongNote.D2, SongNote.A2);
    public static final AbstractZeldaSong songScarecrow = new ZeldaSongScarecrow();

    private ZeldaSongs() {
    }

    public static final List<String> getRegisteredNames() {
        return Collections.unmodifiableList(songNames);
    }

    public static final Collection<AbstractZeldaSong> getRegisteredSongs() {
        return Collections.unmodifiableCollection(songMap.values());
    }

    public static final int getTotalSongs() {
        return songNames.size();
    }

    public static final AbstractZeldaSong getSongByName(String name) {
        return songMap.get(name);
    }

    public static final AbstractZeldaSong getSongFromNotes(List<SongNote> notesPlayed) {
        for (AbstractZeldaSong song : ZeldaSongs.getRegisteredSongs()) {
            if (!song.areCorrectNotes(notesPlayed)) continue;
            return song;
        }
        return null;
    }

    public static final boolean areNotesUnique(List<SongNote> notesPlayed) {
        for (AbstractZeldaSong song : ZeldaSongs.getRegisteredSongs()) {
            if (!song.isSongPartOfNotes(notesPlayed)) continue;
            return false;
        }
        return true;
    }

    public static void register(AbstractZeldaSong song) {
        if (songNames.contains(song.getUnlocalizedName()) || songMap.containsKey(song.getUnlocalizedName())) {
            ZSSMain.logger.warn(String.format("Failed to register %s: Unlocalized name must be unique.", song.getUnlocalizedName()));
        } else if (!ZeldaSongs.areNotesUnique(song.getNotes())) {
            ZSSMain.logger.warn(String.format("Failed to register %s: Notes provided are not unique %s", song.getUnlocalizedName(), song.getNotes()));
        } else {
            songNames.add(song.getUnlocalizedName());
            songMap.put(song.getUnlocalizedName(), song);
            ZSSMain.logger.info(String.format("Registered %s as '%s' with notes %s", song.getDisplayName(), song.getUnlocalizedName(), song.getNotes()));
        }
    }
}

