/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.StatCollector;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.config.Configuration;
import zeldaswordskills.ZSSMain;

public enum BiomeType {
    ARID("arid", "Desert", "Desert Hills", "Savanna", "Savanna Plateau"),
    BEACH("beach", "Beach"),
    COLD("cold", "Cold Beach", "Cold Taiga", "Cold Taiga Hills", "Frozen River", "Ice Mountains", "Ice Plains"),
    FIERY("fiery", "Hell", "Mesa", "Mesa Plateau", "Mesa Plateau F"),
    FOREST("forest", "Birch Forest", "Birch Forest Hills", "Forest", "Forest Hills", "Roofed Forest"),
    JUNGLE("jungle", "Jungle", "Jungle Edge", "Jungle Hills"),
    MOUNTAIN("mountain", "Extreme Hills", "Extreme Hills+", "Extreme Hills Edge"),
    OCEAN("ocean", "Ocean", "Frozen Ocean", "Deep Ocean"),
    PLAINS("plains", "Plains"),
    RIVER("river", "River", "Swampland"),
    SHROOM("shroom", "MushroomIsland", "MushroomIslandShore"),
    TAIGA("taiga", "Taiga", "Taiga Hills", "Mega Taiga", "Mega Taiga Hills");

    private final String unlocalizedName;
    public final String[] defaultBiomes;
    private static final Map<String, BiomeType> biomeTypeList;

    private BiomeType(String name, String ... defaultBiomes) {
        this.unlocalizedName = name;
        this.defaultBiomes = defaultBiomes;
    }

    public String toString() {
        return StatCollector.translateToLocal((String)("biometype." + this.unlocalizedName + ".name"));
    }

    public static void postInit(Configuration config) {
        for (BiomeType type : BiomeType.values()) {
            BiomeType.addBiomes(type, config.get("Mob Spawns", String.format("[Biome Types] List of %s type biomes - certain mobs spawn differently depending on the biome type", type.toString()), type.defaultBiomes).getStringList());
        }
    }

    private static void addBiomes(BiomeType type, String[] biomeNames) {
        for (String biome : biomeNames) {
            if (biome.length() < 1) continue;
            if (!BiomeType.isRealBiome(biome = biome.toLowerCase().replace(" ", ""))) {
                ZSSMain.logger.warn(String.format("%s is not a recognized biome! This entry will be ignored for BiomeType %s", biome, type.toString()));
                continue;
            }
            if (biomeTypeList.containsKey(biome)) {
                ZSSMain.logger.warn(String.format("Error while adding %s for %s: biome already mapped to %s", biome, type.toString(), biomeTypeList.get(biome).toString()));
                continue;
            }
            biomeTypeList.put(biome, type);
        }
    }

    public static BiomeType getBiomeTypeFor(BiomeGenBase biome) {
        if (biome != null && biome.biomeName != null && biome.biomeName.length() > 0) {
            return biomeTypeList.get(biome.biomeName.toLowerCase().replace(" ", ""));
        }
        return null;
    }

    public static boolean isRealBiome(String name) {
        for (BiomeGenBase biome : BiomeGenBase.getBiomeGenArray()) {
            if (biome == null || biome.biomeName == null || !biome.biomeName.toLowerCase().replace(" ", "").equals(name)) continue;
            return true;
        }
        return false;
    }

    public static String[] getBiomeArray(String[] ignore, BiomeType ... types) {
        ArrayList<String> combined = new ArrayList<String>();
        for (BiomeType biomes : types) {
            for (String biome : biomes.defaultBiomes) {
                if (ignore != null && Arrays.binarySearch(ignore, biome, String.CASE_INSENSITIVE_ORDER) >= 0) continue;
                combined.add(biome);
            }
        }
        return combined.toArray(new String[combined.size()]);
    }

    static {
        biomeTypeList = new HashMap<String, BiomeType>();
    }
}

