/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import zeldaswordskills.ZSSMain;

public class BlockRotationData {
    private static final Map<Block, Rotation> blockRotationData = new HashMap<Block, Rotation>();

    public static final Rotation getBlockRotationType(Block block) {
        return blockRotationData.get(block);
    }

    public static final boolean registerCustomBlockRotation(Block block, Rotation rotationType) {
        return BlockRotationData.registerCustomBlockRotation(block, rotationType, false);
    }

    public static final boolean registerCustomBlockRotation(Block block, Rotation rotationType, boolean override) {
        if (blockRotationData.containsKey(block)) {
            ZSSMain.logger.warn("Block " + block + " already has a rotation type." + (override ? " Overriding previous data." : ""));
            if (override) {
                blockRotationData.remove(block);
            } else {
                return false;
            }
        }
        blockRotationData.put(block, rotationType);
        return true;
    }

    static {
        blockRotationData.put(Blocks.anvil, Rotation.ANVIL);
        blockRotationData.put(Blocks.iron_door, Rotation.DOOR);
        blockRotationData.put(Blocks.wooden_door, Rotation.DOOR);
        blockRotationData.put(Blocks.bed, Rotation.GENERIC);
        blockRotationData.put(Blocks.cocoa, Rotation.GENERIC);
        blockRotationData.put(Blocks.fence_gate, Rotation.GENERIC);
        blockRotationData.put(Blocks.pumpkin, Rotation.GENERIC);
        blockRotationData.put(Blocks.lit_pumpkin, Rotation.GENERIC);
        blockRotationData.put(Blocks.end_portal_frame, Rotation.GENERIC);
        blockRotationData.put((Block)Blocks.tripwire_hook, Rotation.GENERIC);
        blockRotationData.put((Block)Blocks.chest, Rotation.PISTON_CONTAINER);
        blockRotationData.put(Blocks.trapped_chest, Rotation.PISTON_CONTAINER);
        blockRotationData.put(Blocks.dispenser, Rotation.PISTON_CONTAINER);
        blockRotationData.put(Blocks.dropper, Rotation.PISTON_CONTAINER);
        blockRotationData.put(Blocks.ender_chest, Rotation.PISTON_CONTAINER);
        blockRotationData.put(Blocks.lit_furnace, Rotation.PISTON_CONTAINER);
        blockRotationData.put(Blocks.furnace, Rotation.PISTON_CONTAINER);
        blockRotationData.put((Block)Blocks.hopper, Rotation.PISTON_CONTAINER);
        blockRotationData.put(Blocks.ladder, Rotation.PISTON_CONTAINER);
        blockRotationData.put(Blocks.wall_sign, Rotation.PISTON_CONTAINER);
        blockRotationData.put((Block)Blocks.piston, Rotation.PISTON_CONTAINER);
        blockRotationData.put((Block)Blocks.piston_extension, Rotation.PISTON_CONTAINER);
        blockRotationData.put((Block)Blocks.piston_head, Rotation.PISTON_CONTAINER);
        blockRotationData.put((Block)Blocks.sticky_piston, Rotation.PISTON_CONTAINER);
        blockRotationData.put(Blocks.activator_rail, Rotation.PISTON_CONTAINER);
        blockRotationData.put(Blocks.detector_rail, Rotation.PISTON_CONTAINER);
        blockRotationData.put(Blocks.golden_rail, Rotation.PISTON_CONTAINER);
        blockRotationData.put(Blocks.quartz_block, Rotation.QUARTZ);
        blockRotationData.put(Blocks.rail, Rotation.RAIL);
        blockRotationData.put((Block)Blocks.powered_comparator, Rotation.REPEATER);
        blockRotationData.put((Block)Blocks.unpowered_comparator, Rotation.REPEATER);
        blockRotationData.put((Block)Blocks.powered_repeater, Rotation.REPEATER);
        blockRotationData.put((Block)Blocks.unpowered_repeater, Rotation.REPEATER);
        blockRotationData.put(Blocks.standing_sign, Rotation.SIGNPOST);
        blockRotationData.put(Blocks.skull, Rotation.SKULL);
        blockRotationData.put(Blocks.brick_stairs, Rotation.STAIRS);
        blockRotationData.put(Blocks.nether_brick_stairs, Rotation.STAIRS);
        blockRotationData.put(Blocks.quartz_stairs, Rotation.STAIRS);
        blockRotationData.put(Blocks.sandstone_stairs, Rotation.STAIRS);
        blockRotationData.put(Blocks.stone_stairs, Rotation.STAIRS);
        blockRotationData.put(Blocks.stone_brick_stairs, Rotation.STAIRS);
        blockRotationData.put(Blocks.acacia_stairs, Rotation.STAIRS);
        blockRotationData.put(Blocks.birch_stairs, Rotation.STAIRS);
        blockRotationData.put(Blocks.dark_oak_stairs, Rotation.STAIRS);
        blockRotationData.put(Blocks.jungle_stairs, Rotation.STAIRS);
        blockRotationData.put(Blocks.oak_stairs, Rotation.STAIRS);
        blockRotationData.put(Blocks.spruce_stairs, Rotation.STAIRS);
        blockRotationData.put(Blocks.trapdoor, Rotation.TRAPDOOR);
        blockRotationData.put(Blocks.vine, Rotation.VINE);
        blockRotationData.put(Blocks.lever, Rotation.LEVER);
        blockRotationData.put(Blocks.stone_button, Rotation.WALL_MOUNTED);
        blockRotationData.put(Blocks.wooden_button, Rotation.WALL_MOUNTED);
        blockRotationData.put(Blocks.redstone_torch, Rotation.WALL_MOUNTED);
        blockRotationData.put(Blocks.unlit_redstone_torch, Rotation.WALL_MOUNTED);
        blockRotationData.put(Blocks.torch, Rotation.WALL_MOUNTED);
        blockRotationData.put(Blocks.log, Rotation.WOOD);
        blockRotationData.put(Blocks.log2, Rotation.WOOD);
    }

    public static enum Rotation {
        ANVIL,
        DOOR,
        GENERIC,
        PISTON_CONTAINER,
        QUARTZ,
        RAIL,
        REPEATER,
        SIGNPOST,
        SKULL,
        STAIRS,
        TRAPDOOR,
        VINE,
        WALL_MOUNTED,
        LEVER,
        WOOD;

    }
}

