/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.util;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import zeldaswordskills.block.BlockChestLocked;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.BlockRotationData;
import zeldaswordskills.world.gen.structure.RoomBase;

public class StructureGenUtils {
    public static final int SOUTH = 0;
    public static final int WEST = 1;
    public static final int NORTH = 2;
    public static final int EAST = 3;

    public static int getAverageSurfaceHeight(World world, int posX, int posZ) {
        int height = world.getHeightValue(posX, posZ);
        int count = 1;
        for (int i = posX + 3; i < posX + 16; i += 3) {
            for (int j = posZ + 3; j < posZ + 16; j += 3) {
                height += world.getHeightValue(i, j);
                ++count;
            }
        }
        return height / count;
    }

    public static double getDistanceSqBetween(StructureBoundingBox box1, StructureBoundingBox box2) {
        int dx = box1.getCenterX() - box2.getCenterX();
        int dy = box1.getCenterY() - box2.getCenterY();
        int dz = box1.getCenterZ() - box2.getCenterZ();
        return dx * dx + dy * dy + dz * dz;
    }

    public static int getAverageDistanceToGround(World world, StructureBoundingBox box, int max) {
        int i;
        int total = i = StructureGenUtils.getDistanceToGround(world, box.getCenterX(), box.minY, box.getCenterZ());
        if (i > max) {
            return max;
        }
        i = StructureGenUtils.getDistanceToGround(world, box.minX, box.minY, box.minZ);
        total += i;
        if (i > max) {
            return max;
        }
        i = StructureGenUtils.getDistanceToGround(world, box.minX, box.minY, box.maxZ);
        total += i;
        if (i > max) {
            return max;
        }
        i = StructureGenUtils.getDistanceToGround(world, box.maxX, box.minY, box.minZ);
        total += i;
        if (i > max) {
            return max;
        }
        i = StructureGenUtils.getDistanceToGround(world, box.maxX, box.minY, box.maxZ);
        total += i;
        if (i > max) {
            return max;
        }
        return total / 5;
    }

    public static int getDistanceToGround(World world, int x, int y, int z) {
        int i = 0;
        while (!world.getBlock(x, y - 1, z).getMaterial().isSolid() && y > 5) {
            --y;
            ++i;
        }
        return i;
    }

    public static void fillWithBlocks(World world, StructureBoundingBox box, int minX, int maxX, int minY, int maxY, int minZ, int maxZ, Block block, int meta) {
        StructureGenUtils.fillWithBlocks(world, box, minX, maxX, minY, maxY, minZ, maxZ, block, meta, false);
    }

    public static void fillWithBlocks(World world, StructureBoundingBox box, int minX, int maxX, int minY, int maxY, int minZ, int maxZ, Block block, int meta, boolean ignoreBounds) {
        for (int i = minX; i < maxX; ++i) {
            for (int j = minY; j < maxY; ++j) {
                for (int k = minZ; k < maxZ; ++k) {
                    StructureGenUtils.setBlockAtPosition(world, box, i, j, k, block, meta, ignoreBounds);
                }
            }
        }
    }

    public static void fillWithoutReplace(World world, int minX, int maxX, int minY, int maxY, int minZ, int maxZ, Block block, int meta, int flag) {
        for (int i = minX; i < maxX; ++i) {
            for (int j = minY; j < maxY; ++j) {
                for (int k = minZ; k < maxZ; ++k) {
                    if (world.getBlock(i, j, k).getMaterial().isSolid()) continue;
                    world.setBlock(i, j, k, block, meta, flag);
                }
            }
        }
    }

    public static void fillDown(World world, StructureBoundingBox box, Block block, int metadata) {
        for (int i = box.minX; i <= box.maxX; ++i) {
            for (int k = box.minZ; k <= box.maxZ; ++k) {
                for (int j = box.minY - 1; !(j <= 4 || world.getBlock(i, j, k).getMaterial().isSolid() && world.getBlock(i, j, k).getMaterial() != Material.leaves); --j) {
                    world.setBlock(i, j, k, block, metadata, 2);
                }
            }
        }
    }

    public static void destroyBlocksAround(World world, int minX, int maxX, int minY, int maxY, int minZ, int maxZ, Block block, boolean drop) {
        for (int i = minX; i < maxX; ++i) {
            for (int j = minY; j < maxY; ++j) {
                for (int k = minZ; k < maxZ; ++k) {
                    if (block != null && world.getBlock(i, j, k) != block) continue;
                    world.func_147480_a(i, j, k, drop);
                }
            }
        }
    }

    public static int getXWithOffset(StructureBoundingBox box, int x, int z) {
        return box.minX + x;
    }

    public static int getYWithOffset(StructureBoundingBox box, int y) {
        return box.minY + y;
    }

    public static int getZWithOffset(StructureBoundingBox box, int x, int z) {
        return box.minZ + z;
    }

    public static boolean isBlockChest(World world, int x, int y, int z) {
        Block block = world.getBlock(x, y, z);
        return block instanceof BlockChest || block instanceof BlockChestLocked;
    }

    public static void replaceMaterialWith(World world, int minX, int maxX, int minY, int maxY, int minZ, int maxZ, Material material, Block block, int meta) {
        for (int i = minX; i < maxX; ++i) {
            for (int j = minY; j < maxY; ++j) {
                for (int k = minZ; k < maxZ; ++k) {
                    if (world.getBlock(i, j, k).getMaterial() != material) continue;
                    world.setBlock(i, j, k, block, meta, 3);
                }
            }
        }
    }

    public static void setBlockAtPosition(World world, StructureBoundingBox box, int x, int y, int z, Block block, int meta) {
        StructureGenUtils.setBlockAtPosition(world, box, x, y, z, block, meta, false);
    }

    public static void setBlockAtPosition(World world, StructureBoundingBox box, int x, int y, int z, Block block, int meta, boolean ignoreBounds) {
        int j1 = StructureGenUtils.getXWithOffset(box, x, z);
        int k1 = StructureGenUtils.getYWithOffset(box, y);
        int l1 = StructureGenUtils.getZWithOffset(box, x, z);
        if (ignoreBounds || box.isVecInside(j1, k1, l1)) {
            world.setBlock(j1, k1, l1, block, meta, 2);
        }
    }

    public static void setBlockIfReplaceable(World world, int x, int y, int z, Block block, int meta) {
        if (world.getBlock(x, y, z).isReplaceable((IBlockAccess)world, x, y, z)) {
            world.setBlock(x, y, z, block, meta, 2);
        }
    }

    public static void adjustCornersForMaterial(World world, StructureBoundingBox box, Material material, int n, boolean checkAbove, boolean moveUp) {
        int count;
        int i;
        int n2 = i = moveUp ? 1 : -1;
        for (count = n; count > 0 && world.getBlock(box.maxX, checkAbove ? box.maxY + 1 : box.minY - 1, box.maxZ).getMaterial() == material; --count) {
            box.offset(0, i, 0);
        }
        while (count > 0 && world.getBlock(box.maxX, checkAbove ? box.maxY + 1 : box.minY - 1, box.minZ).getMaterial() == material) {
            --count;
            box.offset(0, i, 0);
        }
        while (count > 0 && world.getBlock(box.minX, checkAbove ? box.maxY + 1 : box.minY - 1, box.maxZ).getMaterial() == material) {
            --count;
            box.offset(0, i, 0);
        }
        while (count > 0 && world.getBlock(box.minX, checkAbove ? box.maxY + 1 : box.minY - 1, box.minZ).getMaterial() == material) {
            --count;
            box.offset(0, i, 0);
        }
    }

    public static void adjustForAir(World world, RoomBase room, StructureBoundingBox box) {
        int newCount;
        int maxShift;
        int i;
        int bottomCount;
        int difficulty;
        int worldHeight = room.inNether ? 128 : 160;
        int n = difficulty = room.inNether ? Config.getNetherDungeonDifficulty() : Config.getMainDungeonDifficulty();
        if (room.inOcean || difficulty == 1) {
            return;
        }
        int topCount = StructureGenUtils.getNumBlocksOfMaterial(world, box, Material.air, 1);
        if (topCount == (bottomCount = StructureGenUtils.getNumBlocksOfMaterial(world, box, Material.air, -1))) {
            return;
        }
        boolean shiftUp = bottomCount > topCount;
        int n2 = i = shiftUp ? 1 : -1;
        for (maxShift = box.getYSize(); maxShift > 0 && world.isAirBlock(box.getCenterX(), (shiftUp ? box.minY : box.maxY) - i, box.getCenterZ()) && box.maxY < worldHeight && box.minY > 8; --maxShift) {
            box.offset(0, i, 0);
        }
        if (maxShift > 0) {
            StructureGenUtils.adjustCornersForMaterial(world, box, Material.air, maxShift, !shiftUp, shiftUp);
        }
        if ((newCount = StructureGenUtils.getNumBlocksOfMaterial(world, box, Material.air, shiftUp ? -1 : 1)) == 0) {
            if (room.inNether && difficulty != 3 || world.rand.nextFloat() < 1.0f - 0.3f * (float)difficulty) {
                box.offset(0, shiftUp ? -1 : 1, 0);
            }
        } else if (newCount > (shiftUp ? bottomCount : topCount)) {
            box.offset(0, (shiftUp ? -1 : 1) * (box.getYSize() - maxShift), 0);
        }
    }

    public static boolean isAreaClear(World world, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        for (int i = minX; i <= maxX; ++i) {
            for (int j = minY; j <= maxY; ++j) {
                for (int k = minZ; k <= maxZ; ++k) {
                    if (world.isAirBlock(i, j, k)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static int getNumBlocksOfMaterial(World world, StructureBoundingBox box, Material material, int offY) {
        int count = 0;
        int y = offY > 0 ? box.maxY + offY : box.minY + offY;
        count += world.getBlock(box.getCenterX(), y, box.getCenterZ()).getMaterial() == material ? 1 : 0;
        count += world.getBlock(box.maxX, y, box.maxZ).getMaterial() == material ? 1 : 0;
        count += world.getBlock(box.maxX, y, box.minZ).getMaterial() == material ? 1 : 0;
        count += world.getBlock(box.minX, y, box.maxZ).getMaterial() == material ? 1 : 0;
        return count += world.getBlock(box.minX, y, box.minZ).getMaterial() == material ? 1 : 0;
    }

    public static int getNumBlocksOfMaterialInArea(World world, StructureBoundingBox box, Material material, int y) {
        if (y < 0) {
            return StructureGenUtils.getNumBlocksOfMaterialInArea(world, Material.air, box.minX, box.maxX + 1, box.minY + y - 1, box.minY + y, box.minZ, box.maxZ + 1);
        }
        return StructureGenUtils.getNumBlocksOfMaterialInArea(world, Material.air, box.minX, box.maxX + 1, box.maxY + y, box.maxY + y + 1, box.minZ, box.maxZ + 1);
    }

    public static int getNumBlocksOfMaterialInArea(World world, Material material, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        int count = 0;
        for (int i = minX; i < maxX; ++i) {
            for (int j = minY; j < maxY; ++j) {
                for (int k = minZ; k < maxZ; ++k) {
                    if (world.getBlock(i, j, k).getMaterial() != material) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public static int getOffsetX(int dx, int dz, int facing) {
        switch (facing) {
            case 3: {
                return dx;
            }
            case 2: {
                return dz;
            }
            case 1: {
                return -dx;
            }
            case 0: {
                return -dz;
            }
        }
        return dx;
    }

    public static int getOffsetZ(int dx, int dz, int facing) {
        switch (facing) {
            case 3: {
                return dz;
            }
            case 2: {
                return -dx;
            }
            case 1: {
                return -dz;
            }
            case 0: {
                return dx;
            }
        }
        return dz;
    }

    public static final int getMetadata(int facing, Block block, int origMeta) {
        if (BlockRotationData.getBlockRotationType(block) == null) {
            return origMeta;
        }
        int meta = origMeta;
        int tickDelay = meta >> 2;
        int bit4 = meta & 4;
        int bit8 = meta & 8;
        int bit9 = meta >> 3;
        int extra = meta & 0xFFFFFFFC;
        int rotations = Direction.rotateRight[facing];
        block17: for (int i = 0; i < rotations; ++i) {
            int bitface = meta % 4;
            switch (BlockRotationData.getBlockRotationType(block)) {
                case ANVIL: {
                    meta ^= 1;
                    continue block17;
                }
                case DOOR: {
                    if (bit8 != 0) {
                        return meta;
                    }
                    meta = bitface == 3 ? 0 : bitface + 1;
                    meta |= extra;
                    continue block17;
                }
                case GENERIC: {
                    meta = (bitface == 3 ? 0 : bitface + 1) | bit4 | bit8;
                    continue block17;
                }
                case PISTON_CONTAINER: {
                    if ((meta -= meta > 7 ? 8 : 0) > 1) {
                        meta = meta == 2 ? 5 : (meta == 5 ? 3 : (meta == 3 ? 4 : 2));
                    }
                    meta |= bit8 | bit9 << 3;
                    continue block17;
                }
                case QUARTZ: {
                    meta = meta == 3 ? 4 : (meta == 4 ? 3 : meta);
                    continue block17;
                }
                case RAIL: {
                    if (meta < 2) {
                        meta ^= 1;
                        continue block17;
                    }
                    if (meta < 6) {
                        meta = meta == 2 ? 5 : (meta == 5 ? 3 : (meta == 3 ? 4 : 2));
                        continue block17;
                    }
                    meta = meta == 9 ? 6 : meta + 1;
                    continue block17;
                }
                case REPEATER: {
                    meta = (bitface == 3 ? 0 : bitface + 1) | tickDelay << 2;
                    continue block17;
                }
                case SIGNPOST: {
                    meta = meta < 12 ? meta + 4 : meta - 12;
                    continue block17;
                }
                case SKULL: {
                    meta = meta == 1 ? 1 : (meta == 4 ? 2 : (meta == 2 ? 5 : (meta == 5 ? 3 : 4)));
                    continue block17;
                }
                case STAIRS: {
                    meta = (bitface == 0 ? 2 : (bitface == 2 ? 1 : (bitface == 1 ? 3 : 0))) | bit4;
                    continue block17;
                }
                case TRAPDOOR: {
                    meta = (bitface == 0 ? 3 : (bitface == 3 ? 1 : (bitface == 1 ? 2 : 0))) | bit4 | bit8;
                    continue block17;
                }
                case VINE: {
                    meta = meta == 1 ? 2 : (meta == 2 ? 4 : (meta == 4 ? 8 : 1));
                    continue block17;
                }
                case WALL_MOUNTED: {
                    if (meta <= 0 || meta >= 5) continue block17;
                    meta = meta == 4 ? 1 : (meta == 1 ? 3 : (meta == 3 ? 2 : 4));
                    continue block17;
                }
                case LEVER: {
                    meta = (meta -= meta > 7 ? 8 : 0) > 0 && meta < 5 ? (meta == 4 ? 1 : (meta == 1 ? 3 : (meta == 3 ? 2 : 4))) : (meta == 5 || meta == 6 ? (meta == 5 ? 6 : 5) : (meta == 7 ? 0 : 7));
                    meta |= bit8;
                    continue block17;
                }
                case WOOD: {
                    if (meta <= 4 || meta >= 12) continue block17;
                    meta = meta < 8 ? meta + 4 : meta - 4;
                    continue block17;
                }
            }
        }
        return meta;
    }

    public static final void setMetadata(World world, int x, int y, int z, int origMeta) {
        Block block = world.getBlock(x, y, z);
        if (BlockRotationData.getBlockRotationType(block) == null) {
            return;
        }
        switch (BlockRotationData.getBlockRotationType(block)) {
            case PISTON_CONTAINER: {
                world.setBlockMetadataWithNotify(x, y, z, origMeta, 2);
                break;
            }
            case RAIL: {
                world.setBlockMetadataWithNotify(x, y, z, origMeta, 2);
                break;
            }
        }
    }

    public static void rotatedFillWithBlocks(World world, int x, int z, int minX, int maxX, int minY, int maxY, int minZ, int maxZ, int facing, Block block, int meta) {
        for (int i = minX; i <= maxX; ++i) {
            for (int j = minY; j <= maxY; ++j) {
                for (int k = minZ; k <= maxZ; ++k) {
                    world.setBlock(x + StructureGenUtils.getOffsetX(i, k, facing), j, z + StructureGenUtils.getOffsetZ(i, k, facing), block, meta, 2);
                }
            }
        }
    }

    public static boolean isRotatedAreaClear(World world, int x, int z, int frontX, int backX, int minY, int maxY, int leftZ, int rightZ, int facing) {
        int maxZ;
        int front = Math.min(x + StructureGenUtils.getOffsetX(frontX, leftZ, facing), x + StructureGenUtils.getOffsetX(frontX, rightZ, facing));
        int back = Math.max(x + StructureGenUtils.getOffsetX(backX, leftZ, facing), x + StructureGenUtils.getOffsetX(backX, rightZ, facing));
        int left = Math.min(z + StructureGenUtils.getOffsetZ(frontX, leftZ, facing), z + StructureGenUtils.getOffsetZ(frontX, rightZ, facing));
        int right = Math.max(z + StructureGenUtils.getOffsetZ(backX, leftZ, facing), z + StructureGenUtils.getOffsetZ(backX, rightZ, facing));
        int minX = Math.min(front, back);
        int maxX = Math.max(front, back);
        int minZ = Math.min(left, right);
        List entities = world.getEntitiesWithinAABB(Entity.class, AxisAlignedBB.getBoundingBox((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)(maxZ = Math.max(left, right))));
        return (entities == null || entities.size() == 0) && StructureGenUtils.isAreaClear(world, minX, maxX, minY, maxY, minZ, maxZ);
    }
}

