/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.util;

import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import zeldaswordskills.util.PlayerUtils;

public class TimedAddItem {
    Timer timer;
    final EntityPlayer player;
    final ItemStack stack;
    final String sound;

    public TimedAddItem(EntityPlayer player, ItemStack stack, int delay) {
        this(player, stack, delay, "random.pop");
    }

    public TimedAddItem(EntityPlayer player, ItemStack stack, int delay, String sound) {
        this.player = player;
        this.stack = stack;
        this.sound = sound;
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new AddItemTask(), delay);
    }

    class AddItemTask
    extends TimerTask {
        AddItemTask() {
        }

        @Override
        public void run() {
            if (TimedAddItem.this.sound != null) {
                float pitch = 1.0f;
                if ("random.pop".equals(TimedAddItem.this.sound)) {
                    pitch = ((TimedAddItem.this.player.worldObj.rand.nextFloat() - TimedAddItem.this.player.worldObj.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f;
                }
                PlayerUtils.playSound(TimedAddItem.this.player, TimedAddItem.this.sound, 1.0f, pitch);
            }
            PlayerUtils.addItemToInventory(TimedAddItem.this.player, TimedAddItem.this.stack);
            TimedAddItem.this.timer.cancel();
        }
    }
}

