/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.util;

import net.minecraft.nbt.NBTTagCompound;

public class WarpPoint {
    public final int dimensionId;
    public final int x;
    public final int y;
    public final int z;

    public WarpPoint(int dimensionId, int x, int y, int z) {
        this.dimensionId = dimensionId;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dimensionId;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WarpPoint other = (WarpPoint)obj;
        return this.dimensionId == other.dimensionId && this.x == other.x && this.y == other.y && this.z == other.z;
    }

    public static WarpPoint fromString(String string) {
        if (string.length() < 9 || !string.startsWith("[") || !string.endsWith("]")) {
            return null;
        }
        String[] pieces = (string = string.substring(1, string.length() - 1)).split(",");
        if (pieces.length != 4) {
            return null;
        }
        try {
            return new WarpPoint(Integer.parseInt(pieces[0]), Integer.parseInt(pieces[1]), Integer.parseInt(pieces[2]), Integer.parseInt(pieces[3]));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public String toString() {
        return "[" + this.dimensionId + "," + this.x + "," + this.y + "," + this.z + "]";
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.setIntArray("WarpPointData", new int[]{this.dimensionId, this.x, this.y, this.z});
        return tag;
    }

    public static WarpPoint readFromNBT(NBTTagCompound tag) {
        if (tag.hasKey("WarpPointData") && tag.getTag("WarpPointData").getId() == 11) {
            int[] data = tag.getIntArray("WarpPointData");
            return new WarpPoint(data[0], data[1], data[2], data[3]);
        }
        return null;
    }
}

