/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;

public class TeleporterNoPortal
extends Teleporter {
    protected final WorldServer worldServer;

    public TeleporterNoPortal(WorldServer worldServer) {
        super(worldServer);
        this.worldServer = worldServer;
    }

    public static void adjustPosY(Entity entity) {
        int x = MathHelper.floor_double((double)entity.posX);
        int z = MathHelper.floor_double((double)entity.posZ);
        int y = entity.worldObj.getHeightValue(x, z);
        switch (entity.worldObj.provider.dimensionId) {
            case -1: {
                y -= 10;
                boolean flag = true;
                while (y > 30 && flag) {
                    if (entity.worldObj.getBlock(x, y, z).getMaterial().blocksMovement() && entity.worldObj.isAirBlock(x, y + 1, z) && entity.worldObj.isAirBlock(x, y + 2, z)) {
                        flag = false;
                        continue;
                    }
                    --y;
                }
                break;
            }
        }
        if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).setPositionAndUpdate((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
        } else {
            entity.setPosition((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
        }
    }

    public void placeInPortal(Entity entity, double dx, double dy, double dz, float yaw) {
        if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).setPositionAndUpdate(dx, dy, dz);
        } else {
            entity.setPosition(dx, dy, dz);
        }
    }

    public boolean makePortal(Entity entity) {
        return true;
    }
}

