/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.crisis;

import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.api.entity.CustomExplosion;
import zeldaswordskills.block.BlockAncientTablet;
import zeldaswordskills.block.BlockSecretStone;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.entity.mobs.EntityOctorok;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.BossType;
import zeldaswordskills.util.StructureGenUtils;
import zeldaswordskills.util.TimedChatDialogue;
import zeldaswordskills.util.WorldUtils;
import zeldaswordskills.world.crisis.AbstractCrisis;
import zeldaswordskills.world.gen.AntiqueAtlasHelper;

public class BossBattle
extends AbstractCrisis {
    protected final TileEntityDungeonCore core;
    protected final StructureBoundingBox box;
    protected int difficulty = -1;

    public BossBattle(TileEntityDungeonCore core) {
        this.core = core;
        this.box = core.getDungeonBoundingBox();
        this.eventTimer = 6000;
        if (core.getBossType() == null) {
            throw new IllegalArgumentException("Dungeon Core must have a valid BossType!");
        }
        if (this.box == null) {
            throw new IllegalArgumentException("Dungeon Core bounding box can not be null!");
        }
    }

    @Override
    public void beginCrisis(World world) {
        this.difficulty = world.difficultySetting.ordinal();
        this.fillAllGaps(world);
        this.generateBossMobs(world, this.getNumBosses());
        this.core.removeHinderBlock();
    }

    @Override
    protected void endCrisis(World world) {
        world.playSoundEffect((double)this.box.getCenterX() + 0.5, (double)(this.box.getCenterY() + 1), (double)this.box.getCenterZ() + 0.5, "zeldaswordskills:secret_medley", 1.0f, 1.0f);
        if (world.difficultySetting != EnumDifficulty.PEACEFUL) {
            WorldUtils.spawnXPOrbsWithRandom(world, world.rand, this.box.getCenterX(), this.box.getCenterY(), this.box.getCenterZ(), 1000 * this.difficulty);
        }
        AntiqueAtlasHelper.placeCustomTile(world, "zss_dungeon" + this.core.getBossType().ordinal() + "_fin", this.core.xCoord, this.core.yCoord, this.core.zCoord);
    }

    @Override
    protected boolean canCrisisConclude(World world) {
        return this.areAllEnemiesDead(world);
    }

    @Override
    protected void onUpdateTick(World world) {
    }

    private boolean areAllEnemiesDead(World world) {
        return world.getEntitiesWithinAABB(IMob.class, AxisAlignedBB.getBoundingBox((double)((double)this.box.getCenterX() - 0.5), (double)this.box.getCenterY(), (double)((double)this.box.getCenterZ() - 0.5), (double)((double)this.box.getCenterX() + 0.5), (double)(this.box.getCenterY() + 1), (double)((double)this.box.getCenterZ() + 0.5)).expand((double)(this.box.getXSize() / 2), (double)(this.box.getYSize() / 2), (double)(this.box.getZSize() / 2))).isEmpty();
    }

    protected void destroyRandomPillar(World world, boolean explode) {
        int z;
        int offset;
        int corner = world.rand.nextInt(4);
        int n = offset = this.box.getXSize() < 11 ? 2 : 3;
        int x = corner < 2 ? (this.box.getXSize() < 11 ? this.box.getCenterX() : this.box.minX) + offset : (this.box.getXSize() < 11 ? this.box.getCenterX() : this.box.maxX) - offset;
        int y = this.box.minY + (world.rand.nextInt(3) + 1);
        int n2 = corner % 2 == 0 ? (this.box.getZSize() < 11 ? this.box.getCenterZ() : this.box.minZ) + offset : (z = (this.box.getZSize() < 11 ? this.box.getCenterZ() : this.box.maxZ) - offset);
        if (!world.isAirBlock(x, y, z)) {
            if (explode) {
                float radius = 1.5f + (float)this.difficulty * 0.5f;
                CustomExplosion.createExplosion(world, x, y, z, radius, BombType.BOMB_STANDARD);
            }
            world.playSoundEffect((double)x + 0.5, (double)this.box.getCenterY(), (double)z + 0.5, "zeldaswordskills:rock_fall", 1.0f, 1.0f);
            StructureGenUtils.destroyBlocksAround(world, x - 1, x + 2, y, this.box.maxY - 2, z - 1, z + 2, null, false);
        }
    }

    protected void fillAllGaps(World world) {
        Block block = this.core.getRenderBlock();
        if (block == null) {
            block = BlockSecretStone.getBlockFromMeta(world.getBlockMetadata(this.core.xCoord, this.core.yCoord, this.core.zCoord));
        }
        for (int i = this.box.minX; i <= this.box.maxX; ++i) {
            for (int j = this.box.minY; j <= this.box.maxY; ++j) {
                for (int k = this.box.minZ; k <= this.box.maxZ; ++k) {
                    if (i != this.box.minX && i != this.box.maxX && j != this.box.minY && j != this.box.maxY && k != this.box.minZ && k != this.box.maxZ || world.getBlock(i, j, k).func_149730_j()) continue;
                    world.setBlock(i, j, k, block, 0, 2);
                }
            }
        }
    }

    protected void setDungeonFloorTo(World world, Block block, int meta, Block toReplace) {
        Block replace = toReplace != null ? toReplace : BlockSecretStone.getBlockFromMeta(world.getBlockMetadata(this.core.xCoord, this.core.yCoord, this.core.zCoord));
        for (int i = this.box.minX + 1; i < this.box.maxX; ++i) {
            for (int j = this.box.minZ + 1; j < this.box.maxZ; ++j) {
                if (world.getBlock(i, this.box.minY, j) != replace) continue;
                world.setBlock(i, this.box.minY, j, block, meta, 2);
            }
        }
    }

    protected void setRandomBlockTo(World world, Block block, int meta, String sound) {
        int[] pos = this.getRandomPlaceablePosition(world, block, this.box.minX + 1, this.box.minY + 3, this.box.minZ + 1, this.box.getXSize() - 1, this.box.getYSize() - 3, this.box.getZSize() - 1);
        if (pos != null && world.isAirBlock(pos[0], pos[1], pos[2])) {
            world.setBlock(pos[0], pos[1], pos[2], block, meta, 3);
            if (sound.length() > 0) {
                world.playSoundEffect((double)pos[0], (double)pos[1], (double)pos[2], sound, 1.0f, 1.0f);
            }
        }
    }

    protected int[] getRandomPlaceablePosition(World world, Block block, int minX, int minY, int minZ, int dx, int dy, int dz) {
        int i = minX + (dx > 1 ? world.rand.nextInt(dx) : 0);
        int j = minY + (dy > 1 ? world.rand.nextInt(dy) : 0);
        int k = minZ + (dz > 1 ? world.rand.nextInt(dz) : 0);
        if (block != null && block.canPlaceBlockAt(world, i, j, k)) {
            return new int[]{i, j, k};
        }
        if (block == null && world.getBlock(i, j, k).isReplaceable((IBlockAccess)world, i, j, k)) {
            return new int[]{i, j, k};
        }
        return null;
    }

    protected void generateAncientTablet(World world) {
        if (world.rand.nextFloat() < Config.getAncientTabletGenChance()) {
            int[] pos = null;
            for (int n = 0; n < 4 && pos == null; ++n) {
                pos = this.getRandomPlaceablePosition(world, ZSSBlocks.ancientTablet, this.box.minX + 1, this.box.maxY + 1, this.box.minZ + 1, this.box.getXSize() - 1, 1, this.box.getZSize() - 1);
            }
            if (pos != null) {
                int meta = BlockAncientTablet.EnumType.byMetadata(world.rand.nextInt(BlockAncientTablet.EnumType.values().length)).getMetadata();
                world.setBlock((int)pos[0], (int)pos[1], (int)pos[2], ZSSBlocks.ancientTablet, meta | world.rand.nextInt(2), 2);
                world.playSoundEffect((double)pos[0], (double)pos[1], (double)pos[2], "zeldaswordskills:rock_fall", 1.0f, 1.0f);
                EntityPlayer player = world.getClosestPlayer((double)this.box.getCenterX(), (double)this.box.getCenterY(), (double)this.box.getCenterZ(), 16.0);
                if (player != null) {
                    new TimedChatDialogue(player, 1250, 1250, new IChatComponent[]{new ChatComponentTranslation("chat.zss.ancient_tablet.spawn", new Object[0])});
                }
            }
        }
    }

    protected void generateBossMobs(World world, int number) {
        for (int i = 0; i < number; ++i) {
            Entity mob = this.core.getBossType().getNewMob(world);
            if (mob == null) continue;
            this.spawnMobInCorner(world, mob, i, true, true);
        }
    }

    protected int getNumBosses() {
        return Config.getNumBosses();
    }

    protected void spawnMobInCorner(World world, Entity mob, int corner, boolean equip, boolean health) {
        int x = corner < 2 ? this.box.minX + 2 : this.box.maxX - 2;
        int z = corner % 2 == 0 ? this.box.minZ + 2 : this.box.maxZ - 2;
        int y = World.doesBlockHaveSolidTopSurface((IBlockAccess)world, (int)x, (int)(this.box.minY + 1), (int)z) ? this.box.minY + 1 : this.box.minY + 3;
        WorldUtils.setEntityInStructure(world, mob, x, y, z);
        if (mob instanceof EntityLivingBase) {
            if (health) {
                this.boostHealth(world, (EntityLivingBase)mob);
            }
            if (equip) {
                this.equipEntity(world, (EntityLivingBase)mob);
            }
        }
        if (mob instanceof EntityLiving) {
            ((EntityLiving)mob).func_110163_bv();
        }
        if (!world.isRemote) {
            world.spawnEntityInWorld(mob);
        }
    }

    protected void boostHealth(World world, EntityLivingBase entity) {
        double d = (float)(2 * this.difficulty) * Config.getBossHealthFactor();
        entity.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(entity.getEntityAttribute(SharedMonsterAttributes.maxHealth).getAttributeValue() * d);
        entity.setHealth(entity.getMaxHealth());
    }

    protected void equipEntity(World world, EntityLivingBase entity) {
        ItemStack melee = null;
        ItemStack ranged = new ItemStack((Item)Items.bow);
        Item[] armorSet = null;
        switch (this.difficulty) {
            case 1: {
                armorSet = new Item[]{Items.chainmail_boots, Items.chainmail_leggings, Items.chainmail_chestplate, Items.chainmail_helmet};
                melee = new ItemStack(Items.iron_sword);
                ranged.addEnchantment(Enchantment.power, 1);
                break;
            }
            case 2: {
                armorSet = new Item[]{Items.iron_boots, Items.iron_leggings, Items.iron_chestplate, Items.iron_helmet};
                melee = new ItemStack(Items.iron_sword);
                melee.addEnchantment(Enchantment.sharpness, 2);
                ranged.addEnchantment(Enchantment.punch, 1);
                ranged.addEnchantment(Enchantment.power, 3);
                break;
            }
            case 3: {
                armorSet = new Item[]{Items.diamond_boots, Items.diamond_leggings, Items.diamond_chestplate, Items.diamond_helmet};
                melee = new ItemStack(Items.diamond_sword);
                melee.addEnchantment(Enchantment.sharpness, 4);
                melee.addEnchantment(Enchantment.fireAspect, 1);
                ranged.addEnchantment(Enchantment.flame, 1);
                ranged.addEnchantment(Enchantment.punch, 2);
                ranged.addEnchantment(Enchantment.power, 5);
            }
        }
        if (armorSet != null) {
            for (int i = 0; i < armorSet.length; ++i) {
                ItemStack armor = new ItemStack((Item)armorSet[i]);
                EnchantmentHelper.addRandomEnchantment((Random)world.rand, (ItemStack)armor, (int)(this.difficulty + world.rand.nextInt(this.difficulty * 5)));
                entity.setCurrentItemOrArmor(i + 1, armor);
            }
        }
        if (entity instanceof EntityZombie) {
            ((EntityZombie)entity).setCurrentItemOrArmor(0, melee);
        } else if (entity instanceof EntitySkeleton) {
            EntitySkeleton skeleton = (EntitySkeleton)entity;
            if (this.core.getBossType() == BossType.HELL) {
                skeleton.setSkeletonType(1);
                skeleton.setCurrentItemOrArmor(0, melee);
            } else {
                skeleton.setCurrentItemOrArmor(0, ranged);
            }
        } else {
            if (entity instanceof EntityOctorok) {
                ((EntityOctorok)entity).setType(1);
            }
            IAttributeInstance iattribute = entity.getEntityAttribute(SharedMonsterAttributes.attackDamage);
            AttributeModifier modifier = new AttributeModifier(UUID.randomUUID(), "Boss Attack Bonus", (double)this.difficulty * 2.0, 0).setSaved(true);
            iattribute.applyModifier(modifier);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.setInteger("difficulty", this.difficulty);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.difficulty = compound.getInteger("difficulty");
    }
}

