/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.crisis;

import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.util.WorldUtils;
import zeldaswordskills.world.crisis.BossBattle;
import zeldaswordskills.world.gen.structure.RoomBoss;

public class DesertBattle
extends BossBattle {
    public DesertBattle(TileEntityDungeonCore core) {
        super(core);
    }

    @Override
    public void beginCrisis(World world) {
        super.beginCrisis(world);
        if (this.difficulty > 1) {
            this.scheduleUpdateTick(300 - world.rand.nextInt(100));
            this.handleDispensers(world, false);
            if (this.difficulty == 3) {
                this.setDungeonFloorTo(world, Blocks.soul_sand, 0, null);
            }
        }
    }

    @Override
    protected void endCrisis(World world) {
        this.setDungeonFloorTo(world, Blocks.sandstone, 0, Blocks.soul_sand);
        super.endCrisis(world);
    }

    @Override
    protected void onUpdateTick(World world) {
        this.handleDispensers(world, true);
        this.scheduleUpdateTick(300 - this.difficulty * 50 - world.rand.nextInt(100));
    }

    protected void handleDispensers(World world, boolean activate) {
        int j = this.box.minY + 2;
        for (int side = 0; side < 4; ++side) {
            int maxX;
            int minX = side == 3 ? this.box.maxX : (side == 1 ? this.box.minX : this.box.minX + 3);
            int n = maxX = side == 0 || side == 2 ? this.box.maxX - 2 : minX + 1;
            int minZ = side == 0 ? this.box.maxZ : (side == 2 ? this.box.minZ : this.box.minZ + 3);
            int maxZ = side == 3 || side == 1 ? this.box.maxZ - 2 : minZ + 1;
            for (int i = minX; i < maxX; ++i) {
                for (int k = minZ; k < maxZ; ++k) {
                    if (activate) {
                        TileEntity te;
                        if (world.getBlock(i, j, k) != Blocks.dispenser || world.rand.nextInt(9 - 2 * this.difficulty) != 0 || !((te = world.getTileEntity(i, j, k)) instanceof IInventory)) continue;
                        WorldUtils.addItemToInventory(new ItemStack(Items.arrow), (IInventory)te);
                        Blocks.dispenser.updateTick(world, i, j, k, world.rand);
                        continue;
                    }
                    world.setBlock(i, j, k, Blocks.dispenser);
                    world.setBlockMetadataWithNotify(i, j, k, RoomBoss.facingToOrientation[(side + 2) % 4], 2);
                }
            }
        }
    }
}

