/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.crisis;

import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.entity.mobs.EntityBlackKnight;
import zeldaswordskills.entity.projectile.EntityBomb;
import zeldaswordskills.world.crisis.BossBattle;

public class EarthBattle
extends BossBattle {
    public EarthBattle(TileEntityDungeonCore core) {
        super(core);
    }

    @Override
    protected int getNumBosses() {
        return 1;
    }

    @Override
    protected void generateBossMobs(World world, int number) {
        Entity mob = this.core.getBossType().getNewMob(world);
        if (mob instanceof EntityBlackKnight) {
            ((EntityBlackKnight)mob).addRandomArmor();
            this.spawnMobInCorner(world, mob, world.rand.nextInt(4), false, false);
        }
    }

    @Override
    public void beginCrisis(World world) {
        super.beginCrisis(world);
        if (this.difficulty > 1) {
            this.scheduleUpdateTick(200 + world.rand.nextInt(200));
        }
    }

    @Override
    protected void onUpdateTick(World world) {
        int nextUpdate = 10;
        int x = this.box.minX + world.rand.nextInt(this.box.getXSize() - 1) + 1;
        int y = this.box.maxY - 1;
        int z = this.box.minZ + world.rand.nextInt(this.box.getZSize() - 1) + 1;
        if (Math.abs(this.box.getCenterX() - x) > 1 && Math.abs(this.box.getCenterZ() - z) > 1) {
            EntityBomb bomb = new EntityBomb(world).setDestructionFactor(0.7f).addTime((3 - this.difficulty) * 16);
            bomb.setPosition(x, y, z);
            if (world.isAirBlock(x, this.box.minY, z)) {
                bomb.setNoGrief();
            }
            if (world.getCollidingBoundingBoxes((Entity)bomb, bomb.boundingBox).isEmpty() && !world.isRemote) {
                world.playSoundEffect((double)x, (double)y, (double)z, "zeldaswordskills:bomb_whistle", 1.0f, 1.0f);
                world.spawnEntityInWorld((Entity)bomb);
                nextUpdate = (3 - this.difficulty) * 100 + 50 + world.rand.nextInt(400);
            }
        }
        this.scheduleUpdateTick(nextUpdate);
    }
}

