/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.crisis;

import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.util.StructureGenUtils;
import zeldaswordskills.world.crisis.BossBattle;

public class FireBattle
extends BossBattle {
    public FireBattle(TileEntityDungeonCore core) {
        super(core);
    }

    @Override
    public void beginCrisis(World world) {
        super.beginCrisis(world);
        this.scheduleUpdateTick(50);
    }

    @Override
    protected void endCrisis(World world) {
        StructureGenUtils.replaceMaterialWith(world, this.box.minX, this.box.maxX, this.box.minY, this.box.maxY, this.box.minZ, this.box.maxZ, Material.lava, Blocks.air, 0);
        super.endCrisis(world);
    }

    @Override
    protected void onUpdateTick(World world) {
        if (this.difficulty > 1) {
            if (this.eventTimer % (550 - this.difficulty * 50) == 0) {
                this.setRandomBlockTo(world, Blocks.lava, 0, "");
            }
            if (this.eventTimer % (800 - this.difficulty * 50) == 0) {
                boolean flag = this.difficulty == 3;
                this.spawnMobInCorner(world, (Entity)new EntitySkeleton(world), world.rand.nextInt(4), flag, flag);
            }
        }
        if (this.eventTimer % 500 == 0) {
            this.destroyRandomPillar(world, true);
        }
        this.scheduleUpdateTick(50);
    }
}

