/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.gen.feature;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.api.item.IFairyUpgrade;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.entity.EntityFairy;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.WorldUtils;

public class FairySpawner {
    protected final TileEntityDungeonCore core;
    protected final StructureBoundingBox box;
    protected int maxFairies = 0;
    protected int fairiesSpawned = 0;
    protected long nextResetDate = 0L;
    protected int itemUpdate = -1;
    protected String playerName = "";
    protected int rupees = 0;

    public FairySpawner(TileEntityDungeonCore core) {
        this.core = core;
        this.box = core.getDungeonBoundingBox();
        if (this.box == null) {
            throw new IllegalArgumentException("Dungeon Core bounding box can not be null!");
        }
    }

    public FairySpawner setMaxFairies(int maxFairies) {
        this.maxFairies = maxFairies;
        return this;
    }

    public boolean consumeRupees(int amount) {
        if (amount > this.rupees) {
            return false;
        }
        this.rupees -= amount;
        return true;
    }

    public void scheduleItemUpdate(EntityPlayer player) {
        if (this.itemUpdate < 0) {
            this.itemUpdate = 2;
        }
        if (this.playerName.equals("")) {
            this.playerName = player.getCommandSenderName();
        }
    }

    public void onBlockBroken() {
        this.onBlockBroken(this.core.getWorldObj(), this.core.xCoord, this.core.yCoord, this.core.zCoord);
    }

    private void onBlockBroken(World world, int x, int y, int z) {
        while (this.rupees > 0) {
            int k = this.rupees > 64 ? 64 : this.rupees;
            this.rupees -= k;
            world.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.orb", 1.0f, 1.0f);
            WorldUtils.spawnItemWithRandom(world, new ItemStack(Items.emerald, k), x, y, z);
        }
    }

    public void onUpdate() {
        this.updateSpawner(this.core.getWorldObj(), this.core.xCoord, this.core.yCoord, this.core.zCoord);
        this.updateItems(this.core.getWorldObj(), this.core.xCoord, this.core.yCoord, this.core.zCoord);
    }

    private void updateSpawner(World world, int x, int y, int z) {
        if (this.fairiesSpawned < this.maxFairies) {
            int nearby;
            float f = world.rand.nextFloat();
            float f2 = world.isDaytime() ? 0.01f : 0.2f;
            if (f < f2 && (nearby = world.getEntitiesWithinAABB(EntityFairy.class, AxisAlignedBB.getBoundingBox((double)x, (double)this.box.getCenterY(), (double)z, (double)(x + 1), (double)(this.box.getCenterY() + 1), (double)(z + 1)).expand((double)(this.box.getXSize() / 2), (double)(this.box.getYSize() / 2), (double)(this.box.getZSize() / 2))).size()) < 4) {
                EntityFairy fairy = new EntityFairy(world);
                fairy.setFairyHome(x, y + 2, z);
                world.spawnEntityInWorld((Entity)fairy);
                if (++this.fairiesSpawned == this.maxFairies) {
                    this.nextResetDate = world.getTotalWorldTime() + (long)(24000 * (world.rand.nextInt(Config.getDaysToRespawn()) + 1));
                }
            }
        }
        if (this.fairiesSpawned == this.maxFairies && !world.isDaytime() && world.getTotalWorldTime() > this.nextResetDate) {
            this.fairiesSpawned = 0;
        }
    }

    private void updateItems(World world, int x, int y, int z) {
        if (this.itemUpdate > 0) {
            --this.itemUpdate;
        } else if (this.itemUpdate == 0) {
            EntityPlayer player = world.getPlayerEntityByName(this.playerName);
            if (player != null) {
                List list = world.getEntitiesWithinAABB(EntityItem.class, AxisAlignedBB.getBoundingBox((double)x, (double)this.box.getCenterY(), (double)z, (double)(x + 1), (double)(this.box.getCenterY() + 1), (double)(z + 1)).expand((double)(this.box.getXSize() / 2), (double)(this.box.getYSize() / 2), (double)(this.box.getZSize() / 2)));
                for (EntityItem item : list) {
                    if (!item.isEntityAlive()) continue;
                    ItemStack stack = item.getEntityItem();
                    if (stack.getItem() == Items.emerald) {
                        player.triggerAchievement((StatBase)ZSSAchievements.fairyEmerald);
                        world.playSoundEffect((double)x + 0.5, (double)(y + 1), (double)z + 0.5, "random.orb", 1.0f, 1.0f);
                        this.rupees += stack.stackSize;
                        item.setDead();
                        continue;
                    }
                    if (!(stack.getItem() instanceof IFairyUpgrade) || !((IFairyUpgrade)stack.getItem()).hasFairyUpgrade(stack)) continue;
                    ((IFairyUpgrade)stack.getItem()).handleFairyUpgrade(item, player, this.core);
                }
            }
            this.itemUpdate = -1;
            this.playerName = "";
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTTagCompound data = new NBTTagCompound();
        data.setInteger("maxFairies", this.maxFairies);
        data.setInteger("spawned", this.fairiesSpawned);
        data.setLong("nextResetDate", this.nextResetDate);
        data.setInteger("itemUpdate", this.itemUpdate);
        data.setInteger("rupees", this.rupees);
        data.setString("playerName", this.playerName);
        compound.setTag("FairySpawner", (NBTBase)data);
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagCompound data = compound.getCompoundTag("FairySpawner");
        this.maxFairies = data.getInteger("maxFairies");
        this.fairiesSpawned = data.getInteger("spawned");
        this.nextResetDate = data.getTag("nextResetDate").getId() == 4 ? data.getLong("nextResetDate") : 0L;
        this.itemUpdate = data.getInteger("itemUpdate");
        this.rupees = data.getInteger("rupees");
        this.playerName = data.getString("playerName");
    }
}

