/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.gen.feature;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.ref.Config;

public class WorldGenJars
extends WorldGenerator {
    public WorldGenJars() {
    }

    public WorldGenJars(boolean doNotify) {
        super(doNotify);
    }

    public void generate2(World world, Random rand, int x, int y, int z, int n, boolean isUnderground) {
        for (int l = 0; l < 64 && n > 0; ++l) {
            int k;
            int j;
            int i = x + rand.nextInt(4) - rand.nextInt(4);
            if (!this.canPlaceBlockAt(world, i, j = y + rand.nextInt(4) - rand.nextInt(4), k = z + rand.nextInt(4) - rand.nextInt(4), isUnderground) || world.provider.hasNoSky && j >= 127 || !ZSSBlocks.ceramicJar.canBlockStay(world, i, j, k)) continue;
            world.setBlock(i, j, k, ZSSBlocks.ceramicJar, 0, 2);
            --n;
        }
    }

    private boolean canPlaceBlockAt(World world, int i, int j, int k, boolean isUnderground) {
        return world.isAirBlock(i, j, k) || !isUnderground && Config.genJarsInWater() && world.getBlock(i, j, k).getMaterial() == Material.water && !world.canBlockFreeze(i, j, k, false);
    }

    public void doJarGen(World world, Random rand, int chunkX, int chunkZ, int jarsPerCluster, boolean isUnderground) {
        int j;
        int i = chunkX + rand.nextInt(16) + 8;
        int k = chunkZ + rand.nextInt(16) + 8;
        int n = jarsPerCluster - rand.nextInt(jarsPerCluster);
        if (Config.genJarsInWater() && !isUnderground) {
            for (j = world.provider.isHellWorld ? rand.nextInt(128) : world.getHeightValue(i, k) + 1; j > 0 && world.getBlock(i, j, k).getMaterial() == Material.water; --j) {
            }
        }
        this.generate2(world, rand, i, j, k, n, isUnderground);
    }

    public boolean generate(World world, Random rand, int i, int j, int k) {
        this.generate2(world, rand, i, j, k, Config.getJarsPerCluster() - rand.nextInt(Config.getJarsPerCluster()), false);
        return true;
    }
}

