/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.gen.structure;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.BossType;
import zeldaswordskills.util.StructureGenUtils;
import zeldaswordskills.world.gen.AntiqueAtlasHelper;
import zeldaswordskills.world.gen.structure.RoomBase;
import zeldaswordskills.world.gen.structure.RoomBoss;
import zeldaswordskills.world.gen.structure.ZSSMapGenBase;

public class MapGenBossRoom
extends ZSSMapGenBase {
    @Override
    public void generate(IChunkProvider provider, World world, Random rand, int chunkX, int chunkZ) {
        this.worldObj = world;
        this.loadOrCreateData(this.worldObj);
        int size = rand.nextInt(5) + 9;
        int posX = (chunkX << 4) + rand.nextInt(16 - size);
        int posZ = (chunkZ << 4) + rand.nextInt(16 - size);
        if (world.villageCollectionObj != null && world.villageCollectionObj.findNearestVillage(posX, 64, posZ, 8 * Config.getMinBossDistance()) != null) {
            return;
        }
        BossType type = BossType.getBossType(world, posX, posZ);
        if (type != null) {
            int posY;
            RoomBoss room = new RoomBoss(type, chunkX, chunkZ, rand, size, Blocks.stone);
            if (rand.nextFloat() < 0.2f && !this.areStructuresWithinRange(room, Config.getMinBossDistance()) && room.generate(this, world, rand, posX, posY = StructureGenUtils.getAverageSurfaceHeight(world, posX, posZ), posZ)) {
                this.onStructureGenerated(world, room);
            }
        }
    }

    @Override
    public String getTagName() {
        return "zssBossRooms";
    }

    @Override
    protected StructureBoundingBox getStructureBBAt(int x, int y, int z) {
        return null;
    }

    public boolean shouldDenyLakeAt(int chunkX, int chunkZ) {
        return this.isRoomInChunk(chunkX, chunkZ) || this.isRoomInChunk(chunkX + 1, chunkZ + 1) || this.isRoomInChunk(chunkX + 1, chunkZ - 1) || this.isRoomInChunk(chunkX - 1, chunkZ + 1) || this.isRoomInChunk(chunkX - 1, chunkZ - 1) || this.isRoomInChunk(chunkX, chunkZ + 1) || this.isRoomInChunk(chunkX, chunkZ - 1) || this.isRoomInChunk(chunkX + 1, chunkZ) || this.isRoomInChunk(chunkX - 1, chunkZ);
    }

    protected boolean isRoomInChunk(int chunkX, int chunkZ) {
        return this.structureMap.containsKey(ChunkCoordIntPair.chunkXZ2Int((int)chunkX, (int)chunkZ));
    }

    @Override
    public boolean areStructuresWithinRange(RoomBase room, int range) {
        this.loadOrCreateData(this.worldObj);
        for (int i = room.chunkX - range; i <= room.chunkX + range; ++i) {
            for (int j = room.chunkZ - range; j <= room.chunkZ + range; ++j) {
                if (!this.structureMap.containsKey(ChunkCoordIntPair.chunkXZ2Int((int)i, (int)j))) continue;
                BossType type = ((RoomBoss)room).getBossType();
                if (type != null && (Config.areBossDungeonsRandom() || type.ordinal() == this.getBossTypeFor(i, j))) {
                    return true;
                }
                if ((room.chunkX - i) * (room.chunkX - i) + (room.chunkZ - j) * (room.chunkZ - j) >= range * range / 2) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void translateNbtIntoMap(NBTTagCompound compound) {
        if (compound.hasKey("chunkX") && compound.hasKey("chunkZ") && compound.hasKey("bossType")) {
            int i = compound.getInteger("chunkX");
            int j = compound.getInteger("chunkZ");
            int bossType = compound.getInteger("bossType");
            this.structureMap.put(ChunkCoordIntPair.chunkXZ2Int((int)i, (int)j), bossType);
        } else {
            ZSSMain.logger.warn("Failed to translate Boss Room NBT compound into structure map");
        }
    }

    protected int getBossTypeFor(int chunkX, int chunkZ) {
        if (this.structureMap.containsKey(ChunkCoordIntPair.chunkXZ2Int((int)chunkX, (int)chunkZ))) {
            return (Integer)this.structureMap.get(ChunkCoordIntPair.chunkXZ2Int((int)chunkX, (int)chunkZ));
        }
        return -1;
    }

    protected void onStructureGenerated(World world, RoomBoss room) {
        AntiqueAtlasHelper.placeCustomTile(world, "zss_dungeon" + room.getBossType().ordinal(), room.chunkX, room.chunkZ);
        this.structureMap.put(ChunkCoordIntPair.chunkXZ2Int((int)room.chunkX, (int)room.chunkZ), room.getBossType().ordinal());
        NBTTagCompound compound = new NBTTagCompound();
        compound.setInteger("bossType", room.getBossType().ordinal());
        this.addRoomTag(compound, room.chunkX, room.chunkZ);
    }
}

