/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.gen.structure;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.StructureGenUtils;
import zeldaswordskills.world.gen.structure.RoomBase;
import zeldaswordskills.world.gen.structure.RoomSecret;
import zeldaswordskills.world.gen.structure.ZSSMapGenBase;

public class MapGenSecretRoom
extends ZSSMapGenBase {
    @Override
    public void generate(IChunkProvider provider, World world, Random rand, int chunkX, int chunkZ) {
        this.worldObj = world;
        this.loadOrCreateData(this.worldObj);
        NBTTagList roomList = this.getStructureListFor(chunkX, chunkZ);
        int posX = chunkX << 4;
        int posZ = chunkZ << 4;
        int posY = StructureGenUtils.getAverageSurfaceHeight(world, posX, posZ);
        if (posY < 1) {
            return;
        }
        for (int i = 0; i < Config.getAttemptsPerChunk(); ++i) {
            int z;
            int y;
            int x;
            int size;
            RoomSecret room;
            if (!(rand.nextFloat() < Config.getSecretRoomChance()) || !(room = new RoomSecret(chunkX, chunkZ, size = Math.min(rand.nextInt(6) + 3, 6), Blocks.stone)).generate(this, world, rand, x = posX + rand.nextInt(16 - size), y = rand.nextInt(posY) + (i % 2 == 0 ? rand.nextInt(16) : rand.nextInt(8)), z = posZ + rand.nextInt(16 - size))) continue;
            roomList.appendTag((NBTBase)room.writeToNBT());
            this.updateChunkStructureMap(roomList, chunkX, chunkZ);
        }
        if (roomList.tagCount() > 0) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.setTag("roomList", (NBTBase)roomList);
            this.addRoomTag(compound, chunkX, chunkZ);
        }
    }

    @Override
    public String getTagName() {
        return "zssSecretRooms";
    }

    @Override
    protected StructureBoundingBox getStructureBBAt(int x, int y, int z) {
        NBTTagList roomList = this.getStructureListFor(x >> 4, z >> 4);
        for (int i = 0; i < roomList.tagCount(); ++i) {
            StructureBoundingBox box;
            NBTTagCompound compound = roomList.getCompoundTagAt(i);
            if (!compound.hasKey("BB") || !(box = new StructureBoundingBox(compound.getIntArray("BB"))).isVecInside(x, y, z)) continue;
            return box;
        }
        return null;
    }

    @Override
    protected void translateNbtIntoMap(NBTTagCompound compound) {
        if (compound.hasKey("chunkX") && compound.hasKey("chunkZ") && compound.hasKey("roomList")) {
            int i = compound.getInteger("chunkX");
            int j = compound.getInteger("chunkZ");
            NBTTagList roomList = compound.getTagList("roomList", (int)compound.getId());
            this.structureMap.put(ChunkCoordIntPair.chunkXZ2Int((int)i, (int)j), roomList);
        } else {
            ZSSMain.logger.warn("Failed to translate NBT compound into structure map");
        }
    }

    protected NBTTagList getStructureListFor(int chunkX, int chunkZ) {
        this.loadOrCreateData(this.worldObj);
        if (this.structureMap.containsKey(ChunkCoordIntPair.chunkXZ2Int((int)chunkX, (int)chunkZ))) {
            return (NBTTagList)this.structureMap.get(ChunkCoordIntPair.chunkXZ2Int((int)chunkX, (int)chunkZ));
        }
        return new NBTTagList();
    }

    protected void updateChunkStructureMap(NBTTagList roomList, int chunkX, int chunkZ) {
        this.structureMap.put(ChunkCoordIntPair.chunkXZ2Int((int)chunkX, (int)chunkZ), roomList);
    }

    @Override
    public boolean areStructuresWithinRange(RoomBase room, int range) {
        StructureBoundingBox box = room.getBoundingBox();
        if (this.isNearStructureInChunk(room, box, room.chunkX, room.chunkZ, range)) {
            return true;
        }
        for (int i = 0; i <= (range + 8) / 16; ++i) {
            if (this.isNearStructureInChunk(room, box, room.chunkX + i + 1, room.chunkZ, range)) {
                return true;
            }
            if (this.isNearStructureInChunk(room, box, room.chunkX - i - 1, room.chunkZ, range)) {
                return true;
            }
            if (this.isNearStructureInChunk(room, box, room.chunkX, room.chunkZ + i + 1, range)) {
                return true;
            }
            if (this.isNearStructureInChunk(room, box, room.chunkX, room.chunkZ - i - 1, range)) {
                return true;
            }
            if (this.isNearStructureInChunk(room, box, room.chunkX + i + 1, room.chunkZ + i + 1, range)) {
                return true;
            }
            if (this.isNearStructureInChunk(room, box, room.chunkX + i + 1, room.chunkZ - i - 1, range)) {
                return true;
            }
            if (this.isNearStructureInChunk(room, box, room.chunkX - i - 1, room.chunkZ + i + 1, range)) {
                return true;
            }
            if (!this.isNearStructureInChunk(room, box, room.chunkX - i - 1, room.chunkZ - i - 1, range)) continue;
            return true;
        }
        return false;
    }

    protected boolean isNearStructureInChunk(RoomBase room, StructureBoundingBox box1, int chunkX, int chunkZ, int range) {
        NBTTagList roomList = this.getStructureListFor(chunkX, chunkZ);
        for (int i = 0; i < roomList.tagCount(); ++i) {
            NBTTagCompound compound = roomList.getCompoundTagAt(i);
            if (compound.hasKey("BB")) {
                StructureBoundingBox box2 = new StructureBoundingBox(compound.getIntArray("BB"));
                double dx = (box1.getXSize() + box2.getXSize()) / 2;
                if (!(StructureGenUtils.getDistanceSqBetween(box1, box2) < ((double)range + dx) * ((double)range + dx)) || room.inOcean && box1.minY > box2.maxY + range / 4 + 2) continue;
                return true;
            }
            ZSSMain.logger.warn("Invalid tag while checking for structures in chunk " + chunkX + "/" + chunkZ);
        }
        return false;
    }
}

