/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.gen.structure;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.common.util.ForgeDirection;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.block.IDungeonBlock;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.block.tileentity.TileEntityInscription;
import zeldaswordskills.ref.Config;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.songs.ZeldaSongs;
import zeldaswordskills.util.BiomeType;
import zeldaswordskills.util.StructureGenUtils;
import zeldaswordskills.world.gen.structure.RoomBase;
import zeldaswordskills.world.gen.structure.ZSSMapGenBase;

public class MapGenSongPillar
extends ZSSMapGenBase {
    private static final Set<String> allowedBiomes = new HashSet<String>();
    private AbstractZeldaSong song;
    private BiomeGenBase biome;
    private long chunk;
    private int range = Config.getPillarRange();

    public MapGenSongPillar() {
        if (allowedBiomes.isEmpty()) {
            allowedBiomes.addAll(Arrays.asList(BiomeType.COLD.defaultBiomes));
            allowedBiomes.addAll(Arrays.asList(BiomeType.FOREST.defaultBiomes));
            allowedBiomes.addAll(Arrays.asList(BiomeType.JUNGLE.defaultBiomes));
            allowedBiomes.addAll(Arrays.asList(BiomeType.MOUNTAIN.defaultBiomes));
            allowedBiomes.addAll(Arrays.asList(BiomeType.PLAINS.defaultBiomes));
            allowedBiomes.addAll(Arrays.asList(BiomeType.TAIGA.defaultBiomes));
        }
    }

    @Override
    public void generate(IChunkProvider provider, World world, Random rand, int chunkX, int chunkZ) {
        boolean flag2;
        this.worldObj = world;
        this.loadOrCreateData(this.worldObj);
        int x = (chunkX << 4) + rand.nextInt(16);
        int z = (chunkZ << 4) + rand.nextInt(16);
        this.biome = world.getBiomeGenForCoords(x, z);
        boolean flag = this.biome == BiomeGenBase.swampland && rand.nextFloat() < 0.35f;
        boolean bl = flag2 = this.biome == BiomeGenBase.savanna && rand.nextFloat() < 0.35f;
        AbstractZeldaSong abstractZeldaSong = flag ? ZeldaSongs.songSoaring : (this.song = flag2 ? ZeldaSongs.songSun : null);
        if (this.song == null && this.biome != null && this.biome.biomeName != null) {
            flag = allowedBiomes.contains(this.biome.biomeName);
        }
        if (flag && this.generate2(rand, x, z)) {
            this.onPillarPlaced(chunkX, chunkZ);
        }
        this.song = null;
    }

    private boolean generate2(Random rand, int x, int z) {
        int y = this.worldObj.getHeightValue(x, z) - 1;
        if (rand.nextFloat() < rand.nextFloat() * 0.2f && this.canGenerateAt(this.worldObj, x, y, z)) {
            this.doGenerate(this.worldObj, rand, x, y, z);
            return true;
        }
        return false;
    }

    @Override
    public String getTagName() {
        return "zssPillars";
    }

    private void onPillarPlaced(int chunkX, int chunkZ) {
        this.structureMap.put(ChunkCoordIntPair.chunkXZ2Int((int)chunkX, (int)chunkZ), this.song);
        NBTTagCompound compound = new NBTTagCompound();
        compound.setString("song", this.song == null ? "NULL" : this.song.getUnlocalizedName());
        this.addRoomTag(compound, chunkX, chunkZ);
    }

    @Override
    protected void translateNbtIntoMap(NBTTagCompound compound) {
        if (compound.hasKey("chunkX") && compound.hasKey("chunkZ") && compound.hasKey("song")) {
            int i = compound.getInteger("chunkX");
            int j = compound.getInteger("chunkZ");
            AbstractZeldaSong song = ZeldaSongs.getSongByName(compound.getString("song"));
            this.structureMap.put(ChunkCoordIntPair.chunkXZ2Int((int)i, (int)j), song);
        } else {
            ZSSMain.logger.warn("Failed to translate Song Pillar NBT compound into structure map");
        }
    }

    @Override
    protected StructureBoundingBox getStructureBBAt(int x, int y, int z) {
        return null;
    }

    @Override
    public boolean areStructuresWithinRange(RoomBase room, int range) {
        return false;
    }

    private void doGenerate(World world, Random rand, int x, int y, int z) {
        int meta = 0;
        for (int i = x - 1; i <= x + 1; ++i) {
            for (int k = z - 1; k <= z + 1; ++k) {
                meta = rand.nextFloat() < 0.2f ? 1 : (rand.nextFloat() < 0.2f ? 2 : 0);
                world.setBlock(i, y, k, Blocks.stonebrick, meta, 2);
            }
        }
        world.setBlock(x, y, z + 2, Blocks.stonebrick, rand.nextFloat() < 0.4f ? 1 : 0, 2);
        world.setBlock(x, y, z - 2, Blocks.stonebrick, rand.nextFloat() < 0.4f ? 1 : 0, 2);
        world.setBlock(x + 2, y, z, Blocks.stonebrick, rand.nextFloat() < 0.4f ? 1 : 0, 2);
        world.setBlock(x - 2, y, z, Blocks.stonebrick, rand.nextFloat() < 0.4f ? 1 : 0, 2);
        if (this.song == null) {
            if (world.isSideSolid(x + 2, y, z + 2, ForgeDirection.UP) && rand.nextFloat() < 0.35f) {
                StructureGenUtils.setBlockIfReplaceable(world, x + 2, y + 1, z + 2, Blocks.stonebrick, 3);
            }
            if (world.isSideSolid(x - 2, y, z + 2, ForgeDirection.UP) && rand.nextFloat() < 0.35f) {
                StructureGenUtils.setBlockIfReplaceable(world, x - 2, y + 1, z + 2, Blocks.stonebrick, 3);
            }
            if (world.isSideSolid(x + 2, y, z - 2, ForgeDirection.UP) && rand.nextFloat() < 0.35f) {
                StructureGenUtils.setBlockIfReplaceable(world, x + 2, y + 1, z - 2, Blocks.stonebrick, 3);
            }
            if (world.isSideSolid(x - 2, y, z - 2, ForgeDirection.UP) && rand.nextFloat() < 0.35f) {
                StructureGenUtils.setBlockIfReplaceable(world, x - 2, y + 1, z - 2, Blocks.stonebrick, 3);
            }
            world.setBlock(x, y + 1, z, Blocks.stonebrick, 2, 2);
            world.setBlock(x, y + 2, z, Blocks.stonebrick, 1, 2);
            if (rand.nextFloat() < 0.5f) {
                world.setBlock(x, y + 3, z, Blocks.stonebrick, 1, 2);
                world.setBlock(x, y + 4, z, Blocks.stonebrick, 1, 2);
                if (rand.nextFloat() < 0.5f) {
                    world.setBlock(x + 1, y + 4, z, Blocks.stone_brick_stairs, 5, 2);
                }
                if (rand.nextFloat() < 0.5f) {
                    world.setBlock(x - 1, y + 4, z, Blocks.stone_brick_stairs, 4, 2);
                }
                if (rand.nextFloat() < 0.5f) {
                    world.setBlock(x, y + 4, z + 1, Blocks.stone_brick_stairs, 7, 2);
                }
                if (rand.nextFloat() < 0.5f) {
                    world.setBlock(x, y + 4, z - 1, Blocks.stone_brick_stairs, 6, 2);
                }
            }
        } else {
            if (world.isSideSolid(x + 2, y, z + 2, ForgeDirection.UP)) {
                StructureGenUtils.setBlockIfReplaceable(world, x + 2, y + 1, z + 2, Blocks.stonebrick, 3);
            }
            if (world.isSideSolid(x - 2, y, z + 2, ForgeDirection.UP)) {
                StructureGenUtils.setBlockIfReplaceable(world, x - 2, y + 1, z + 2, Blocks.stonebrick, 3);
            }
            if (world.isSideSolid(x + 2, y, z - 2, ForgeDirection.UP)) {
                StructureGenUtils.setBlockIfReplaceable(world, x + 2, y + 1, z - 2, Blocks.stonebrick, 3);
            }
            if (world.isSideSolid(x - 2, y, z - 2, ForgeDirection.UP)) {
                StructureGenUtils.setBlockIfReplaceable(world, x - 2, y + 1, z - 2, Blocks.stonebrick, 3);
            }
            world.setBlock(x, y + 1, z, Blocks.stonebrick, 2, 2);
            world.setBlock(x, y + 2, z, Blocks.stonebrick, 1, 2);
            world.setBlock(x, y + 3, z, Blocks.stonebrick, 1, 2);
            world.setBlock(x, y + 4, z, ZSSBlocks.secretStone, 3, 2);
            world.setBlock(x + 1, y + 4, z, Blocks.stone_brick_stairs, 5, 2);
            world.setBlock(x - 1, y + 4, z, Blocks.stone_brick_stairs, 4, 2);
            world.setBlock(x, y + 4, z + 1, Blocks.stone_brick_stairs, 7, 2);
            world.setBlock(x, y + 4, z - 1, Blocks.stone_brick_stairs, 6, 2);
            world.setBlock(x, y + 5, z, ZSSBlocks.inscription, 0, 2);
            TileEntity te = world.getTileEntity(x, y + 5, z);
            if (te instanceof TileEntityInscription) {
                ((TileEntityInscription)te).setSong(this.song);
            }
        }
    }

    private boolean canGenerateAt(World world, int x, int y, int z) {
        Block block = world.getBlock(x, y, z);
        for (int i = x - 1; i <= x + 1; ++i) {
            for (int j = y - 1; j <= y; ++j) {
                for (int k = z - 1; k <= z + 1; ++k) {
                    Block block2 = world.getBlock(i, j, k);
                    if (block2 instanceof IDungeonBlock || world.getBlock(i, j + 4, k) instanceof IDungeonBlock) {
                        return false;
                    }
                    if (j < y) {
                        if (block2.getMaterial().isSolid() && block2.getMaterial() != Material.leaves) continue;
                        return false;
                    }
                    if (!block2.getMaterial().isSolid()) continue;
                    if (!block.getMaterial().isSolid()) {
                        block = block2;
                        continue;
                    }
                    if (block == block2) continue;
                    return false;
                }
            }
        }
        int min = this.song == null ? Config.getBrokenPillarMin() : Config.getSongPillarMin();
        int d = this.findNearestPillar(world, x, z, min / 4);
        if (d < 0) {
            return true;
        }
        float f = 0.75f - (float)(min - d) / (float)min;
        return world.rand.nextFloat() < f;
    }

    private int findNearestPillar(World world, int x, int z, int min) {
        int d1 = -1;
        double d2 = 0.0;
        z >>= 4;
        boolean flag = this.song != null;
        boolean cont = true;
        for (int i = (x >>= 4) - this.range; cont && i <= x + this.range; ++i) {
            for (int k = z - this.range; cont && k <= z + this.range; ++k) {
                this.chunk = ChunkCoordIntPair.chunkXZ2Int((int)i, (int)k);
                if (!this.structureMap.containsKey(this.chunk)) continue;
                AbstractZeldaSong zs = (AbstractZeldaSong)this.structureMap.get(this.chunk);
                d2 = Math.ceil(Math.sqrt((i - x) * (i - x) + (k - z) * (k - z)));
                if (flag && zs != null) {
                    flag = false;
                }
                if (zs == null) {
                    d2 *= 3.0;
                }
                if (this.song == null && world.rand.nextFloat() < 0.35f) {
                    d2 *= 2.0;
                }
                if (d2 < (double)d1 || d1 < 0) {
                    d1 = (int)d2;
                }
                cont = d1 > min;
            }
        }
        return flag && d1 > min / 2 && world.rand.nextFloat() < 0.2f ? -1 : d1;
    }
}

