/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.gen.structure;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.block.tileentity.TileEntityPedestal;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.StructureGenUtils;
import zeldaswordskills.world.gen.structure.ZSSMapGenBase;

public abstract class RoomBase {
    public static final int SOUTH = 0;
    public static final int WEST = 1;
    public static final int NORTH = 2;
    public static final int EAST = 3;
    public boolean submerged = false;
    public boolean inLava = false;
    public boolean inOcean = false;
    public boolean inMountain = false;
    public boolean inNether = false;
    public boolean isLocked = false;
    protected StructureBoundingBox bBox;
    public final int chunkX;
    public final int chunkZ;
    protected final Block blockRequired;
    protected int metadata = 0;
    protected static final Set<Block> replaceBlocks = new HashSet<Block>();
    protected int validations = 0;
    protected static final int NUM_VALIDATIONS = 8;

    public final StructureBoundingBox getBoundingBox() {
        return this.bBox;
    }

    public final int getArea() {
        return this.bBox.getXSize() * this.bBox.getZSize();
    }

    public final int getVolume() {
        return this.bBox.getXSize() * this.bBox.getYSize() * this.bBox.getZSize();
    }

    public abstract boolean generate(ZSSMapGenBase var1, World var2, Random var3, int var4, int var5, int var6);

    protected abstract void decorateDungeon(World var1, Random var2);

    protected abstract void placeDungeonCore(World var1);

    protected void placePedestal(World world, int offsetY) {
        StructureGenUtils.setBlockAtPosition(world, this.bBox, this.bBox.getXSize() / 2, offsetY, this.bBox.getZSize() / 2, ZSSBlocks.pedestal, 0);
        int x = StructureGenUtils.getXWithOffset(this.bBox, this.bBox.getXSize() / 2, this.bBox.getZSize() / 2);
        int y = StructureGenUtils.getYWithOffset(this.bBox, offsetY);
        int z = StructureGenUtils.getZWithOffset(this.bBox, this.bBox.getXSize() / 2, this.bBox.getZSize() / 2);
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityPedestal) {
            ((TileEntityPedestal)te).setSword(new ItemStack(ZSSItems.swordMaster), null);
        }
    }

    public RoomBase(int chunkX, int chunkZ, int size, int maxHeight, Block blockRequired) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.blockRequired = blockRequired;
        this.bBox = new StructureBoundingBox(1, 1, 1, Math.max(size, 3), MathHelper.clamp_int((int)size, (int)3, (int)maxHeight), Math.max(size, 3));
    }

    protected boolean canGenerate(World world) {
        int failedAmount = 0;
        int maxFail = this.bBox.getXSize() * this.bBox.getZSize() / 2;
        for (int i = this.bBox.minX; i <= this.bBox.maxX; ++i) {
            for (int j = this.bBox.minY; j <= this.bBox.maxY; ++j) {
                for (int k = this.bBox.minZ; k <= this.bBox.maxZ; ++k) {
                    Block block = world.getBlock(i, j, k);
                    if (this.canReplaceBlockAt(j, block)) continue;
                    if (block == ZSSBlocks.secretStone || Config.avoidModBlocks() && Block.getIdFromBlock((Block)block) > 255) {
                        return false;
                    }
                    if (++failedAmount <= maxFail) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected void doStandardRoomGen(World world, Random rand) {
        StructureGenUtils.fillWithBlocks(world, this.bBox, 0, this.bBox.getXSize(), 0, this.bBox.getYSize(), 0, this.bBox.getZSize(), ZSSBlocks.secretStone, this.getMetadata());
        this.genSubmerged(world);
        this.generateAir(world);
        this.decorateDungeon(world, rand);
    }

    protected boolean isWellHidden(World world) {
        int difficulty = Config.getMainDungeonDifficulty();
        if (this.inOcean) {
            return true;
        }
        Material material = !this.inNether && StructureGenUtils.getNumBlocksOfMaterial(world, this.bBox, Material.water, 1) > 0 ? Material.water : Material.air;
        int above = StructureGenUtils.getNumBlocksOfMaterial(world, this.bBox, material, 1);
        int below = StructureGenUtils.getNumBlocksOfMaterial(world, this.bBox, material, -1);
        if (this.inNether) {
            return world.rand.nextFloat() < 0.35f - (float)difficulty * 0.1f || (difficulty != 3 || above + below < 4) && StructureGenUtils.getNumBlocksOfMaterialInArea(world, this.bBox, material, 1) < this.getArea() / (difficulty + 1);
        }
        return world.rand.nextFloat() < 0.35f - (float)difficulty * 0.1f || above + below < 5 - difficulty;
    }

    protected boolean canReplaceBlockAt(World world, int x, int y, int z) {
        return this.canReplaceBlockAt(y, world.getBlock(x, y, z));
    }

    protected boolean canReplaceBlockAt(int y, Block block) {
        if (block == null) {
            return false;
        }
        boolean flag1 = this.submerged && !this.inLava && block.getMaterial() == Material.water;
        boolean flag2 = this.inNether && block.getMaterial() == Material.lava;
        return replaceBlocks.contains(block) || flag1 || flag2 || block.getMaterial().isLiquid() && y < this.bBox.maxY - 2;
    }

    protected int getMetadata() {
        return this.metadata + (this.isLocked ? 8 : 0);
    }

    protected abstract void setMetadata(World var1, int var2, int var3);

    protected void generateAir(World world) {
        if (!this.inOcean) {
            StructureGenUtils.fillWithBlocks(world, this.bBox, 1, this.bBox.getXSize() - 1, this.submerged ? (this.inLava || this.isLocked ? 2 : 3) : 1, this.bBox.getYSize() - 1, 1, this.bBox.getZSize() - 1, Blocks.air, 0);
        }
    }

    protected void genSubmerged(World world) {
        if (this.submerged && this.bBox.getXSize() > 3) {
            int fillTo = this.inLava ? 2 : (this.inOcean ? this.bBox.getYSize() - 1 : 3);
            Block block = this.inLava ? Blocks.lava : Blocks.water;
            StructureGenUtils.fillWithBlocks(world, this.bBox, 1, this.bBox.getXSize() - 1, 1, fillTo, 1, this.bBox.getZSize() - 1, block, 0);
        }
    }

    protected boolean placeInOcean(World world, boolean sink) {
        this.bBox.offset(0, 4, 0);
        int x = this.bBox.getCenterX();
        int z = this.bBox.getCenterZ();
        boolean flag = world.getBiomeGenForCoords((int)x, (int)z).biomeName.toLowerCase().contains("ocean");
        if (flag && !this.inLava && world.getBlock(x, this.bBox.maxY, z).getMaterial() == Material.water) {
            for (int count = 0; this.bBox.minY > 16 && count < 8 && world.getBlock(x, this.bBox.minY, z).getMaterial() == Material.water; ++count) {
                this.bBox.offset(0, -1, 0);
            }
            if (world.getBlock(x, this.bBox.minY, z).getMaterial() != Material.water) {
                this.inOcean = true;
                StructureGenUtils.adjustCornersForMaterial(world, this.bBox, Material.water, 6, false, false);
                if (sink) {
                    int diff = Config.getMainDungeonDifficulty();
                    int adj = 2 - diff;
                    if (world.rand.nextFloat() > (float)diff * 0.25f) {
                        adj = diff == 3 ? ++adj : (adj += world.rand.nextFloat() < 0.5f ? 1 : -1);
                    }
                    this.bBox.offset(0, -(this.bBox.getYSize() - adj), 0);
                }
                return true;
            }
        }
        return false;
    }

    protected boolean placeInNether(World world) {
        while (this.bBox.minY > 8 && world.getBlock(this.bBox.getCenterX(), this.bBox.minY, this.bBox.getCenterZ()).getMaterial() == Material.lava) {
            this.bBox.offset(0, -1, 0);
        }
        StructureGenUtils.adjustCornersForMaterial(world, this.bBox, Material.lava, 4, false, false);
        return world.getBlock(this.bBox.getCenterX(), this.bBox.minY, this.bBox.getCenterZ()) != ZSSBlocks.secretStone;
    }

    protected boolean validateTopLayer(World world) {
        int invalidBlocks = 0;
        int area = this.getArea();
        ++this.validations;
        for (int i = this.bBox.minX; i <= this.bBox.maxX; ++i) {
            for (int k = this.bBox.minZ; k <= this.bBox.maxZ; ++k) {
                if (this.validations > 8 || this.bBox.minY < 5) {
                    return false;
                }
                Block block = world.getBlock(i, this.bBox.maxY, k);
                if (block != null && block.getMaterial().isLiquid()) {
                    this.submerged = true;
                    this.inLava = block == Blocks.lava;
                    this.bBox.offset(0, -1, 0);
                    return this.inNether && this.bBox.maxY < 48 || this.validateTopLayer(world);
                }
                if (block == this.blockRequired || ++invalidBlocks <= area / 2) continue;
                this.bBox.offset(0, -1, 0);
                return this.validateTopLayer(world);
            }
        }
        return true;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.setTag("BB", (NBTBase)this.bBox.func_151535_h());
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.bBox = new StructureBoundingBox(compound.getIntArray("BB"));
    }

    static {
        replaceBlocks.add(Blocks.cobblestone);
        replaceBlocks.add(Blocks.stone);
        replaceBlocks.add(Blocks.dirt);
        replaceBlocks.add((Block)Blocks.grass);
        replaceBlocks.add(Blocks.gravel);
        replaceBlocks.add(Blocks.netherrack);
        replaceBlocks.add((Block)Blocks.sand);
        replaceBlocks.add(Blocks.sandstone);
        replaceBlocks.add(Blocks.snow);
    }
}

