/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.gen.structure;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.block.BlockSecretStone;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.BossType;
import zeldaswordskills.util.StructureGenUtils;
import zeldaswordskills.world.gen.DungeonLootLists;
import zeldaswordskills.world.gen.structure.RoomBase;
import zeldaswordskills.world.gen.structure.ZSSMapGenBase;

public class RoomBoss
extends RoomBase {
    public static final int[] facingToOrientation = new int[]{3, 4, 2, 5};
    private int doorSide = -1;
    private final BossType type;

    public RoomBoss(BossType bossType, int chunkX, int chunkZ, Random rand, int size, Block blockRequired) {
        super(chunkX, chunkZ, Math.max(size, 9), rand.nextInt(4) + 7, blockRequired);
        this.isLocked = true;
        this.type = bossType;
    }

    public BossType getBossType() {
        return this.type;
    }

    @Override
    public boolean generate(ZSSMapGenBase mapGen, World world, Random rand, int x, int y, int z) {
        if (this.initDungeon(world, x, y, z) && this.canGenerate(world)) {
            this.doStandardRoomGen(world, rand);
            return true;
        }
        return false;
    }

    protected boolean initDungeon(World world, int x, int y, int z) {
        this.bBox.offset(x, y, z);
        if (this.type == null || y < this.bBox.getYSize() || y > (world.provider.isHellWorld ? 96 : 160)) {
            return false;
        }
        if (world.provider.isHellWorld) {
            this.inNether = true;
            if (!this.placeInNether(world)) {
                return false;
            }
        }
        switch (this.type) {
            case HELL: {
                this.doDefaultAdjustments(world);
                if (!(world.rand.nextFloat() < 0.75f)) break;
                this.submerged = true;
                this.inLava = true;
                break;
            }
            case OCEAN: {
                if (this.placeInOcean(world, false)) break;
                return false;
            }
            case SWAMP: {
                this.submerged = true;
                this.doDefaultAdjustments(world);
                this.bBox.offset(0, -1, 0);
                break;
            }
            default: {
                this.doDefaultAdjustments(world);
            }
        }
        if (this.submerged) {
            --this.bBox.minY;
        }
        this.determineDoorSide(world);
        this.setMetadata(world, x, z);
        boolean flag = StructureGenUtils.getAverageDistanceToGround(world, this.bBox, 6) < 4;
        return this.doorSide != -1 && flag && (this.submerged || !this.isWaterAroundOrUnder(world));
    }

    private void doDefaultAdjustments(World world) {
        StructureGenUtils.adjustCornersForMaterial(world, this.bBox, Material.ground, 4, false, true);
        StructureGenUtils.adjustCornersForMaterial(world, this.bBox, Material.grass, 4, false, true);
        StructureGenUtils.adjustCornersForMaterial(world, this.bBox, Material.sand, 4, false, true);
        StructureGenUtils.adjustCornersForMaterial(world, this.bBox, Material.air, 4, false, false);
        if (this.type != BossType.SWAMP) {
            StructureGenUtils.adjustCornersForMaterial(world, this.bBox, Material.water, 4, false, false);
        }
    }

    protected boolean isWaterAroundOrUnder(World world) {
        if (StructureGenUtils.getNumBlocksOfMaterial(world, this.bBox, Material.water, -1) > 1) {
            return true;
        }
        if (StructureGenUtils.getNumBlocksOfMaterialInArea(world, Material.water, this.bBox.minX - 1, this.bBox.minX, this.bBox.minY, this.bBox.minY + 2, this.bBox.minZ, this.bBox.maxZ) > 2) {
            return true;
        }
        if (StructureGenUtils.getNumBlocksOfMaterialInArea(world, Material.water, this.bBox.maxX + 1, this.bBox.maxX + 2, this.bBox.minY, this.bBox.minY + 2, this.bBox.minZ, this.bBox.maxZ) > 2) {
            return true;
        }
        if (StructureGenUtils.getNumBlocksOfMaterialInArea(world, Material.water, this.bBox.minX, this.bBox.maxX, this.bBox.minY, this.bBox.minY + 2, this.bBox.minZ - 1, this.bBox.minZ) > 2) {
            return true;
        }
        return StructureGenUtils.getNumBlocksOfMaterialInArea(world, Material.water, this.bBox.minX, this.bBox.maxX, this.bBox.minY, this.bBox.minY + 2, this.bBox.maxZ + 1, this.bBox.maxZ + 2) > 2;
    }

    @Override
    protected void setMetadata(World world, int x, int z) {
        this.metadata = this.type.metadata;
    }

    @Override
    protected void decorateDungeon(World world, Random rand) {
        int meta = this.getMetadata();
        StructureGenUtils.fillDown(world, this.bBox, BlockSecretStone.getBlockFromMeta(meta), 0);
        this.placeDoor(world);
        this.placeDungeonCore(world);
        this.placePillars(world, meta);
        this.placeCenterPiece(world, rand, meta);
        this.placeChandelier(world);
        this.placeParapet(world, meta);
        this.placeLedge(world, rand, meta);
        this.placeChestOnRoof(world, rand);
        this.placeInvisibleChest(world, rand, rand.nextInt(3));
        this.placeJars(world, rand, rand.nextInt(5), false);
        this.placeJars(world, rand, rand.nextInt(5) + 3, true);
        this.placeWindows(world);
    }

    @Override
    protected void placeDungeonCore(World world) {
        StructureGenUtils.setBlockAtPosition(world, this.bBox, this.bBox.getXSize() / 2, 0, this.bBox.getZSize() / 2, ZSSBlocks.dungeonCore, this.getMetadata() | 8);
        int x = StructureGenUtils.getXWithOffset(this.bBox, this.bBox.getXSize() / 2, this.bBox.getZSize() / 2);
        int y = StructureGenUtils.getYWithOffset(this.bBox, 0);
        int z = StructureGenUtils.getZWithOffset(this.bBox, this.bBox.getXSize() / 2, this.bBox.getZSize() / 2);
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityDungeonCore) {
            TileEntityDungeonCore core = (TileEntityDungeonCore)te;
            core.setDungeonBoundingBox(this.bBox);
            core.setBossType(this.type);
            core.setDoor(ZSSBlocks.doorLocked, this.type.ordinal(), this.doorSide);
        }
    }

    protected void determineDoorSide(World world) {
        int x = this.bBox.getCenterX();
        int y = this.bBox.minY + 1;
        int z = this.bBox.getCenterZ();
        this.doorSide = world.rand.nextInt(4);
        for (int i = 0; i < 4; ++i) {
            int dx = x;
            int dz = z;
            switch (this.doorSide) {
                case 0: {
                    dz = this.bBox.maxZ + 1;
                    break;
                }
                case 2: {
                    dz = this.bBox.minZ - 1;
                    break;
                }
                case 3: {
                    dx = this.bBox.maxX + 1;
                    break;
                }
                case 1: {
                    dx = this.bBox.maxX - 1;
                    break;
                }
                default: {
                    ZSSMain.logger.warn(String.format("Invalid boss door side %d at %d/%d/%d", this.doorSide, x, y, z));
                }
            }
            Block block1 = world.getBlock(dx, y, dz);
            Block block2 = world.getBlock(dx, y + 1, dz);
            if (!block1.func_149730_j() && !block2.func_149730_j()) {
                return;
            }
            this.doorSide = this.doorSide == 3 ? 0 : this.doorSide + 1;
        }
        this.doorSide = -1;
    }

    protected void placeDoor(World world) {
        int x = this.bBox.getCenterX();
        int y = this.bBox.minY + (this.submerged ? 2 : 1);
        int z = this.bBox.getCenterZ();
        switch (this.doorSide) {
            case 0: {
                z = this.bBox.maxZ;
                break;
            }
            case 2: {
                z = this.bBox.minZ;
                break;
            }
            case 3: {
                x = this.bBox.maxX;
                break;
            }
            case 1: {
                x = this.bBox.minX;
                break;
            }
            default: {
                ZSSMain.logger.warn("Placing Boss door with invalid door side");
            }
        }
        world.setBlock(x, y, z, ZSSBlocks.doorLocked, this.type.ordinal() & 0xFFFFFFF7, 2);
        world.setBlock(x, y + 1, z, ZSSBlocks.doorLocked, this.type.ordinal() | 8, 2);
    }

    protected void placeCenterPiece(World world, Random rand, int meta) {
        int minX = this.bBox.getXSize() / 2 - 1;
        int minY = 1;
        int minZ = this.bBox.getZSize() / 2 - 1;
        if (this.submerged) {
            StructureGenUtils.fillWithBlocks(world, this.bBox, minX, minX + 3, minY, minY + 1, minZ, minZ + 3, BlockSecretStone.getBlockFromMeta(this.getMetadata()), 0);
            ++minY;
        }
        if (!this.inOcean) {
            StructureGenUtils.fillWithBlocks(world, this.bBox, minX, minX + 3, minY, minY + 1, minZ, minZ + 3, (Block)Blocks.stone_slab, BlockSecretStone.getSlabTypeFromMeta(meta));
        }
        world.setBlock(this.bBox.getCenterX(), this.bBox.minY + (this.submerged && !this.inOcean ? 2 : 1), this.bBox.getCenterZ(), this.type == BossType.TAIGA ? Blocks.quartz_block : BlockSecretStone.getBlockFromMeta(this.getMetadata()), 0, 2);
        this.placeHinderBlock(world);
        boolean hasChest = false;
        switch (this.type) {
            case OCEAN: 
            case DESERT: 
            case MOUNTAIN: {
                this.placeChest(world, rand, true);
                hasChest = true;
                break;
            }
            case FOREST: {
                if (rand.nextFloat() < Config.getMasterSwordChance()) {
                    this.placePedestal(world, minY + 1);
                    break;
                }
                this.placeChest(world, rand, true);
                hasChest = !(rand.nextFloat() < 2.0f * Config.getDoubleChestChance());
                break;
            }
            case HELL: {
                this.placeFlame(world, 1);
                break;
            }
            case SWAMP: {
                this.placeFlame(world, 2);
                break;
            }
            case TAIGA: {
                this.placeFlame(world, 4);
                break;
            }
        }
        if (!hasChest) {
            this.placeChest(world, rand, false);
        }
    }

    protected void placeChandelier(World world) {
        if (this.bBox.getYSize() > 7) {
            int x = this.bBox.getCenterX();
            int y = this.bBox.maxY - 1;
            int z = this.bBox.getCenterZ();
            switch (this.type) {
                case OCEAN: {
                    world.setBlock(x + 1, y, z + 1, Blocks.glowstone, 0, 2);
                    world.setBlock(x + 1, y, z - 1, Blocks.glowstone, 0, 2);
                    world.setBlock(x - 1, y, z + 1, Blocks.glowstone, 0, 2);
                    world.setBlock(x - 1, y, z - 1, Blocks.glowstone, 0, 2);
                    world.setBlock(x, y, z, Blocks.glowstone, 0, 2);
                    break;
                }
                case SWAMP: {
                    world.setBlock(this.bBox.minX + 1, y, this.bBox.minZ + 1, Blocks.glowstone, 0, 2);
                    world.setBlock(this.bBox.minX + 1, y, this.bBox.maxZ - 1, Blocks.glowstone, 0, 2);
                    world.setBlock(this.bBox.maxX - 1, y, this.bBox.minZ + 1, Blocks.glowstone, 0, 2);
                    world.setBlock(this.bBox.maxX - 1, y, this.bBox.maxZ - 1, Blocks.glowstone, 0, 2);
                    break;
                }
                default: {
                    world.setBlock(x, y, z, Blocks.fence, 0, 2);
                    world.setBlock(x + 1, y, z, Blocks.fence, 0, 2);
                    world.setBlock(x + 1, y, z, Blocks.fence, 0, 2);
                    world.setBlock(x, y, z + 1, Blocks.fence, 0, 2);
                    world.setBlock(x, y, z - 1, Blocks.fence, 0, 2);
                    world.setBlock(x + 1, y, z + 1, Blocks.fence, 0, 2);
                    world.setBlock(x + 1, y, z - 1, Blocks.fence, 0, 2);
                    world.setBlock(x - 1, y, z + 1, Blocks.fence, 0, 2);
                    world.setBlock(x - 1, y, z - 1, Blocks.fence, 0, 2);
                    world.setBlock(x, y - 1, z, Blocks.fence, 0, 2);
                    world.setBlock(x + 1, y - 1, z + 1, Blocks.glowstone, 0, 2);
                    world.setBlock(x + 1, y - 1, z - 1, Blocks.glowstone, 0, 2);
                    world.setBlock(x - 1, y - 1, z + 1, Blocks.glowstone, 0, 2);
                    world.setBlock(x - 1, y - 1, z - 1, Blocks.glowstone, 0, 2);
                    world.setBlock(x, y - 2, z, Blocks.glowstone, 0, 2);
                }
            }
        }
    }

    protected void placeChest(World world, Random rand, boolean inCenter) {
        int x = inCenter ? this.bBox.getCenterX() : (rand.nextFloat() < 0.5f ? this.bBox.minX + 1 : this.bBox.maxX - 1);
        int y = this.bBox.minY + (inCenter ? 2 : 1) + (this.submerged && !this.inOcean ? 1 : 0);
        int z = inCenter ? this.bBox.getCenterZ() : (rand.nextFloat() < 0.5f ? this.bBox.minZ + 1 : this.bBox.maxZ - 1);
        BlockChest block = inCenter ? Blocks.chest : ZSSBlocks.chestLocked;
        world.setBlock(x, y, z, (Block)block);
        if (inCenter) {
            world.setBlockMetadataWithNotify(x, y, z, facingToOrientation[this.doorSide], 2);
        } else if (this.submerged && !this.inOcean) {
            world.setBlock(x, y - 1, z, BlockSecretStone.getBlockFromMeta(this.getMetadata()), 0, 2);
        }
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof IInventory) {
            DungeonLootLists.generateBossChestContents(world, rand, (IInventory)te, this);
        }
    }

    protected void placeChestOnRoof(World world, Random rand) {
        if (rand.nextFloat() < 0.1f) {
            int x = rand.nextFloat() < 0.5f ? this.bBox.minX : this.bBox.maxX;
            int y = this.bBox.maxY + 1;
            int z = rand.nextFloat() < 0.5f ? this.bBox.minZ : this.bBox.maxZ;
            this.placeChestAt(world, x, y, z, (Block)Blocks.chest, rand, true);
        }
    }

    protected void placeInvisibleChest(World world, Random rand, int n) {
        for (int i = 0; i < n; ++i) {
            int z;
            int y;
            int x;
            if (!(rand.nextFloat() < Config.getDoubleChestChance()) || !this.bBox.isVecInside(x = this.bBox.minX + rand.nextInt(this.bBox.getXSize()), (y = rand.nextFloat() < 0.5f ? this.bBox.minY + 1 : this.bBox.maxY + 1) - 1, z = this.bBox.minZ + rand.nextInt(this.bBox.getZSize()))) continue;
            this.placeChestAt(world, x, y, z, ZSSBlocks.chestInvisible, rand, true);
        }
    }

    protected void placeChestAt(World world, int x, int y, int z, Block chest, Random rand, boolean goodLoot) {
        if (world.isAirBlock(x, y, z)) {
            world.setBlock(x, y, z, chest);
            TileEntity te = world.getTileEntity(x, y, z);
            if (te instanceof IInventory) {
                DungeonLootLists.generateChestContents(world, rand, (IInventory)te, this, goodLoot);
            }
        }
    }

    protected void placeFlame(World world, int meta) {
        world.setBlock(this.bBox.getCenterX(), this.bBox.minY + (this.submerged ? 3 : 2), this.bBox.getCenterZ(), ZSSBlocks.sacredFlame, meta, 2);
    }

    protected void placeHinderBlock(World world) {
        int x = this.bBox.getCenterX() + (this.doorSide == 3 ? 1 : (this.doorSide == 1 ? -1 : 0));
        int y = this.bBox.minY + (this.submerged && !this.inOcean ? 3 : 2);
        int z = this.bBox.getCenterZ() + (this.doorSide == 0 ? 1 : (this.doorSide == 2 ? -1 : 0));
        world.setBlock(x, y, z, ZSSBlocks.secretStone, this.getMetadata(), 2);
    }

    protected void placeJars(World world, Random rand, int n, boolean onRoof) {
        for (int i = 0; i < n; ++i) {
            int z;
            int y;
            int x = this.bBox.minX + rand.nextInt(this.bBox.getXSize());
            Material m = world.getBlock(x, y = (onRoof ? this.bBox.maxY : this.bBox.minY) + 1, z = this.bBox.minZ + rand.nextInt(this.bBox.getZSize())).getMaterial();
            if (m != Material.air && !m.isLiquid()) continue;
            world.setBlock(x, y, z, ZSSBlocks.ceramicJar);
        }
    }

    protected void placeLedge(World world, Random rand, int meta) {
        if (this.type == BossType.OCEAN || this.type == BossType.MOUNTAIN) {
            return;
        }
        if (this.bBox.getYSize() > 7) {
            float f = rand.nextFloat();
            float f2 = this.type == BossType.HELL ? 0.75f : 0.5f;
            if (f < f2) {
                int y = this.bBox.getCenterY();
                Block block = BlockSecretStone.getBlockFromMeta(meta);
                StructureGenUtils.fillWithoutReplace(world, this.bBox.minX + 1, this.bBox.minX + 2, y, y + 1, this.bBox.minZ + 1, this.bBox.maxZ, block, 0, 3);
                StructureGenUtils.fillWithoutReplace(world, this.bBox.maxX - 1, this.bBox.maxX, y, y + 1, this.bBox.minZ + 1, this.bBox.maxZ, block, 0, 3);
                StructureGenUtils.fillWithoutReplace(world, this.bBox.minX + 2, this.bBox.maxX - 1, y, y + 1, this.bBox.minZ + 1, this.bBox.minZ + 2, block, 0, 3);
                StructureGenUtils.fillWithoutReplace(world, this.bBox.minX + 2, this.bBox.maxX - 1, y, y + 1, this.bBox.maxZ - 1, this.bBox.maxZ, block, 0, 3);
            }
        }
    }

    protected void placeParapet(World world, int meta) {
        int i;
        int x1 = this.bBox.minX - 1;
        int x2 = this.bBox.maxX + 1;
        int z1 = this.bBox.minZ - 1;
        int z2 = this.bBox.maxZ + 1;
        int y = this.bBox.maxY;
        Block block = BlockSecretStone.getBlockFromMeta(meta);
        Block stairs = BlockSecretStone.getStairsFromMeta(meta);
        for (i = x1; i <= x2; ++i) {
            world.setBlock(i, y, z1, stairs, 6, 3);
            world.setBlock(i, y + 1, z1, block, 0, 2);
            world.setBlock(i, y, z2, stairs, 7, 3);
            world.setBlock(i, y + 1, z2, block, 0, 2);
            if (i % 2 != 0) continue;
            world.setBlock(i, y + 2, z1, block, 0, 2);
            world.setBlock(i, y + 2, z2, block, 0, 2);
        }
        for (i = z1; i <= z2; ++i) {
            world.setBlock(x1, y, i, stairs, 4, 3);
            world.setBlock(x1, y + 1, i, block, 0, 2);
            world.setBlock(x2, y, i, stairs, 5, 3);
            world.setBlock(x2, y + 1, i, block, 0, 2);
            if (i % 2 != 0) continue;
            if (world.getBlock(x1 + 1, y + 2, i) != block) {
                world.setBlock(x1, y + 2, i, block, 0, 2);
            }
            if (world.getBlock(x2 - 1, y + 2, i) == block) continue;
            world.setBlock(x2, y + 2, i, block, 0, 2);
        }
    }

    protected void placePillars(World world, int meta) {
        if (this.type == BossType.DESERT || this.type == BossType.SWAMP || this.type == BossType.MOUNTAIN) {
            return;
        }
        if (world.rand.nextFloat() < (float)this.bBox.getXSize() * 0.06f) {
            int offset = this.bBox.getXSize() < 11 ? 2 : 3;
            int x1 = (this.bBox.getXSize() < 11 ? this.bBox.getCenterX() : this.bBox.minX) + offset;
            int x2 = (this.bBox.getXSize() < 11 ? this.bBox.getCenterX() : this.bBox.maxX) - offset;
            int z1 = (this.bBox.getZSize() < 11 ? this.bBox.getCenterZ() : this.bBox.minZ) + offset;
            int z2 = (this.bBox.getZSize() < 11 ? this.bBox.getCenterZ() : this.bBox.maxZ) - offset;
            Block block = BlockSecretStone.getBlockFromMeta(meta);
            for (int y = this.bBox.minY + 1; y < this.bBox.maxY; ++y) {
                world.setBlock(x1, y, z1, block, 0, 2);
                world.setBlock(x1, y, z2, block, 0, 2);
                world.setBlock(x2, y, z1, block, 0, 2);
                world.setBlock(x2, y, z2, block, 0, 2);
            }
            if (this.bBox.getXSize() > 10 && world.rand.nextFloat() < 0.5f) {
                this.placePillarLandings(world, block, x1, this.bBox.getCenterY(), z1, 0);
                this.placePillarLandings(world, block, x2, this.bBox.getCenterY(), z1, 1);
                this.placePillarLandings(world, block, x1, this.bBox.getCenterY(), z2, 2);
                this.placePillarLandings(world, block, x2, this.bBox.getCenterY(), z2, 3);
            }
        }
    }

    protected void placePillarLandings(World world, Block block, int x, int y, int z, int corner) {
        switch (corner % 4) {
            case 0: {
                world.setBlock(x + 1, y, z, block);
                world.setBlock(x, y, z + 1, block);
                break;
            }
            case 1: {
                world.setBlock(x - 1, y, z, block);
                world.setBlock(x, y, z + 1, block);
                break;
            }
            case 2: {
                world.setBlock(x + 1, y, z, block);
                world.setBlock(x, y, z - 1, block);
                break;
            }
            case 3: {
                world.setBlock(x - 1, y, z, block);
                world.setBlock(x, y, z - 1, block);
            }
        }
    }

    protected void placeWindows(World world) {
        if (Config.areWindowsEnabled() && world.rand.nextFloat() < (float)this.bBox.getXSize() * 0.06f) {
            int interval = this.bBox.getXSize() % 2 == 1 ? 2 : 3;
            int j = this.bBox.getCenterY() + 1;
            Block window = world.rand.nextFloat() < 0.25f ? Blocks.iron_bars : Blocks.air;
            boolean hasVines = this.type == BossType.FOREST || this.type == BossType.SWAMP;
            for (int i = this.bBox.minX + 1; i < this.bBox.maxX; ++i) {
                if (i % interval != 0) continue;
                world.setBlock(i, j, this.bBox.minZ, window, 0, 2);
                world.setBlock(i, j, this.bBox.maxZ, window, 0, 2);
                if (!hasVines) continue;
                if (world.rand.nextFloat() < 0.25f) {
                    this.placeVines(world, i, j - 1, this.bBox.minZ - 1, 1);
                }
                if (!(world.rand.nextFloat() < 0.25f)) continue;
                this.placeVines(world, i, j - 1, this.bBox.maxZ + 1, 4);
            }
            for (int k = this.bBox.minZ + 1; k < this.bBox.maxZ; ++k) {
                if (k % interval != 0) continue;
                world.setBlock(this.bBox.minX, j, k, window, 0, 2);
                world.setBlock(this.bBox.maxX, j, k, window, 0, 2);
                if (!hasVines) continue;
                if (world.rand.nextFloat() < 0.25f) {
                    this.placeVines(world, this.bBox.minX - 1, j - 1, k, 8);
                }
                if (!(world.rand.nextFloat() < 0.25f)) continue;
                this.placeVines(world, this.bBox.maxX + 1, j - 1, k, 2);
            }
        }
    }

    protected void placeVines(World world, int x, int y, int z, int meta) {
        int n = world.rand.nextInt(5) + 1;
        for (int i = 0; i < n && world.isAirBlock(x, y - i, z); ++i) {
            world.setBlock(x, y - i, z, Blocks.vine, meta, 2);
        }
    }

    @Override
    protected boolean canReplaceBlockAt(int y, Block block) {
        boolean flag1 = block != null && !block.getMaterial().blocksMovement();
        boolean flag2 = block != null && block.getMaterial() == Material.leaves;
        boolean flag3 = this.type == BossType.TAIGA && (block == Blocks.log || block == Blocks.log2 || block != null && block.getMaterial() == Material.ice);
        return block == null || flag1 || flag2 || flag3 || super.canReplaceBlockAt(y, block);
    }

    @Override
    protected boolean placeInOcean(World world, boolean sink) {
        if (this.type == BossType.OCEAN) {
            while (this.bBox.minY > 60 && world.getBlock(this.bBox.getCenterX(), this.bBox.minY, this.bBox.getCenterZ()).getMaterial() == Material.air) {
                this.bBox.offset(0, -1, 0);
            }
            while (this.bBox.minY > 16 && world.getBlock(this.bBox.getCenterX(), this.bBox.minY, this.bBox.getCenterZ()).getMaterial() == Material.water) {
                this.bBox.offset(0, -1, 0);
            }
            if (world.getBlock(this.bBox.getCenterX(), this.bBox.minY, this.bBox.getCenterZ()).getMaterial() != Material.water && world.getBlock(this.bBox.getCenterX(), this.bBox.maxY, this.bBox.getCenterZ()).getMaterial() == Material.water) {
                this.inOcean = true;
                this.submerged = true;
                StructureGenUtils.adjustCornersForMaterial(world, this.bBox, Material.water, 6, false, false);
                return true;
            }
        }
        return false;
    }
}

