/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import zeldaswordskills.CommonProxy;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.api.item.WeaponRegistry;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.command.ZSSCommands;
import zeldaswordskills.entity.ZSSEntities;
import zeldaswordskills.handler.BattlegearEvents;
import zeldaswordskills.handler.GuiHandler;
import zeldaswordskills.handler.ZSSCombatEvents;
import zeldaswordskills.handler.ZSSEntityEvents;
import zeldaswordskills.handler.ZSSEventsFML;
import zeldaswordskills.handler.ZSSItemEvents;
import zeldaswordskills.item.ItemHeroBow;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.ref.Config;
import zeldaswordskills.world.gen.AntiqueAtlasHelper;
import zeldaswordskills.world.gen.DungeonLootLists;
import zeldaswordskills.world.gen.ZSSBossDungeonGen;
import zeldaswordskills.world.gen.ZSSWorldGenEvent;
import zeldaswordskills.world.gen.feature.WorldGenGossipStones;

@Mod(modid="zeldaswordskills", name="Zelda Sword Skills", version="1.7.10-2.5.1")
public class ZSSMain {
    @Mod.Instance(value="zeldaswordskills")
    public static ZSSMain instance;
    @SidedProxy(clientSide="zeldaswordskills.ClientProxy", serverSide="zeldaswordskills.CommonProxy")
    public static CommonProxy proxy;
    public static final Logger logger;
    public static AntiqueAtlasHelper atlasHelper;
    public static boolean isAtlasEnabled;
    public static boolean isBG2Enabled;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.preInit(event);
        isAtlasEnabled = Loader.isModLoaded((String)"antiqueatlas");
        isBG2Enabled = Loader.isModLoaded((String)"battlegear2");
        ZSSBlocks.preInit();
        ZSSItems.preInit();
        ZSSEntities.preInit();
        ZSSAchievements.preInit();
        proxy.preInit();
        PacketDispatcher.preInit();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.registerRenderers();
        ZSSItems.init();
        MinecraftForge.EVENT_BUS.register((Object)new ZSSCombatEvents());
        MinecraftForge.EVENT_BUS.register((Object)new ZSSEntityEvents());
        MinecraftForge.EVENT_BUS.register((Object)new ZSSItemEvents());
        FMLCommonHandler.instance().bus().register((Object)new ZSSEventsFML());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ZSSWorldGenEvent());
        if (Config.areBossDungeonsEnabled()) {
            ZSSBossDungeonGen dungeonGen = new ZSSBossDungeonGen();
            MinecraftForge.EVENT_BUS.register((Object)dungeonGen);
            MinecraftForge.TERRAIN_GEN_BUS.register((Object)dungeonGen);
        }
        if (Config.getGossipStoneRate() > 0.0f) {
            MinecraftForge.EVENT_BUS.register((Object)WorldGenGossipStones.INSTANCE);
        }
        String link = "https://raw.githubusercontent.com/coolAlias/ZeldaSwordSkills/master/src/main/resources/versionlist.json";
        FMLInterModComms.sendRuntimeMessage((Object)"zeldaswordskills", (String)"VersionChecker", (String)"addVersionCheck", (String)link);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Config.postInit();
        if (isBG2Enabled) {
            ItemHeroBow.registerBG2();
            MinecraftForge.EVENT_BUS.register((Object)new BattlegearEvents());
        }
        DungeonLootLists.init();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        ZSSItems.onServerStarting();
        ZSSCommands.registerCommands(event);
    }

    @Mod.EventHandler
    public void processMessages(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage msg : event.getMessages()) {
            WeaponRegistry.INSTANCE.processMessage(msg);
        }
    }

    static {
        logger = LogManager.getLogger((String)"zeldaswordskills");
        atlasHelper = new AntiqueAtlasHelper();
    }
}

