/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.api.client.animation;

import net.minecraft.client.model.ModelRenderer;
import zeldaswordskills.api.client.animation.AnimationBase;
import zeldaswordskills.api.client.animation.RotationAxis;

public abstract class AnimationWave
extends AnimationBase {
    protected static final float BASE = 0.3926991f;
    protected final RotationAxis axis;
    protected final float baseSpeed;
    protected final float magnitude;
    protected final float baseOffset;
    protected final ModelRenderer[] parts;

    public AnimationWave(RotationAxis axis, float speed, float magnitude, float frequency, ModelRenderer ... parts) {
        this.axis = axis;
        this.baseSpeed = speed;
        this.magnitude = magnitude;
        this.parts = parts;
        this.baseOffset = frequency > 0.0f ? (float)Math.PI / ((float)parts.length * frequency) : 0.0f;
    }

    @Override
    public boolean shouldApply(int frame, float partialTick, float speed) {
        return true;
    }

    @Override
    public final void apply(int frame, float partialTick, float speed, float multiplier, float offset, boolean invert) {
        invert &= this.allowInvert;
        multiplier = this.allowMultiplier ? multiplier : 1.0f;
        offset = this.allowOffset ? offset : 0.0f;
        speed = this.allowSpeed ? speed : 1.0f;
        float progress = speed * ((float)frame + partialTick);
        for (int i = 0; i < this.parts.length; ++i) {
            this.applyRotationToPart(i, progress, speed, multiplier, offset, invert);
        }
    }

    protected abstract void applyRotationToPart(int var1, float var2, float var3, float var4, float var5, boolean var6);

    protected float getMotionSin(float progress, float offset, float speed) {
        float motion = (float)Math.sin(progress * speed * this.baseSpeed + offset * this.baseOffset);
        return this.magnitude * 0.3926991f * motion;
    }

    protected float getMotionCos(float progress, float offset, float speed) {
        float motion = (float)Math.cos(progress * speed * this.baseSpeed + offset * this.baseOffset);
        return this.magnitude * 0.3926991f * motion;
    }

    public static class AnimationWaveCos
    extends AnimationWave {
        public AnimationWaveCos(RotationAxis axis, float speed, float magnitude, float frequency, ModelRenderer ... parts) {
            super(axis, speed, magnitude, frequency, parts);
        }

        @Override
        protected void applyRotationToPart(int index, float progress, float speed, float multiplier, float offset, boolean invert) {
            multiplier = invert ? -multiplier : multiplier;
            float motion = this.getMotionCos(progress, (float)index * offset, speed);
            this.axis.addRotation(this.parts[index], multiplier * motion);
        }
    }

    public static class AnimationWaveSin
    extends AnimationWave {
        public AnimationWaveSin(RotationAxis axis, float speed, float magnitude, float frequency, ModelRenderer ... parts) {
            super(axis, speed, magnitude, frequency, parts);
        }

        @Override
        protected void applyRotationToPart(int index, float progress, float speed, float multiplier, float offset, boolean invert) {
            multiplier = invert ? -multiplier : multiplier;
            float motion = this.getMotionSin(progress, (float)index * offset, speed);
            this.axis.addRotation(this.parts[index], multiplier * motion);
        }
    }
}

