/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.api.client.animation;

import net.minecraft.client.model.ModelRenderer;
import zeldaswordskills.api.client.animation.AnimationWave;
import zeldaswordskills.api.client.animation.RotationAxis;

public abstract class AnimationWaveTimed
extends AnimationWave {
    protected final float startFrame;
    protected final float endFrame;

    public AnimationWaveTimed(RotationAxis axis, int startFrame, int endFrame, float speed, float magnitude, float frequency, ModelRenderer ... parts) {
        super(axis, speed, magnitude, frequency, parts);
        this.startFrame = startFrame;
        this.endFrame = endFrame;
    }

    @Override
    public boolean shouldApply(int frame, float partialTick, float speed) {
        return (float)frame >= this.startFrame / speed && (float)frame <= this.endFrame / speed;
    }

    public static class AnimationWaveTimedCos
    extends AnimationWaveTimed {
        public AnimationWaveTimedCos(RotationAxis axis, int startFrame, int endFrame, float speed, float magnitude, float frequency, ModelRenderer ... parts) {
            super(axis, startFrame, endFrame, speed, magnitude, frequency, parts);
        }

        @Override
        protected void applyRotationToPart(int index, float progress, float speed, float multiplier, float offset, boolean invert) {
            multiplier = invert ? -multiplier : multiplier;
            float motion = this.getMotionCos(progress, (float)index * offset, speed);
            this.axis.addRotation(this.parts[index], multiplier * motion);
        }
    }

    public static class AnimationWaveTimedSin
    extends AnimationWaveTimed {
        public AnimationWaveTimedSin(RotationAxis axis, int startFrame, int endFrame, float speed, float magnitude, float frequency, ModelRenderer ... parts) {
            super(axis, startFrame, endFrame, speed, magnitude, frequency, parts);
        }

        @Override
        protected void applyRotationToPart(int index, float progress, float speed, float multiplier, float offset, boolean invert) {
            multiplier = invert ? -multiplier : multiplier;
            float motion = this.getMotionSin(progress, (float)index * offset, speed);
            this.axis.addRotation(this.parts[index], multiplier * motion);
        }
    }
}

