/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.api.entity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S27PacketExplosion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import zeldaswordskills.api.block.IExplodable;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.api.entity.IEntityBomb;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.entity.projectile.EntityBomb;
import zeldaswordskills.ref.Config;

public class CustomExplosion
extends Explosion {
    public boolean inflictsDamage = true;
    public boolean scalesWithDistance = true;
    public IgnoreLiquid ignoreLiquidType = IgnoreLiquid.NONE;
    public Block targetBlock = null;
    protected DamageSource source = null;
    protected float damage = 0.0f;
    protected int burnTime = 0;
    protected float motionFactor = 1.0f;
    protected static final int MAX_RADIUS = 16;
    protected float restrictExplosion = 1.0f;
    protected final Random rand = new Random();
    protected final World field_77287_j;
    protected Map<EntityPlayer, Vec3> affectedPlayers = new HashMap<EntityPlayer, Vec3>();

    public static DamageSource getExplosionSource(CustomExplosion explosion) {
        if (explosion.field_77283_e instanceof EntityThrowable) {
            return new EntityDamageSourceIndirect("explosion", explosion.field_77283_e, (Entity)((EntityThrowable)explosion.field_77283_e).func_85052_h()).func_94540_d().func_76351_m();
        }
        return DamageSource.func_94539_a((Explosion)explosion);
    }

    public static void createExplosion(World world, double x, double y, double z, float radius, BombType type) {
        CustomExplosion.createExplosion(new EntityBomb(world).setType(type), world, x, y, z, radius, 0.0f, true);
    }

    public static void createExplosion(IEntityBomb bomb, World world, double x, double y, double z, float radius, float damage, boolean canGrief) {
        CustomExplosion explosion = new CustomExplosion(world, (Entity)bomb, x, y, z, radius).setDamage(damage);
        BombType type = bomb.getType();
        boolean restrictBlocks = false;
        explosion.setMotionFactor(bomb.getMotionFactor());
        explosion.scalesWithDistance = damage == 0.0f;
        explosion.field_82755_b = canGrief;
        explosion.targetBlock = restrictBlocks || Config.onlyBombSecretStone() ? ZSSBlocks.secretStone : null;
        explosion.ignoreLiquidType = type.ignoreLiquidType;
        float f = bomb.getDestructionFactor();
        if (world.field_73011_w.field_76575_d && type != BombType.BOMB_FIRE) {
            f *= 0.5f;
        }
        explosion.restrictExplosionBy(f);
        explosion.func_77278_a();
        explosion.func_77279_a(true);
        if (bomb.hasPostExplosionEffect()) {
            type.postExplosionEffect(world, explosion);
        }
    }

    public CustomExplosion(World world, Entity exploder, double x, double y, double z, float explosionSize) {
        super(world, exploder, x, y, z, explosionSize);
        this.field_77287_j = world;
    }

    public CustomExplosion setSource(DamageSource source) {
        this.source = source;
        return this;
    }

    protected DamageSource getDamageSource() {
        return this.source != null ? this.source : CustomExplosion.getExplosionSource(this);
    }

    public CustomExplosion setDamage(float amount) {
        this.damage = amount;
        return this;
    }

    public CustomExplosion setBurnTime(int ticks) {
        this.burnTime = ticks;
        return this;
    }

    public CustomExplosion setMotionFactor(float amount) {
        this.motionFactor = amount;
        return this;
    }

    public CustomExplosion restrictExplosionBy(float factor) {
        this.restrictExplosion = factor;
        return this;
    }

    public void func_77278_a() {
        if (this.field_82755_b && this.restrictExplosion > 0.0f) {
            this.populateAffectedBlocksList();
        }
        if (this.inflictsDamage) {
            this.affectEntitiesWithin();
        }
    }

    public void func_77279_a(boolean spawnExtraParticles) {
        Block block;
        int k;
        int j;
        int i;
        this.field_77287_j.func_72908_a(this.field_77284_b, this.field_77285_c, this.field_77282_d, "random.explode", 4.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        if (this.field_77280_f >= 2.0f && this.field_82755_b) {
            this.field_77287_j.func_72869_a("hugeexplosion", this.field_77284_b, this.field_77285_c, this.field_77282_d, 1.0, 0.0, 0.0);
        } else {
            this.field_77287_j.func_72869_a("largeexplode", this.field_77284_b, this.field_77285_c, this.field_77282_d, 1.0, 0.0, 0.0);
        }
        if (this.field_82755_b) {
            for (ChunkPosition chunkposition : this.field_77281_g) {
                i = chunkposition.field_151329_a;
                j = chunkposition.field_151327_b;
                k = chunkposition.field_151328_c;
                block = this.field_77287_j.func_147439_a(i, j, k);
                this.explodeBlockAt(block, i, j, k, spawnExtraParticles);
            }
        }
        if (this.field_77286_a) {
            for (ChunkPosition chunkposition : this.field_77281_g) {
                i = chunkposition.field_151329_a;
                j = chunkposition.field_151327_b;
                k = chunkposition.field_151328_c;
                block = this.field_77287_j.func_147439_a(i, j, k);
                Block block1 = this.field_77287_j.func_147439_a(i, j - 1, k);
                if (block != Blocks.field_150350_a || !block1.func_149730_j() || this.rand.nextInt(3) != 0) continue;
                this.field_77287_j.func_147449_b(i, j, k, (Block)Blocks.field_150480_ab);
            }
        }
        this.notifyClients();
    }

    private void explodeBlockAt(Block block, int i, int j, int k, boolean spawnExtraParticles) {
        if (spawnExtraParticles) {
            double d0 = (float)i + this.field_77287_j.field_73012_v.nextFloat();
            double d1 = (float)j + this.field_77287_j.field_73012_v.nextFloat();
            double d2 = (float)k + this.field_77287_j.field_73012_v.nextFloat();
            double d3 = d0 - this.field_77284_b;
            double d4 = d1 - this.field_77285_c;
            double d5 = d2 - this.field_77282_d;
            double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
            d3 /= d6;
            d4 /= d6;
            d5 /= d6;
            double d7 = 0.5 / (d6 / (double)this.field_77280_f + 0.1);
            this.field_77287_j.func_72869_a("explode", (d0 + this.field_77284_b * 1.0) / 2.0, (d1 + this.field_77285_c * 1.0) / 2.0, (d2 + this.field_77282_d * 1.0) / 2.0, d3 *= (d7 *= (double)(this.field_77287_j.field_73012_v.nextFloat() * this.field_77287_j.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7);
            this.field_77287_j.func_72869_a("smoke", d0, d1, d2, d3, d4, d5);
        }
        if (block.func_149688_o() != Material.field_151579_a) {
            if (block.func_149659_a((Explosion)this)) {
                block.func_149690_a(this.field_77287_j, i, j, k, this.field_77287_j.func_72805_g(i, j, k), 1.0f / this.field_77280_f, 0);
            }
            block.onBlockExploded(this.field_77287_j, i, j, k, (Explosion)this);
        }
    }

    protected void populateAffectedBlocksList() {
        HashSet<ChunkPosition> hashset = new HashSet<ChunkPosition>();
        float radius = Math.min(this.field_77280_f * this.restrictExplosion, 16.0f);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    if (i != 0 && i != 15 && j != 0 && j != 15 && k != 0 && k != 15) continue;
                    double d3 = (float)i / 15.0f * 2.0f - 1.0f;
                    double d4 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d5 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d6 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d0 = this.field_77284_b;
                    double d1 = this.field_77285_c;
                    double d2 = this.field_77282_d;
                    float f2 = 0.3f;
                    for (float f1 = radius * (0.7f + this.field_77287_j.field_73012_v.nextFloat() * 0.6f); f1 > 0.0f; f1 -= f2 * 0.75f) {
                        int j1;
                        int i1;
                        int l = MathHelper.func_76128_c((double)d0);
                        Block block = this.field_77287_j.func_147439_a(l, i1 = MathHelper.func_76128_c((double)d1), j1 = MathHelper.func_76128_c((double)d2));
                        if (block.func_149688_o() != Material.field_151579_a) {
                            boolean flag;
                            boolean bl = flag = !block.func_149688_o().func_76224_d() || this.ignoreLiquidType == IgnoreLiquid.NONE || this.ignoreLiquidType == IgnoreLiquid.WATER && block.func_149688_o() != Material.field_151586_h || this.ignoreLiquidType == IgnoreLiquid.LAVA && block.func_149688_o() != Material.field_151587_i;
                            if (flag) {
                                float f3 = this.field_77283_e != null ? this.field_77283_e.func_145772_a((Explosion)this, this.field_77287_j, l, i1, j1, block) : block.getExplosionResistance(this.field_77283_e, this.field_77287_j, l, i1, j1, this.field_77284_b, this.field_77285_c, this.field_77282_d);
                                f1 -= (f3 + 0.3f) * f2;
                            }
                        }
                        if (f1 > 0.0f && (this.targetBlock == null || block == this.targetBlock || block instanceof IExplodable) && (this.field_77283_e == null || this.field_77283_e.func_145774_a((Explosion)this, this.field_77287_j, l, i1, j1, block, f1))) {
                            hashset.add(new ChunkPosition(l, i1, j1));
                        }
                        d0 += d3 * (double)f2;
                        d1 += d4 * (double)f2;
                        d2 += d5 * (double)f2;
                    }
                }
            }
        }
        this.field_77281_g.addAll(hashset);
    }

    protected void affectEntitiesWithin() {
        float diameter = this.field_77280_f * 2.0f;
        int i = MathHelper.func_76128_c((double)(this.field_77284_b - (double)this.field_77280_f - 1.0));
        int j = MathHelper.func_76128_c((double)(this.field_77284_b + (double)this.field_77280_f + 1.0));
        int k = MathHelper.func_76128_c((double)(this.field_77285_c - (double)this.field_77280_f - 1.0));
        int l1 = MathHelper.func_76128_c((double)(this.field_77285_c + (double)this.field_77280_f + 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.field_77282_d - (double)this.field_77280_f - 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.field_77282_d + (double)this.field_77280_f + 1.0));
        List list = this.field_77287_j.func_72839_b(this.field_77283_e, AxisAlignedBB.func_72330_a((double)i, (double)k, (double)i2, (double)j, (double)l1, (double)j2));
        Vec3 vec3 = Vec3.func_72443_a((double)this.field_77284_b, (double)this.field_77285_c, (double)this.field_77282_d);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            float amount;
            double d2;
            double d1;
            double d0;
            double d8;
            double d7;
            Entity entity = (Entity)list.get(k2);
            double d = d7 = this.scalesWithDistance ? entity.func_70011_f(this.field_77284_b, this.field_77285_c, this.field_77282_d) / (double)diameter : 0.0;
            if (!(d7 <= 1.0) || (d8 = (double)MathHelper.func_76133_a((double)((d0 = entity.field_70165_t - this.field_77284_b) * d0 + (d1 = entity.field_70163_u + (double)entity.func_70047_e() - this.field_77285_c) * d1 + (d2 = entity.field_70161_v - this.field_77282_d) * d2))) == 0.0) continue;
            d0 /= d8;
            d1 /= d8;
            d2 /= d8;
            double d9 = this.field_77287_j.func_72842_a(vec3, entity.field_70121_D);
            double d10 = (1.0 - d7) * d9;
            float f = amount = this.damage == 0.0f ? (float)((int)((d10 * d10 + d10) / 2.0 * 8.0 * (double)diameter + 1.0)) : this.damage * (float)d10;
            if (entity.func_70097_a(this.getDamageSource(), amount) && this.field_77286_a && !entity.func_70045_F() && (!this.scalesWithDistance || (double)this.rand.nextFloat() < d10)) {
                entity.func_70015_d(this.burnTime);
            }
            double d11 = EnchantmentProtection.func_92092_a((Entity)entity, (double)d10);
            entity.field_70159_w += d0 * d11 * (double)this.motionFactor;
            entity.field_70181_x += d1 * d11 * (double)this.motionFactor;
            entity.field_70179_y += d2 * d11 * (double)this.motionFactor;
            if (!(entity instanceof EntityPlayer)) continue;
            this.affectedPlayers.put((EntityPlayer)entity, Vec3.func_72443_a((double)(d0 * d10), (double)(d1 * d10), (double)(d2 * d10)));
        }
    }

    public Map func_77277_b() {
        return this.affectedPlayers;
    }

    protected void notifyClients() {
        if (!this.field_77287_j.field_72995_K) {
            for (EntityPlayer player : this.field_77287_j.field_73010_i) {
                if (!(player.func_70092_e(this.field_77284_b, this.field_77285_c, this.field_77282_d) < 4096.0)) continue;
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S27PacketExplosion(this.field_77284_b, this.field_77285_c, this.field_77282_d, this.field_77280_f, this.field_77281_g, (Vec3)this.func_77277_b().get(player)));
            }
        }
    }

    public static enum IgnoreLiquid {
        NONE,
        ALL,
        WATER,
        LAVA;

    }
}

